/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.utils;

import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.statcato.file.DownloadFile;
import org.statcato.file.ExtensionFileFilter;
import org.statcato.spreadsheet.Cell;

public class HelperFunctions {
    public static boolean isEmptyVector(Vector vec) {
        if (vec == null) {
            return true;
        }
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            if (e.nextElement() == null) continue;
            return false;
        }
        return true;
    }

    public static double[] ConvertDoubleVectorToArray(Vector<Double> vector) {
        double[] arr = new double[vector.size()];
        for (int j = 0; j < arr.length; ++j) {
            arr[j] = vector.elementAt(j);
        }
        return arr;
    }

    public static double[] ConvertDoubleArrayListToArray(ArrayList<Double> arrayList) {
        double[] arr = new double[arrayList.size()];
        for (int j = 0; j < arr.length; ++j) {
            arr[j] = arrayList.get(j);
        }
        return arr;
    }

    public static int[] ConvertIntegerVectorToArray(Vector<Integer> vector) {
        if (vector == null) {
            return new int[0];
        }
        int[] arr = new int[vector.size()];
        for (int j = 0; j < arr.length; ++j) {
            arr[j] = vector.elementAt(j);
        }
        return arr;
    }

    public static Vector<Double> ConvertInputVectorToDoubles(Vector<Cell> vector) {
        Vector<Double> outputVector = new Vector<Double>();
        Enumeration<Cell> e = vector.elements();
        while (e.hasMoreElements()) {
            Cell elm = e.nextElement();
            if (elm.getContents().equals("")) {
                outputVector.addElement(null);
                continue;
            }
            Double value = elm.getNumValue();
            if (value == null) {
                return null;
            }
            outputVector.addElement(value);
        }
        return outputVector;
    }

    public static Vector<Double> ComputeDiffVector(Vector<Double> vector1, Vector<Double> vector2) {
        Vector<Double> diffVector = new Vector<Double>();
        for (int i = 0; i < vector1.size(); ++i) {
            if (vector1.elementAt(i) != null) {
                double num1 = vector1.elementAt(i);
                if (vector2.elementAt(i) != null) {
                    double num2 = vector2.elementAt(i);
                    diffVector.addElement(num1 - num2);
                    continue;
                }
                return null;
            }
            if (vector2.elementAt(i) == null) continue;
            return null;
        }
        return diffVector;
    }

    public static void printVector(Vector vec) {
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            System.out.print(e.nextElement());
            System.out.print(", ");
        }
        System.out.println("");
    }

    public static String printVectorToString(Vector vec) {
        String s = "";
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            s = s + e.nextElement();
            s = s + ", ";
        }
        if (s.length() > 3) {
            return s.substring(0, s.length() - 2);
        }
        return "";
    }

    public static String printDoubleVectorToString(Vector<Double> vec) {
        String s = "";
        Enumeration<Double> e = vec.elements();
        while (e.hasMoreElements()) {
            Double value = e.nextElement();
            s = value == null ? s + "   " : s + String.format("%.4f", (double)value);
            s = s + ", ";
        }
        if (s.length() > 3) {
            return s.substring(0, s.length() - 2);
        }
        return "";
    }

    public static void printVectors(Vector<Vector<Cell>> vec) {
        int numCols = vec.size();
        int numRows = vec.elementAt(0).size();
        boolean hasData = false;
        for (int row = 0; row < numRows; ++row) {
            hasData = false;
            for (int col = 0; col < numCols; ++col) {
                Cell cell = vec.elementAt(col).elementAt(row);
                if (cell == null) continue;
                System.out.print(vec.elementAt(col).elementAt(row).toString() + " ");
                if (vec.elementAt(col).elementAt(row).toString().equals("")) continue;
                hasData = true;
            }
            if (!hasData) continue;
            System.out.print("\n");
        }
        System.out.println("");
    }

    public static String convertVectorToString(Vector vec) {
        String str = "";
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            str = str + e.nextElement().toString() + " ";
        }
        return str;
    }

    public static Object[] ConvertInputVectorToNumbers(Vector<Cell> vector) {
        Vector<Double> outputVector = new Vector<Double>();
        int nonmissing = 0;
        int missing = 0;
        int numMissingSinceLastNonmissing = 0;
        Enumeration<Cell> e = vector.elements();
        while (e.hasMoreElements()) {
            Cell elm = e.nextElement();
            if (elm.getContents().equals("")) {
                ++numMissingSinceLastNonmissing;
                continue;
            }
            if (elm.getNumValue() == null) {
                return null;
            }
            outputVector.addElement(elm.getNumValue());
            ++nonmissing;
            missing += numMissingSinceLastNonmissing;
            numMissingSinceLastNonmissing = 0;
        }
        Object[] outputs = new Object[]{outputVector, new Integer(missing), new Integer(nonmissing)};
        return outputs;
    }

    public static Vector<String> ConvertCellVectorToStringVector(Vector<Cell> vector) {
        vector = HelperFunctions.removeEndingEmptyCells(vector);
        Vector<String> outputVector = new Vector<String>();
        Enumeration<Cell> e = vector.elements();
        while (e.hasMoreElements()) {
            Cell elm = e.nextElement();
            String c = elm.getContents();
            outputVector.addElement(c);
        }
        return outputVector;
    }

    public static Object[] ConvertInputVectorToNumbers2(Vector<Cell> vector) {
        Vector<Double> outputVector = new Vector<Double>(0);
        int nonmissing = 0;
        Enumeration<Cell> e = vector.elements();
        while (e.hasMoreElements()) {
            Cell elm = e.nextElement();
            if (!elm.hasData()) continue;
            if (!elm.isNumeric()) {
                return null;
            }
            outputVector.addElement(elm.getNumValue());
            ++nonmissing;
        }
        Object[] outputs = new Object[]{outputVector, new Integer(vector.size() - nonmissing), new Integer(nonmissing)};
        return outputs;
    }

    public static Vector<String> ConvertDoubleVectorToString(Vector<Double> vector) {
        Vector<String> outputVector = new Vector<String>(0);
        Enumeration<Double> e = vector.elements();
        while (e.hasMoreElements()) {
            Double elm = e.nextElement();
            if (elm == null) {
                outputVector.addElement("");
                continue;
            }
            double num = elm;
            outputVector.addElement(num + "");
        }
        return outputVector;
    }

    public static Vector<Double> removeNullValues(Vector<Double> numbers) {
        if (numbers == null) {
            return null;
        }
        Vector<Double> vec = new Vector<Double>(0);
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) == null) continue;
            vec.addElement(numbers.elementAt(i));
        }
        return vec;
    }

    public static Vector<Double> removeEndingNullValues(Vector<Double> numbers) {
        Vector vec = (Vector)numbers.clone();
        for (int i = numbers.size() - 1; i >= 0 && numbers.elementAt(i) == null; --i) {
            vec.removeElementAt(i);
        }
        return vec;
    }

    public static Vector<Cell> removeEndingEmptyCells(Vector<Cell> vector) {
        Vector vec = (Vector)vector.clone();
        for (int i = vector.size() - 1; i >= 0 && vector.elementAt(i).getContents().equals(""); --i) {
            vec.removeElementAt(i);
        }
        return vec;
    }

    public static Vector<Cell> removeNullCells(Vector<Cell> numbers) {
        Vector<Cell> vec = new Vector<Cell>(0);
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i).getContents().equals("")) continue;
            vec.addElement(numbers.elementAt(i));
        }
        return vec;
    }

    public static Vector<Double> powerVector(Vector<Double> numbers, int power) {
        Vector<Double> vec = new Vector<Double>(0);
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) == null) continue;
            vec.addElement(Math.pow(numbers.elementAt(i), power));
        }
        return vec;
    }

    public static Vector<Double> powerVector(Vector<Double> numbers, double power) {
        Vector<Double> vec = new Vector<Double>(0);
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) == null) continue;
            vec.addElement(Math.pow(numbers.elementAt(i), power));
        }
        return vec;
    }

    public static Vector<Double> logVector(Vector<Double> numbers) {
        Vector<Double> vec = new Vector<Double>(0);
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) == null) continue;
            vec.addElement(Math.log(numbers.elementAt(i)));
        }
        return vec;
    }

    public static Vector<Double> addConstantVector(Vector<Double> numbers, double c) {
        Vector<Double> vec = new Vector<Double>(0);
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) == null) continue;
            vec.addElement(numbers.elementAt(i) + c);
        }
        return vec;
    }

    public static void writeFile(JFrame frame, String extensionDescription, String extension, String contents) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new ExtensionFileFilter(extensionDescription, extension));
        fc.setAcceptAllFileFilterUsed(false);
        extension = extension.toLowerCase();
        int returnValue = fc.showSaveDialog(frame);
        if (returnValue == 0) {
            File file = fc.getSelectedFile();
            String path = file.getPath();
            if (!path.toLowerCase().endsWith("." + extension)) {
                path = path + "." + extension;
                file = new File(path);
            }
            if (file.exists()) {
                System.out.println("file exists already");
                Object[] options = new Object[]{"Overwrite file", "Cancel"};
                int choice = JOptionPane.showOptionDialog(frame, "The specified file already exists.  Overwrite existing file?", "Overwrite file?", 0, 2, null, options, options[1]);
                if (choice != 0) {
                    return;
                }
            }
            try {
                BufferedWriter Writer2 = new BufferedWriter(new FileWriter(path));
                String[] lines = contents.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    Writer2.write(lines[i]);
                    Writer2.newLine();
                }
                Writer2.close();
            }
            catch (IOException e) {
                HelperFunctions.showErrorDialog(frame, "Write file failed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContents(File file) {
        StringBuffer contents = new StringBuffer();
        try (BufferedReader input = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append("\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }

    public static String parseCSV(String str) {
        String out = "";
        String[] lines = str.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] values = lines[i].split(",");
            for (int j = 0; j < values.length; ++j) {
                out = out + values[j] + "\t";
            }
            out = out + "\n";
        }
        return out;
    }

    public static Vector<String> readExcelFile(File file) {
        FileInputStream stream;
        HSSFWorkbook _wb = null;
        String out = "";
        Vector<String> strings = new Vector<String>();
        try {
            stream = new FileInputStream(file);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)stream);
            _wb = new HSSFWorkbook(fs);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        for (int i = 0; i < _wb.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = _wb.getSheetAt(i);
            out = "";
            for (int r = 0; r <= sheet.getLastRowNum(); ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row != null) {
                    for (int c = 0; c <= row.getLastCellNum(); ++c) {
                        HSSFCell cell = row.getCell((short)c);
                        String value = HelperFunctions.getCellValue(cell);
                        out = out + value + "\t";
                    }
                }
                out = out + "\n";
            }
            strings.addElement(out);
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return strings;
    }

    public static String getCellValue(HSSFCell cell) {
        String str;
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 0: {
                str = String.valueOf(cell.getNumericCellValue());
                double dnum = Double.parseDouble(str);
                str = String.valueOf(dnum);
                break;
            }
            case 1: {
                str = cell.getStringCellValue();
                break;
            }
            case 3: {
                str = "";
                break;
            }
            case 4: {
                str = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 2: {
                str = String.valueOf(cell.getNumericCellValue());
                double dnum = Double.parseDouble(str);
                str = String.valueOf(dnum);
                break;
            }
            default: {
                System.out.println("Not a supported cell type");
                str = "";
            }
        }
        return str;
    }

    public static void showErrorDialog(JFrame frame, String message) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(frame, message, "Error", 0);
    }

    public static String getDateTime() {
        Date date = new Date();
        return DateFormat.getInstance().format(date);
    }

    public static String formatFloat2(double num) {
        if (num == 0.0) {
            return "0";
        }
        return String.format("%.3f", num);
    }

    public static String formatFloat(double num) {
        if (num == 0.0) {
            return "0";
        }
        if (Math.abs(num) < 0.001) {
            String str = String.format("%8.3e", num);
            return HelperFunctions.convertScientificNotation(str);
        }
        return HelperFunctions.formatDecimal(num, 3);
    }

    public static String formatFloat(Double num) {
        return HelperFunctions.formatFloat((double)num);
    }

    public static String formatFloat(double num, int places) {
        return HelperFunctions.formatDecimal(num, places);
    }

    private static String convertScientificNotation(String num) {
        String text = "" + num;
        int eLocation = (text = text.toLowerCase()).indexOf(101);
        if (eLocation != -1) {
            double mantissa = Double.parseDouble(text.substring(0, eLocation));
            int exponent = Integer.parseInt(text.substring(eLocation + 1, text.length()));
            text = mantissa + "&nbsp;&middot;&nbsp;10<sup>" + exponent + "</sup>";
        }
        return text;
    }

    private static String formatDecimal(double num, int places) {
        if (num == 0.0) {
            return "0";
        }
        if (Math.abs(num) < Math.pow(10.0, -places)) {
            String str = String.format("%." + places + "e", num);
            return HelperFunctions.convertScientificNotation(str);
        }
        String str = num + "";
        int ptLocation = str.indexOf(46);
        if (ptLocation == -1) {
            return num + "";
        }
        if (str.length() - ptLocation - 1 < places) {
            return num + "";
        }
        return String.format("%." + places + "f", num);
    }

    public static Object[] splitValuesVectorByLabels(Vector<Cell> Labels, Vector<Cell> Values2) throws Exception {
        String cat1 = "";
        String cat2 = "";
        Vector<Cell> vector1 = new Vector<Cell>();
        Vector<Cell> vector2 = new Vector<Cell>();
        for (int i = 0; i < Labels.size(); ++i) {
            String s = Labels.elementAt(i).getContents().trim();
            if (s.equals("")) continue;
            if (cat1.equals("")) {
                cat1 = s;
                vector1.addElement(Values2.elementAt(i));
                continue;
            }
            if (s.equals(cat1)) {
                vector1.addElement(Values2.elementAt(i));
                continue;
            }
            if (cat2.equals("")) {
                cat2 = s;
                vector2.addElement(Values2.elementAt(i));
                continue;
            }
            if (s.equals(cat2)) {
                vector2.addElement(Values2.elementAt(i));
                continue;
            }
            throw new Exception("The input column contains more than two populations.");
        }
        Object[] returnValues = new Object[]{cat1, vector1, cat2, vector2};
        return returnValues;
    }

    public static Object[] splitValuesVector(Vector<Cell> Values2) throws Exception {
        String cat1 = "";
        String cat2 = "";
        Vector<Cell> vector1 = new Vector<Cell>();
        Vector<Cell> vector2 = new Vector<Cell>();
        for (int i = 0; i < Values2.size(); ++i) {
            String s = Values2.elementAt(i).getContents().trim();
            if (s.equals("")) continue;
            if (cat1.equals("")) {
                cat1 = s;
                vector1.addElement(Values2.elementAt(i));
                continue;
            }
            if (s.equals(cat1)) {
                vector1.addElement(Values2.elementAt(i));
                continue;
            }
            if (cat2.equals("")) {
                cat2 = s;
                vector2.addElement(Values2.elementAt(i));
                continue;
            }
            if (s.equals(cat2)) {
                vector2.addElement(Values2.elementAt(i));
                continue;
            }
            throw new Exception("The input column contains more than two categories.");
        }
        Object[] returnValues = new Object[]{cat1, vector1, cat2, vector2};
        return returnValues;
    }

    public static Object[] ComputeCategoryFrequency(Vector<Cell> vec) {
        TreeMap<String, Integer> hash = new TreeMap<String, Integer>();
        Enumeration<Cell> e = vec.elements();
        while (e.hasMoreElements()) {
            String cat = e.nextElement().getContents();
            if (hash.containsKey(cat)) {
                int count = (Integer)hash.get(cat) + 1;
                hash.put(cat, new Integer(count));
                continue;
            }
            hash.put(cat, new Integer(1));
        }
        Vector<Cell> categories = new Vector<Cell>();
        Vector<Double> frequencies = new Vector<Double>();
        int i = 0;
        Set set = hash.keySet();
        for (String cat : set) {
            int count = (Integer)hash.get(cat);
            categories.addElement(new Cell(cat, 0, 0));
            frequencies.addElement(new Double(count));
            ++i;
        }
        Object[] returnValues = new Object[]{categories, frequencies};
        return returnValues;
    }

    public static TreeMap ComputeFrequency(Vector<Double> vec) {
        TreeMap<Double, Integer> hash = new TreeMap<Double, Integer>();
        Enumeration<Double> e = vec.elements();
        while (e.hasMoreElements()) {
            Double cat = e.nextElement();
            if (cat == null) continue;
            if (hash.containsKey(cat)) {
                int count = (Integer)hash.get(cat) + 1;
                hash.put(cat, new Integer(count));
                continue;
            }
            hash.put(cat, new Integer(1));
        }
        return hash;
    }

    public static Vector<Double> ComputeClassFrequency(Vector<Double> column, Vector<Double> limits) {
        Vector<Double> frequencies = new Vector<Double>();
        double limit = -1.0;
        double lastLimit = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < limits.size(); ++i) {
            limit = limits.elementAt(i);
            count = 0;
            for (int j = 0; j < column.size(); ++j) {
                double num = column.elementAt(j);
                if (!(num <= limit) || !(num > lastLimit)) continue;
                ++count;
            }
            frequencies.addElement(new Double(count));
            lastLimit = limit;
        }
        count = 0;
        for (int j = 0; j < column.size(); ++j) {
            double num = column.elementAt(j);
            if (!(num > lastLimit)) continue;
            ++count;
        }
        frequencies.addElement(new Double(count));
        return frequencies;
    }

    public static Vector<String> parseString(String str) {
        Vector<String> result = new Vector<String>();
        int i = 0;
        String value = "";
        while (i < str.length()) {
            if (Character.isWhitespace(str.charAt(i))) {
                if (!value.equals("")) {
                    result.addElement(value);
                    value = "";
                }
                ++i;
                continue;
            }
            if (str.charAt(i) == '\"') {
                if (!value.equals("")) {
                    result.addElement(value);
                    value = "";
                }
                ++i;
                while (str.charAt(i) != '\"') {
                    value = value + str.charAt(i);
                    ++i;
                }
                ++i;
                if (value.equals("")) continue;
                result.addElement(value);
                value = "";
                continue;
            }
            value = value + str.charAt(i);
            ++i;
        }
        if (!value.equals("")) {
            result.addElement(value);
        }
        return result;
    }

    public static int getNumDecimalPlaces(String s) {
        int decLoc = s.indexOf(46);
        if (decLoc != -1) {
            return s.length() - decLoc - 1;
        }
        return 0;
    }

    public static String getVersionNumberFromWeb() {
        String currentDirStr = "";
        File currentDir = new File(".");
        try {
            currentDirStr = currentDir.getCanonicalPath();
        }
        catch (IOException e) {
            return "error";
        }
        DownloadFile d = new DownloadFile("http://www.statcato.org/versions/current.txt");
        String filename = d.download();
        if (filename == null) {
            return "error";
        }
        File file = new File(filename);
        String contents = HelperFunctions.getFileContents(file);
        boolean success = file.delete();
        if (!success) {
            System.out.println("cannot delete temp file");
        }
        return contents.trim();
    }

    public static String getCurrentTimeString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        return dateFormat.format(date);
    }
}

