/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential.nonparametrics;

import java.util.Vector;
import org.statcato.statistics.ChiSquareProbabilityDistribution;
import org.statcato.utils.HelperFunctions;
import org.statcato.utils.OrderingFunctions;

public class KruskalWallisTest {
    private int[] n;
    private double[] R;
    private int N;
    private int k;
    public double significance;

    public KruskalWallisTest(Vector<Vector<Double>> data, double significance) {
        this.significance = significance;
        this.k = data.size();
        this.n = new int[this.k];
        this.R = new double[this.k];
        this.computeRankSum(data);
        this.N = 0;
        for (int i = 0; i < data.size(); ++i) {
            this.n[i] = data.elementAt(i).size();
            this.N += this.n[i];
        }
    }

    public double testStatistic() {
        double sum = 0.0;
        for (int i = 0; i < this.k; ++i) {
            sum += this.R[i] * this.R[i] / (double)this.n[i];
        }
        return sum * 12.0 / (double)this.N / (double)(this.N + 1) - (double)(3 * (this.N + 1));
    }

    public int DOF() {
        return this.k - 1;
    }

    public double pValue() {
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.DOF());
        double ts = this.testStatistic();
        return 1.0 - dist.cumulativeProbability(ts);
    }

    public double criticalValue() {
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.DOF());
        return dist.inverseCumulativeProbability(1.0 - this.significance);
    }

    public String toString() {
        int i;
        String s = "";
        boolean hasSmallSample = false;
        double totalRanks = 0.0;
        s = s + "Kruskal-Wallis Test: <br>";
        s = s + "<table border='1'>";
        s = s + "<tr><th>Sample</th>";
        for (i = 0; i < this.k; ++i) {
            s = s + "<th>" + (i + 1) + "</th>";
        }
        s = s + "<th>Total</th></tr>";
        s = s + "<tr><th>Sample Size</th>";
        for (i = 0; i < this.k; ++i) {
            s = s + "<td>" + this.n[i];
            if (this.n[i] < 5) {
                s = s + "*";
                hasSmallSample = true;
            }
            s = s + "</td>";
        }
        s = s + "<td>" + this.N + "</td>";
        s = s + "</tr><tr><th>Rank Sum</th>";
        for (i = 0; i < this.k; ++i) {
            s = s + "<td>" + this.R[i] + "</td>";
            totalRanks += this.R[i];
        }
        s = s + "<td>" + totalRanks + "</td></tr>";
        s = s + "</table><br>";
        s = s + "<table border='1'>";
        s = s + "<tr>";
        s = s + "<th>DOF</th><th>Test Statistics H</th><th>Critical Value</th><th>p-Value</th>";
        s = s + "</tr><tr>";
        s = s + "<td>" + this.DOF() + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.testStatistic(), 3) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.criticalValue(), 3) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.pValue(), 5) + "</td>";
        s = s + "</tr>";
        s = s + "</table>";
        if (hasSmallSample) {
            s = s + "* - small samples (&le; 5)<br>";
        }
        return s;
    }

    public void computeRankSum(Vector<Vector<Double>> data) {
        Vector<Double> dataVector = new Vector<Double>();
        for (int i = 0; i < data.size(); ++i) {
            Vector<Double> sample = data.elementAt(i);
            for (int j = 0; j < sample.size(); ++j) {
                Double value = sample.elementAt(j);
                if (value == null) continue;
                dataVector.add(value);
            }
        }
        double[] ranks = OrderingFunctions.rankDoubleVector(dataVector);
        for (int i = 0; i < data.size(); ++i) {
            double rankSum = 0.0;
            Vector<Double> sample = data.elementAt(i);
            this.n[i] = sample.size();
            for (int j = 0; j < sample.size(); ++j) {
                Double value = sample.elementAt(j);
                if (value == null) continue;
                rankSum += ranks[dataVector.indexOf(value)];
            }
            this.R[i] = rankSum;
        }
    }
}

