/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import Jama.Matrix;
import java.util.Vector;
import org.statcato.statistics.FProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class MultipleRegression {
    private int n;
    private int k;
    private Matrix A;
    private Matrix x;
    private Matrix b;
    private boolean hasConstant;

    public MultipleRegression(Vector<Vector<Double>> IndependentVars, Vector<Double> DependentVar, boolean hasConstant) {
        this.n = DependentVar.size();
        this.k = IndependentVars.size();
        this.hasConstant = hasConstant;
        int offset = hasConstant ? 1 : 0;
        double[][] matrix = new double[this.n][offset + this.k];
        for (int i = 0; i < this.n; ++i) {
            matrix[i][0] = 1.0;
        }
        for (int col = 0; col < this.k; ++col) {
            for (int row = 0; row < this.n; ++row) {
                double a;
                matrix[row][col + offset] = a = Double.valueOf(IndependentVars.elementAt(col).elementAt(row)).doubleValue();
            }
        }
        this.A = new Matrix(matrix);
        double[][] array = new double[this.n][1];
        for (int i = 0; i < DependentVar.size(); ++i) {
            array[i][0] = DependentVar.elementAt(i);
        }
        this.b = new Matrix(array);
        try {
            this.x = this.A.solve(this.b);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Multiple regression cannot be performed on a rank deficient matrix.");
        }
    }

    public Matrix RegressionEqCoefficients() {
        return this.x;
    }

    public double YPredicted(Matrix var) {
        double y = this.hasConstant ? this.x.get(0, 0) : 0.0;
        int offset = this.hasConstant ? 1 : 0;
        for (int i = 0; i < this.k; ++i) {
            y += Double.valueOf(var.get(0, i)) * this.x.get(i + offset, 0);
        }
        return y;
    }

    private double YAverage() {
        double sum = 0.0;
        for (int i = 0; i < this.n; ++i) {
            sum += this.b.get(i, 0);
        }
        return sum / (double)this.n;
    }

    public double TotalVariation() {
        double yAverage = this.YAverage();
        double total = 0.0;
        for (int i = 0; i < this.n; ++i) {
            total += Math.pow(this.b.get(i, 0) - yAverage, 2.0);
        }
        return total;
    }

    public Matrix XVar(int i) {
        if (this.hasConstant) {
            return this.A.getMatrix(i, i, 1, this.k);
        }
        return this.A.getMatrix(i, i, 0, this.k - 1);
    }

    public double ExplainedVariation() {
        double yAverage = this.YAverage();
        double total = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double yPredicted = this.YPredicted(this.XVar(i));
            total += Math.pow(yPredicted - yAverage, 2.0);
        }
        return total;
    }

    public double UnexplainedVariation() {
        double total = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double yPredicted = this.YPredicted(this.XVar(i));
            total += Math.pow(yPredicted - this.b.get(i, 0), 2.0);
        }
        return total;
    }

    public double CoefficientOfDetermination() {
        return this.ExplainedVariation() / this.TotalVariation();
    }

    public double AdjustedCoefficientOfDetermination() {
        double r2 = this.CoefficientOfDetermination();
        return 1.0 - (double)(this.n - 1) * (1.0 - r2) / (double)(this.n - this.k - 1);
    }

    public double StandardError() {
        return Math.sqrt(this.UnexplainedVariation() / (double)(this.n - this.k - 1));
    }

    public double TestStatistics() {
        double unexplained = this.UnexplainedVariation();
        if (unexplained == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.ExplainedVariation() / this.UnexplainedVariation() * (double)(this.n - this.k - 1) / (double)this.k;
    }

    public double PValue() {
        double ts = this.TestStatistics();
        if (ts == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        FProbabilityDistribution dist = new FProbabilityDistribution(this.k, this.n - this.k - 1);
        double area = dist.cumulativeProbability(ts);
        return 1.0 - area;
    }

    public int SampleSize() {
        return this.n;
    }

    public int NumIndepVar() {
        return this.k;
    }

    public String toString() {
        String text = "";
        text = text + "Sample size = " + this.SampleSize() + "<br>";
        text = text + "<br>";
        text = text + "<u>Variation</u>:<br>";
        text = text + "Explained variation = " + HelperFunctions.formatFloat(this.ExplainedVariation(), 4) + "<br>";
        text = text + "Unexplained variation = " + HelperFunctions.formatFloat(this.UnexplainedVariation(), 4) + "<br>";
        text = text + "Total variation = " + HelperFunctions.formatFloat(this.TotalVariation(), 4) + "<br>";
        text = text + "Coefficient of determination r<sup>2</sup> = " + HelperFunctions.formatFloat(this.CoefficientOfDetermination(), 4) + "<br>";
        text = text + "Standard error of estimate = " + HelperFunctions.formatFloat(this.StandardError(), 4) + "<br>";
        text = text + "Test statistics F = " + HelperFunctions.formatFloat(this.TestStatistics(), 4) + "<br>";
        text = text + "p-Value = " + HelperFunctions.formatFloat(this.PValue(), 4) + "<br>";
        return text;
    }
}

