/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.StudentTProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;

public class HypothesisTest1MeanSigmaUnknown {
    int n;
    double mu;
    double s;
    double confidenceLevel;
    int testType;

    public HypothesisTest1MeanSigmaUnknown(int n, double mu, double s, double confidenceLevel, int testType) {
        this.n = n;
        this.mu = mu;
        this.s = s;
        this.confidenceLevel = confidenceLevel;
        this.testType = testType;
    }

    public double testStatistics(double xBar) {
        return (xBar - this.mu) / (this.s / Math.sqrt(this.n));
    }

    public String criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(this.n - 1);
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha), 3);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha), 3);
        }
        return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha / 2.0), 3) + ", " + HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha / 2.0), 3);
    }

    public double pValue(double xBar) {
        double ts = this.testStatistics(xBar);
        StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(this.n - 1);
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.cumulativeProbability(ts);
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - dist.cumulativeProbability(ts);
        }
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }
}

