/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import java.util.Vector;
import org.statcato.statistics.ChiSquareProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class ContingencyTable {
    private double[][] observed;
    private double[][] expected;
    private double[][] tsCont;
    private double[] rowTotal;
    private double[] columnTotal;
    private int numRows;
    private int numColumns;
    private double grandTotal;

    public ContingencyTable(Vector<Vector<Double>> table) {
        int i;
        this.numColumns = table.size();
        this.numRows = table.elementAt(0).size();
        this.rowTotal = new double[this.numRows];
        this.columnTotal = new double[this.numColumns];
        this.observed = new double[this.numRows][this.numColumns];
        this.expected = new double[this.numRows][this.numColumns];
        this.tsCont = new double[this.numRows][this.numColumns];
        this.grandTotal = 0.0;
        for (i = 0; i < this.numColumns; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                this.observed[j][i] = table.elementAt(i).elementAt(j);
                this.grandTotal += this.observed[j][i];
            }
        }
        for (i = 0; i < this.numColumns; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.numRows; ++j) {
                sum += this.observed[j][i];
            }
            this.columnTotal[i] = sum;
        }
        for (int j = 0; j < this.numRows; ++j) {
            double sum = 0.0;
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                sum += this.observed[j][i2];
            }
            this.rowTotal[j] = sum;
        }
        for (i = 0; i < this.numColumns; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                this.expected[j][i] = this.rowTotal[j] * this.columnTotal[i] / this.grandTotal;
                this.tsCont[j][i] = Math.pow(this.observed[j][i] - this.expected[j][i], 2.0) / this.expected[j][i];
            }
        }
    }

    public double testStatistics() {
        double chi2 = 0.0;
        for (int i = 0; i < this.numColumns; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                chi2 += this.tsCont[j][i];
            }
        }
        return chi2;
    }

    public int DOF() {
        return (this.numRows - 1) * (this.numColumns - 1);
    }

    public double criticalValue(double confidenceLevel) {
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.DOF());
        return dist.inverseCumulativeProbability(confidenceLevel);
    }

    public double pValue() {
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.DOF());
        double ts = this.testStatistics();
        return 1.0 - dist.cumulativeProbability(ts);
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.numRows; ++i) {
            str = str + "<tr align='right'><th>" + (i + 1) + "</th>";
            for (int j = 0; j < this.numColumns; ++j) {
                str = str + "<td>" + HelperFunctions.formatFloat(this.observed[i][j], 2) + "<br>(" + HelperFunctions.formatFloat(this.expected[i][j], 2) + ")<br>[" + HelperFunctions.formatFloat(this.tsCont[i][j], 2) + "]</td>";
            }
            str = str + "<td>" + HelperFunctions.formatFloat(this.rowTotal[i], 2) + "</td>";
            str = str + "</tr>";
        }
        str = str + "<tr align='right'><th>Total</th>";
        for (int j = 0; j < this.numColumns; ++j) {
            str = str + "<td>" + HelperFunctions.formatFloat(this.columnTotal[j], 2) + "</td>";
        }
        str = str + "<td>" + HelperFunctions.formatFloat(this.grandTotal, 2) + "</td></tr>";
        return str;
    }
}

