/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.ConfidenceInterval;

public class CIOnePopMeanSigmaKnown
extends ConfidenceInterval {
    private double sigma;
    private int n;

    public CIOnePopMeanSigmaKnown(double confidenceLevel, int n, double mean, double sigma) {
        this.n = n;
        this.sigma = sigma;
        this.center = mean;
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public double marginOfError() {
        return this.criticalValue() * this.sigma / Math.sqrt(this.n);
    }

    @Override
    public double criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        return dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
    }

    public double getStdev() {
        return this.sigma;
    }

    public int getN() {
        return this.n;
    }
}

