/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.ProbabilityDistribution;
import org.statcato.statistics.SpecialFunctions;

public class StudentTProbabilityDistribution
extends ProbabilityDistribution {
    double v;

    public StudentTProbabilityDistribution(double v) {
        this.v = v;
    }

    @Override
    public double density(double x) {
        return Math.pow(1.0 + x * x / this.v, -(this.v + 1.0) / 2.0) / SpecialFunctions.beta(0.5, 0.5 * this.v) / Math.sqrt(this.v);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x < 0.0) {
            return SpecialFunctions.betai(this.v / 2.0, 0.5, this.v / (this.v + x * x)) / 2.0;
        }
        return 1.0 - SpecialFunctions.betai(this.v / 2.0, 0.5, this.v / (this.v + x * x)) / 2.0;
    }

    public double inverseCumulativeProbability(double area) {
        if (area == 0.5) {
            return 0.0;
        }
        if (area < 0.5) {
            return super.inverseCumulativeProbability(-1000000.0, 0.0, 1.0E-4, area);
        }
        return super.inverseCumulativeProbability(0.0, 1000000.0, 1.0E-4, area);
    }
}

