/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.ProbabilityDistribution;
import org.statcato.statistics.SpecialFunctions;

public class FProbabilityDistribution
extends ProbabilityDistribution {
    double v1;
    double v2;

    public FProbabilityDistribution(double v1, double v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(this.v1 * x, this.v1) * Math.pow(this.v2, this.v2) / Math.pow(this.v1 * x + this.v2, this.v1 + this.v2)) / (x * SpecialFunctions.beta(this.v1 / 2.0, this.v2 / 2.0));
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - SpecialFunctions.betai(this.v2 / 2.0, this.v1 / 2.0, this.v2 / (this.v2 + this.v1 * x));
    }

    public double inverseCumulativeProbability(double area) {
        return super.inverseCumulativeProbability(0.0, 1000000.0, 1.0E-4, area);
    }
}

