/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.ProbabilityDistribution;
import org.statcato.statistics.SpecialFunctions;

public class ChiSquareProbabilityDistribution
extends ProbabilityDistribution {
    double v;

    public ChiSquareProbabilityDistribution(double v) {
        this.v = v;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.pow(0.5, this.v / 2.0) / Math.exp(SpecialFunctions.gammln(this.v / 2.0)) * Math.pow(x, this.v / 2.0 - 1.0) * Math.exp(-x / 2.0);
    }

    @Override
    public double cumulativeProbability(double x) {
        return SpecialFunctions.gammp(this.v / 2.0, x / 2.0);
    }

    public double inverseCumulativeProbability(double area) {
        return super.inverseCumulativeProbability(0.0, 1000000.0, 1.0E-4, area);
    }
}

