/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BasicStatistics {
    public static Vector<Double> customStandardize(Vector<Double> numbers, double num1, double num2) {
        Vector<Double> vec = new Vector<Double>(0);
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) != null) {
                double num = numbers.elementAt(i);
                vec.addElement((num - num1) / num2);
                continue;
            }
            vec.addElement(null);
        }
        return vec;
    }

    public static Vector<Double> standardize(Vector<Double> numbers) {
        Vector<Double> vec = new Vector<Double>(0);
        if (numbers.size() < 2) {
            return null;
        }
        double mean = BasicStatistics.mean(numbers);
        double stdev = BasicStatistics.stdev(numbers);
        if (stdev == 0.0) {
            return null;
        }
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) != null) {
                double num = numbers.elementAt(i);
                vec.addElement((num - mean) / stdev);
                continue;
            }
            vec.addElement(null);
        }
        return vec;
    }

    public static Vector<Double> changeRange(Vector<Double> numbers, double a, double b) {
        double min = BasicStatistics.min(numbers);
        double max = BasicStatistics.max(numbers);
        Vector<Double> vec = new Vector<Double>(0);
        if (BasicStatistics.stdev(numbers) == 0.0) {
            return null;
        }
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) != null) {
                double num = numbers.elementAt(i);
                vec.addElement(a + (num - min) * (b - a) / (max - min));
                continue;
            }
            vec.addElement(null);
        }
        return vec;
    }

    private static Vector<Double> removeNullValues(Vector<Double> numbers) {
        Vector<Double> vec = new Vector<Double>(0);
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) == null) continue;
            vec.addElement(numbers.elementAt(i));
        }
        return vec;
    }

    public static int Nnonmissing(Vector<Double> numbers) {
        int num = 0;
        Enumeration<Double> e = numbers.elements();
        while (e.hasMoreElements()) {
            if (e.nextElement() == null) continue;
            ++num;
        }
        return num;
    }

    public static int Nmissing(Vector<Double> numbers) {
        return BasicStatistics.Ntotal(numbers) - BasicStatistics.Nnonmissing(numbers);
    }

    public static int Ntotal(Vector<Double> numbers) {
        int lastNonMissingIndex = 0;
        for (int i = 0; i < numbers.size(); ++i) {
            if (numbers.elementAt(i) == null) continue;
            lastNonMissingIndex = i;
        }
        return lastNonMissingIndex + 1;
    }

    public static Double mean(Vector<Double> numbers) {
        int nnonmissing = BasicStatistics.Nnonmissing(numbers);
        if (nnonmissing == 0) {
            return null;
        }
        return BasicStatistics.sum(numbers) / (double)BasicStatistics.Nnonmissing(numbers);
    }

    public static double sum(Vector<Double> numbers) {
        double sum = 0.0;
        Enumeration<Double> e = numbers.elements();
        while (e.hasMoreElements()) {
            Double next = e.nextElement();
            if (next == null) continue;
            sum += next.doubleValue();
        }
        return sum;
    }

    public static Double stdev(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 2) {
            return null;
        }
        return Math.sqrt(BasicStatistics.variance(numbers));
    }

    public static Double variance(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 2) {
            return null;
        }
        return BasicStatistics.moment(numbers, 2) / (double)(BasicStatistics.Nnonmissing(numbers) - 1);
    }

    public static Double moment(Vector<Double> numbers, int k) {
        double mean = BasicStatistics.mean(numbers);
        double sumOfDiff = 0.0;
        Enumeration<Double> e = numbers.elements();
        while (e.hasMoreElements()) {
            Double next = e.nextElement();
            if (next == null) continue;
            sumOfDiff += Math.pow(next - mean, k);
        }
        return sumOfDiff;
    }

    public static Double min(Vector<Double> numbers) {
        if (numbers.size() == 0) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        Enumeration<Double> e = numbers.elements();
        while (e.hasMoreElements()) {
            double next;
            Double Next = e.nextElement();
            if (Next == null || !((next = Next.doubleValue()) < min)) continue;
            min = next;
        }
        if (min == Double.POSITIVE_INFINITY) {
            return null;
        }
        return min;
    }

    public static Double min(ArrayList<Double> numbers) {
        if (numbers.isEmpty()) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        for (Double Next : numbers) {
            double next;
            if (Next == null || !((next = Next.doubleValue()) < min)) continue;
            min = next;
        }
        if (min == Double.POSITIVE_INFINITY) {
            return null;
        }
        return min;
    }

    public static int min(int[] numbers) {
        int min = numbers[0];
        for (int i = 1; i < numbers.length; ++i) {
            if (numbers[i] >= min) continue;
            min = numbers[i];
        }
        return min;
    }

    public static Double max(Vector<Double> numbers) {
        if (numbers.size() == 0) {
            return null;
        }
        double max = Double.NEGATIVE_INFINITY;
        Enumeration<Double> e = numbers.elements();
        while (e.hasMoreElements()) {
            double next;
            Double Next = e.nextElement();
            if (Next == null || !((next = Next.doubleValue()) > max)) continue;
            max = next;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return max;
    }

    public static Double max(ArrayList<Double> numbers) {
        if (numbers.isEmpty()) {
            return null;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (Double Next : numbers) {
            double next;
            if (Next == null || !((next = Next.doubleValue()) > max)) continue;
            max = next;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return max;
    }

    public static int max(int[] numbers) {
        int max = numbers[0];
        for (int i = 1; i < numbers.length; ++i) {
            if (numbers[i] <= max) continue;
            max = numbers[i];
        }
        return max;
    }

    public static Double range(Vector<Double> numbers) {
        if (numbers.size() == 0) {
            return null;
        }
        Double max = BasicStatistics.max(numbers);
        Double min = BasicStatistics.min(numbers);
        if (max == null || min == null) {
            return null;
        }
        return BasicStatistics.max(numbers) - BasicStatistics.min(numbers);
    }

    public static Double median(Vector<Double> numbers) {
        Vector<Double> vec = BasicStatistics.removeNullValues(numbers);
        if (vec.size() == 0) {
            return null;
        }
        Collections.sort(vec);
        if (vec.size() % 2 == 0) {
            int middle = vec.size() / 2;
            return Double.valueOf(vec.elementAt(middle) + Double.valueOf(vec.elementAt(middle - 1))) / 2.0;
        }
        return (double)vec.elementAt((vec.size() - 1) / 2);
    }

    public static double sumOfSquares(Vector<Double> numbers) {
        double sum = 0.0;
        Enumeration<Double> e = numbers.elements();
        while (e.hasMoreElements()) {
            Double next = e.nextElement();
            if (next == null) continue;
            sum += Math.pow(next, 2.0);
        }
        return sum;
    }

    public static Double SEmean(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 2) {
            return null;
        }
        double std = BasicStatistics.stdev(numbers);
        return std / Math.sqrt(BasicStatistics.Nnonmissing(numbers));
    }

    public static Double coefficientOfVariance(Vector<Double> numbers) {
        if (numbers.size() < 2) {
            return null;
        }
        Double std = BasicStatistics.stdev(numbers);
        if (std == null) {
            return null;
        }
        double mean = BasicStatistics.mean(numbers);
        return std / mean * 100.0;
    }

    public static Double firstQuartile(Vector<Double> numbers) {
        Vector<Double> vec = BasicStatistics.removeNullValues(numbers);
        Collections.sort(vec);
        int N = vec.size();
        if (N == 0) {
            return null;
        }
        double w = ((double)N + 1.0) / 4.0;
        double y = Math.floor(w);
        double z = w - y;
        if (z == 0.0) {
            return (double)vec.elementAt((int)y - 1);
        }
        if (y < 1.0 || y > (double)(N - 1)) {
            return null;
        }
        double num1 = vec.elementAt((int)y - 1);
        double num2 = vec.elementAt((int)y);
        return new Double(num1 + z * (num2 - num1));
    }

    public static Double thirdQuartile(Vector<Double> numbers) {
        Vector<Double> vec = BasicStatistics.removeNullValues(numbers);
        Collections.sort(vec);
        int N = vec.size();
        if (N == 0) {
            return null;
        }
        double w = ((double)N + 1.0) * 3.0 / 4.0;
        double y = Math.floor(w);
        double z = w - y;
        if (z == 0.0) {
            return (double)vec.elementAt((int)y - 1);
        }
        if (y < 1.0 || y > (double)(N - 1)) {
            return null;
        }
        double num1 = vec.elementAt((int)y - 1);
        double num2 = vec.elementAt((int)y);
        return new Double(num1 + z * (num2 - num1));
    }

    public static Double percentile(Vector<Double> numbers, double i) {
        Vector<Double> vec = BasicStatistics.removeNullValues(numbers);
        Collections.sort(vec);
        int N = vec.size();
        if (N == 0) {
            return null;
        }
        double w = i * (double)(N + 1) / 100.0;
        double y = Math.floor(w);
        double z = w - y;
        if (y <= 0.0) {
            return (double)vec.elementAt(0);
        }
        if (y >= (double)N) {
            return (double)vec.elementAt(N - 1);
        }
        if (z == 0.0) {
            return (double)vec.elementAt((int)y - 1);
        }
        double num1 = vec.elementAt((int)y - 1);
        double num2 = vec.elementAt((int)y);
        return new Double(num1 + z * (num2 - num1));
    }

    public static Double interquartileRange(Vector<Double> numbers) {
        Double q1 = BasicStatistics.firstQuartile(numbers);
        Double q3 = BasicStatistics.thirdQuartile(numbers);
        if (q1 == null || q3 == null) {
            return null;
        }
        return new Double(q3 - q1);
    }

    public static Object[] mode(Vector<Double> numbers) {
        Vector<Double> vec = BasicStatistics.removeNullValues(numbers);
        Hashtable<Double, Integer> hash = new Hashtable<Double, Integer>();
        int maxCount = 0;
        Enumeration<Double> e = vec.elements();
        while (e.hasMoreElements()) {
            Double num = e.nextElement();
            if (hash.containsKey(num)) {
                int count = (Integer)hash.get(num) + 1;
                hash.put(num, new Integer(count));
                if (count <= maxCount) continue;
                maxCount = count;
                continue;
            }
            hash.put(num, new Integer(1));
        }
        Vector<Double> modes = new Vector<Double>(0);
        Enumeration e2 = hash.keys();
        while (e2.hasMoreElements()) {
            Double num = (Double)e2.nextElement();
            int count = (Integer)hash.get(num);
            if (count != maxCount) continue;
            modes.addElement(num);
        }
        Object[] returnValues = new Object[]{modes, new Integer(maxCount)};
        return returnValues;
    }

    public static Double trimmedMean(Vector<Double> numbers, double percent) {
        Vector<Double> vec = BasicStatistics.removeNullValues(numbers);
        int n = vec.size();
        int r = (int)Math.round((double)n * percent / 100.0);
        Collections.sort(vec);
        for (int i = 0; i < r; ++i) {
            if (vec.size() > 0) {
                vec.removeElementAt(0);
            }
            if (vec.size() <= 0) continue;
            vec.removeElementAt(vec.size() - 1);
        }
        if (vec.size() > 0) {
            return BasicStatistics.mean(vec);
        }
        return null;
    }

    public static Double skewness(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 3) {
            return null;
        }
        int n = BasicStatistics.Nnonmissing(numbers);
        double stdev = BasicStatistics.stdev(numbers);
        double moment3 = BasicStatistics.moment(numbers, 3);
        return moment3 / Math.pow(stdev, 3.0) * (double)n / (double)(n - 1) / (double)(n - 2);
    }

    public static Double skewnessBiased(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 2) {
            return null;
        }
        int n = BasicStatistics.Nnonmissing(numbers);
        double moment2 = BasicStatistics.moment(numbers, 2);
        double moment3 = BasicStatistics.moment(numbers, 3);
        return Math.sqrt(n) * moment3 / Math.pow(moment2, 1.5);
    }

    public static Double kurtosis(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 4) {
            return null;
        }
        int n = BasicStatistics.Nnonmissing(numbers);
        double stdev = BasicStatistics.stdev(numbers);
        double moment4 = BasicStatistics.moment(numbers, 4);
        return moment4 / Math.pow(stdev, 4.0) * (double)n * (double)(n + 1) / (double)(n - 1) / (double)(n - 2) / (double)(n - 3) - 3.0 * Math.pow(n - 1, 2.0) / (double)(n - 2) / (double)(n - 3);
    }

    public static Double kurtosisCentered3(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 4) {
            return null;
        }
        return BasicStatistics.kurtosis(numbers) + 3.0;
    }

    public static Double kurtosisBiased(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 2) {
            return null;
        }
        int n = BasicStatistics.Nnonmissing(numbers);
        double moment2 = BasicStatistics.moment(numbers, 2);
        double moment4 = BasicStatistics.moment(numbers, 4);
        return (double)n * moment4 / Math.pow(moment2, 2.0) - 3.0;
    }

    public static Double kurtosisBiasedCentered3(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 2) {
            return null;
        }
        return BasicStatistics.kurtosisBiased(numbers) + 3.0;
    }

    public static Double MSSD(Vector<Double> numbers) {
        if (BasicStatistics.Nnonmissing(numbers) < 2) {
            return null;
        }
        Vector<Double> vec = BasicStatistics.removeNullValues(numbers);
        double sum = 0.0;
        for (int i = 1; i < vec.size(); ++i) {
            double diff = vec.elementAt(i) - vec.elementAt(i - 1);
            sum += Math.pow(diff, 2.0);
        }
        return new Double(sum / 2.0 / (double)(vec.size() - 1));
    }

    public static double RyanJoinerNormalityCV(int n, double significance) {
        if (significance == 0.1) {
            return 1.0071 - 0.1371 / Math.sqrt(n) - 0.3682 / (double)n + 0.778 / (double)(n * n);
        }
        if (significance == 0.05) {
            return 1.0063 - 0.1288 / Math.sqrt(n) - 0.6118 / (double)n + 1.3505 / (double)(n * n);
        }
        if (significance == 0.01) {
            return 0.9963 - 0.0211 / Math.sqrt(n) - 1.4106 / (double)n + 3.1791 / (double)(n * n);
        }
        return -1.0;
    }

    public static Vector<Double> removeOutliers(Vector<Double> values) {
        int i;
        double iqr = BasicStatistics.interquartileRange(values);
        double q1 = BasicStatistics.firstQuartile(values);
        double q3 = BasicStatistics.thirdQuartile(values);
        double min = q1 - 1.5 * iqr;
        double max = q3 + 1.5 * iqr;
        Vector<Double> outliers = new Vector<Double>();
        for (i = 0; i < values.size(); ++i) {
            double value = values.elementAt(i);
            if (!(value < min) && !(value > max)) continue;
            outliers.addElement(values.elementAt(i));
        }
        for (i = 0; i < outliers.size(); ++i) {
            values.remove(outliers.elementAt(i));
        }
        return outliers;
    }

    public static int numberOfNegativeSigns(Vector<Double> values, double k) {
        int n = 0;
        for (int i = 0; i < values.size(); ++i) {
            double value = values.elementAt(i);
            if (!(value < k)) continue;
            ++n;
        }
        return n;
    }

    public static int numberOfPositiveSigns(Vector<Double> values, double k) {
        int n = 0;
        for (int i = 0; i < values.size(); ++i) {
            double value = values.elementAt(i);
            if (!(value > k)) continue;
            ++n;
        }
        return n;
    }
}

