/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.spreadsheet;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.statcato.Statcato;
import org.statcato.spreadsheet.Cell;

public class SpreadsheetModel
extends AbstractTableModel
implements TableModelListener {
    private boolean DEBUG = false;
    private int numColumns = 50;
    private int numRows = 301;
    private Vector<Vector<Cell>> data;
    private Vector<String> columnNames;
    private Statcato app;

    public SpreadsheetModel(Statcato app) {
        this.app = app;
        this.initialize();
    }

    public SpreadsheetModel(Statcato app, int rows, int columns) {
        this.numRows = rows;
        this.numColumns = columns;
        this.app = app;
        this.initialize();
    }

    private void initialize() {
        int col;
        this.data = new Vector(this.numRows);
        this.columnNames = new Vector(this.numColumns);
        for (col = 0; col < this.numColumns; ++col) {
            this.columnNames.addElement(SpreadsheetModel.getColumnLabel(col));
        }
        this.data.addElement(new Vector(this.numColumns));
        for (col = 0; col < this.numColumns; ++col) {
            this.data.elementAt(0).addElement(new Cell("", 0, col));
        }
        for (int row = 1; row < this.numRows; ++row) {
            this.data.addElement(new Vector(this.numColumns));
            for (col = 0; col < this.numColumns; ++col) {
                this.data.elementAt(row).addElement(new Cell("", row, col));
            }
        }
        this.addTableModelListener(this);
    }

    public Vector<Cell> getColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return null;
        }
        Vector<Cell> column = new Vector<Cell>(this.getRowCount());
        for (int row = 1; row < this.getRowCount(); ++row) {
            Cell cell = this.data.elementAt(row).elementAt(col);
            cell.setRow(row);
            cell.setColumn(col);
            column.addElement(cell);
        }
        return column;
    }

    public Vector<Cell> getRow(int row) {
        Vector<Cell> rowVec = this.data.elementAt(row);
        for (int col = 0; col < rowVec.size(); ++col) {
            rowVec.elementAt(col).setColumn(col);
            rowVec.elementAt(col).setRow(row);
        }
        return rowVec;
    }

    public static String getColumnLabel(int column) {
        return "C" + (column + 1);
    }

    public int getColumnNumber(String label) {
        if (label.equals("")) {
            return -1;
        }
        if (!label.startsWith("C") && !label.startsWith("c")) {
            if ((label = label.trim()).startsWith("\"") && label.length() > 1) {
                label = label.substring(1);
            }
            if (label.endsWith("\"") && label.length() > 1) {
                label = label.substring(0, label.length() - 1);
            }
            int loc = this.getVariableIndex(label);
            return loc;
        }
        try {
            int col = Integer.parseInt(label.substring(1)) - 1;
            if (col >= 0 && col < this.getColumnCount()) {
                return col;
            }
            return -1;
        }
        catch (NumberFormatException e) {
            int loc = this.getVariableIndex(label.trim());
            return loc;
        }
    }

    private int getVariableIndex(String label) {
        Vector<Cell> variables = this.data.elementAt(0);
        for (int i = 0; i < variables.size(); ++i) {
            if (!variables.elementAt(i).getContents().trim().equals(label)) continue;
            return i;
        }
        return -1;
    }

    public int getRowNumber(String label) {
        try {
            int row = Integer.parseInt(label);
            if (row >= 1 && row < this.getRowCount()) {
                return row;
            }
            return -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getLastNonEmptyRow() {
        int lastNonEmptyRow = -1;
        block0: for (int r = 0; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                Cell cdata = (Cell)this.getValueAt(r, c);
                if (!SpreadsheetModel.hasData(cdata)) continue;
                lastNonEmptyRow = r;
                continue block0;
            }
        }
        return lastNonEmptyRow;
    }

    public int getLastNonEmptyColumn(int row) {
        int lastNonEmptyCol = -1;
        for (int c = 0; c < this.getColumnCount(); ++c) {
            Cell cdata = (Cell)this.getValueAt(row, c);
            if (!SpreadsheetModel.hasData(cdata)) continue;
            lastNonEmptyCol = c;
        }
        return lastNonEmptyCol;
    }

    public int getLastNonEmptyColumn() {
        int lastCol = 0;
        for (int i = 0; i < this.getLastNonEmptyRow(); ++i) {
            int col = this.getLastNonEmptyColumn(i);
            if (col <= lastCol) continue;
            lastCol = col;
        }
        return lastCol;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public int getColumnCount() {
        return this.data.elementAt(0).size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.elementAt(col);
    }

    public String getVariableName(int col) {
        return this.data.elementAt(0).elementAt(col).getContents();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data.elementAt(row).elementAt(col);
    }

    public Class getColumnClass(int c) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public Vector getColumnsWithData() {
        Vector<Integer> columns = new Vector<Integer>();
        block0: for (int i = 0; i < this.getColumnCount(); ++i) {
            for (int j = 1; j < this.getRowCount(); ++j) {
                if (!SpreadsheetModel.hasData(this.getValueAt(j, i))) continue;
                columns.addElement(new Integer(i));
                continue block0;
            }
        }
        return columns;
    }

    public Vector getAllColumnNumbers() {
        Vector<Integer> columns = new Vector<Integer>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            columns.addElement(new Integer(i));
        }
        return columns;
    }

    public static boolean hasData(Object cell) {
        return !((Cell)cell).getContents().equals("");
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row == 0) {
            String var = ((String)value).trim();
            if (var.indexOf(39) != -1) {
                this.app.showErrorDialog("Variable name cannot contain the character '");
                return;
            }
            if (var.indexOf(34) != -1) {
                this.app.showErrorDialog("Variable name cannot contain the character \"");
                return;
            }
            if (!var.equals("")) {
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    if (!var.equals(this.data.elementAt(0).elementAt(i).getContents())) continue;
                    this.app.showErrorDialog("Variable name " + var + " already exists!");
                    return;
                }
            }
        }
        boolean empty = false;
        if (value.getClass() == String.class) {
            this.data.elementAt(row).set(col, new Cell((String)value, row, col));
            if (((String)value).equals("")) {
                empty = true;
            }
        } else if (value.getClass() == Cell.class) {
            this.data.elementAt(row).set(col, (Cell)value);
            if (((Cell)value).getContents().equals("")) {
                empty = true;
            }
        } else {
            this.data.elementAt(row).set(col, new Cell(value.toString(), row, col));
        }
        this.fireTableCellUpdated(row, col);
    }

    public void setStringValueAt(String value, int row, int col) {
        Cell cell = (Cell)this.getValueAt(row, col);
        cell.setContents(value);
        this.fireTableCellUpdated(row, col);
    }

    public void setColumn(int column, Vector<String> data) {
        int row = 1;
        Enumeration<String> e = data.elements();
        while (e.hasMoreElements()) {
            this.setValueAt(new Cell(e.nextElement(), row, column), row, column);
            ++row;
        }
    }

    public void setCellColumn(int column, Vector<Cell> data) {
        int row = 1;
        Enumeration<Cell> e = data.elements();
        while (e.hasMoreElements()) {
            this.setValueAt(new Cell(e.nextElement().getContents(), row, column), row, column);
            ++row;
        }
    }

    public void setRow(int row, Vector<String> data) {
        int col = 0;
        Enumeration<String> e = data.elements();
        while (e.hasMoreElements()) {
            this.setValueAt(e.nextElement(), row, col);
            ++col;
        }
    }

    public void setData(Vector<Vector<String>> data) {
        int r = 1;
        int c = 0;
        Enumeration<Vector<String>> e = data.elements();
        while (e.hasMoreElements()) {
            Vector<String> Row = e.nextElement();
            c = 0;
            Enumeration<String> f = Row.elements();
            while (f.hasMoreElements()) {
                this.setValueAt(f.nextElement(), r, c);
                ++c;
            }
            ++r;
        }
    }

    public String getTabDelimitedValues() {
        String s = "";
        int lastRow = this.getLastNonEmptyRow();
        for (int i = 0; i <= lastRow; ++i) {
            for (int j = 0; j <= this.getLastNonEmptyColumn(i); ++j) {
                s = s + this.data.elementAt(i).elementAt(j).getContents();
                s = s + "\t";
            }
            s = s + "\n";
        }
        return s;
    }

    public String getCommaSeparatedValues() {
        String s = "";
        int lastRow = this.getLastNonEmptyRow();
        for (int i = 0; i <= lastRow; ++i) {
            for (int j = 0; j <= this.getLastNonEmptyColumn(i); ++j) {
                s = s + this.data.elementAt(i).elementAt(j).getContents();
                s = s + ",";
            }
            s = s + "\n";
        }
        return s;
    }

    public void clearCell(int row, int col) {
        this.data.elementAt(row).elementAt(col).clear();
        this.fireTableCellUpdated(row, col);
    }

    public void deleteRow(int row) {
        if (row <= 0) {
            for (int col = 0; col < this.getColumnCount(); ++col) {
                this.data.elementAt(0).elementAt(col).clear();
            }
        } else {
            this.data.removeElementAt(row);
            Vector<Cell> rowVec = new Vector<Cell>(this.getColumnCount());
            for (int col = 0; col < this.getColumnCount(); ++col) {
                rowVec.addElement(new Cell("", row, col));
            }
            this.data.addElement(rowVec);
            this.fireTableDataChanged();
        }
        this.fireTableDataChanged();
    }

    public void deleteColumn(int column) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Vector<Cell> rowVec = this.data.elementAt(row);
            rowVec.removeElementAt(column);
            rowVec.addElement(new Cell("", row, this.getColumnCount() - 1));
        }
        this.fireTableDataChanged();
    }

    public void deleteCell(int row, int column) {
        if (row > 0) {
            this.data.elementAt(row).elementAt(column).clear();
            for (int i = row + 1; i < this.getRowCount(); ++i) {
                Cell cell2 = this.data.elementAt(i).elementAt(column);
                Cell cell1 = this.data.elementAt(i - 1).elementAt(column);
                cell1.setContents(cell2.getContents());
            }
            this.data.elementAt(this.getRowCount() - 1).elementAt(column).clear();
            this.fireTableDataChanged();
        }
    }

    public void deleteCells(int minRow, int maxRow, int minCol, int maxCol) {
        if (minRow == 0 && maxRow == 0) {
            for (int col = minCol; col <= maxCol; ++col) {
                this.data.elementAt(0).elementAt(col).clear();
            }
            this.fireTableDataChanged();
            return;
        }
        if (minRow <= 0) {
            minRow = 1;
        }
        for (int col = minCol; col <= maxCol; ++col) {
            int row;
            for (row = minRow; row <= maxRow; ++row) {
                this.data.elementAt(row).elementAt(col).clear();
            }
            for (row = maxRow + 1; row < this.getRowCount(); ++row) {
                Cell cell2 = this.data.elementAt(row).elementAt(col);
                Cell cell1 = this.data.elementAt(row - (maxRow - minRow + 1)).elementAt(col);
                cell1.setContents(cell2.getContents());
                cell2.clear();
            }
        }
        this.fireTableDataChanged();
    }

    public void insertRow(int row) {
        Vector<Cell> rowVec = new Vector<Cell>(this.getColumnCount());
        for (int col = 0; col < this.getColumnCount(); ++col) {
            rowVec.addElement(new Cell("", row, col));
        }
        if (row == this.getRowCount()) {
            this.data.addElement(rowVec);
        } else {
            this.data.insertElementAt(rowVec, row);
        }
        ++this.numRows;
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void insertColumn(int col) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Vector<Cell> rowVec = this.data.elementAt(row);
            rowVec.insertElementAt(new Cell("", row, col), col);
        }
        this.columnNames.insertElementAt(SpreadsheetModel.getColumnLabel(col), col);
        for (int i = col + 1; i < this.getColumnCount(); ++i) {
            this.columnNames.setElementAt(SpreadsheetModel.getColumnLabel(i), i);
        }
        ++this.numColumns;
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void insertCell(int row, int col) {
        this.insertRow(this.getRowCount());
        for (int i = this.getRowCount() - 2; i >= row; --i) {
            Cell cell2 = this.data.elementAt(i).elementAt(col);
            Cell cell1 = this.data.elementAt(i + 1).elementAt(col);
            cell1.setContents(cell2.getContents());
            cell2.clear();
        }
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void printDebugData() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            System.out.print("    row " + i + ":");
            for (int j = 0; j < this.getColumnCount(); ++j) {
                System.out.print("  " + this.data.elementAt(i).elementAt(j));
            }
            System.out.println();
        }
        System.out.println("--------------------------");
    }
}

