/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.spreadsheet;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoableEditSupport;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.statcato.Statcato;
import org.statcato.file.ExtensionFileFilter;
import org.statcato.file.FileChooserUtils;
import org.statcato.file.FileOperations;
import org.statcato.spreadsheet.Cell;
import org.statcato.spreadsheet.ExcelAdapter;
import org.statcato.spreadsheet.RowHeaderTable;
import org.statcato.spreadsheet.SpreadsheetCellRenderer;
import org.statcato.spreadsheet.SpreadsheetModel;
import org.statcato.spreadsheet.SpreadsheetScrollPane;
import org.statcato.spreadsheet.VarHeaderRenderer;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.HelperFunctions;

public class Spreadsheet
extends JTable
implements StateEditable {
    private boolean dragged = false;
    private int startDraggedColumn = -1;
    private int lastSelectedColumn = -1;
    private File savedFile = null;
    private boolean changed = false;
    private Statcato app;
    protected UndoableEditSupport undoableEditSupport;
    protected static final String MODEL = "MODEL";
    protected static final String STATUS = "STATUS";
    private StateEdit edit;

    public Spreadsheet(Statcato app) {
        super(new SpreadsheetModel(app));
        this.app = app;
        this.initialize();
        this.setShowGrid(true);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        int realRowIndex = this.convertRowIndexToModel(rowIndex);
        String contents = this.getValueAt(realRowIndex, realColumnIndex).getContents();
        return contents.equals("") ? null : contents;
    }

    public Spreadsheet(Statcato app, int numRows, int numColumns) {
        super(new SpreadsheetModel(app, numRows, numColumns));
        this.app = app;
        this.initialize();
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditSupport.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditSupport.removeUndoableEditListener(undoableEditListener);
    }

    public void storeState(Hashtable state) {
        state.put(MODEL, ((SpreadsheetModel)this.getModel()).getTabDelimitedValues());
        state.put(STATUS, new Boolean(this.changed));
    }

    public void restoreState(Hashtable state) {
        if (state != null) {
            Object changedStatus;
            String model = (String)state.get(MODEL);
            if (model != null) {
                this.clearAllCells();
                this.setData(model);
            }
            if ((changedStatus = state.get(STATUS)) != null) {
                this.changed = (Boolean)changedStatus;
                if (this.changed) {
                    this.setChangedStatus();
                } else {
                    this.setUnchangedStatus();
                }
            }
        } else {
            System.out.println("unexpected error: restore state is null");
        }
    }

    private void initialize() {
        this.undoableEditSupport = new UndoableEditSupport();
        this.setAutoResizeMode(0);
        this.setDefaultColumnWidths();
        this.setSelectionMode(1);
        this.setCellSelectionEnabled(true);
        this.setFillsViewportHeight(true);
        JTableHeader atableHeader = this.getTableHeader();
        atableHeader.setReorderingAllowed(false);
        this.addColumnHeaderMouseListeners();
        this.getModel().addTableModelListener(this);
        this.setDragEnabled(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8) {
                    Spreadsheet.this.clearSelectedCells();
                } else if (e.getKeyCode() == 127) {
                    Spreadsheet.this.deleteSelectedCells();
                } else if (!(Spreadsheet.this.isEditing() || e.isActionKey() || e.isControlDown() || e.isAltDown() || e.getKeyCode() == 16)) {
                    int rowIndexStart = Spreadsheet.this.getSelectedRow();
                    int colIndexStart = Spreadsheet.this.getSelectedColumn();
                    if (rowIndexStart == -1 || colIndexStart == -1) {
                        return;
                    }
                    Spreadsheet.this.editCellAt(rowIndexStart, colIndexStart);
                    Component c = Spreadsheet.this.getEditorComponent();
                    if (c instanceof JTextComponent) {
                        ((JTextComponent)c).setText("");
                    }
                } else if (e.isControlDown() && e.getKeyCode() == 86) {
                    Spreadsheet.this.setChangedStatus();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!e.isControlDown()) {
                    Spreadsheet.this.setChangedStatus();
                }
            }
        });
        ExcelAdapter ea = new ExcelAdapter(this);
    }

    public void setChangedStatus() {
        if (!this.changed) {
            this.changed = true;
            this.app.setCurrentTabTitle(this.app.getCurrentTabTitle() + "*");
        }
    }

    public void setUnchangedStatus() {
        this.changed = false;
        String title = this.app.getCurrentTabTitle();
        if (title.endsWith("*")) {
            this.app.setCurrentTabTitle(this.app.getCurrentTabTitle().substring(0, title.length() - 1));
        }
    }

    public boolean getChangedStatus() {
        return this.changed;
    }

    public void closeFile() {
        this.savedFile = null;
    }

    public void setDefaultColumnWidths() {
        TableColumn column = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(70);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row == 0) {
            return new VarHeaderRenderer();
        }
        return new SpreadsheetCellRenderer();
    }

    private void addColumnHeaderMouseListeners() {
        MouseMotionAdapter motionListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!Spreadsheet.this.dragged) {
                    return;
                }
                JTableHeader header = Spreadsheet.this.getTableHeader();
                TableColumnModel columns = header.getColumnModel();
                int column = header.columnAtPoint(e.getPoint());
                ListSelectionModel selection = columns.getSelectionModel();
                if (column == -1) {
                    selection.clearSelection();
                    return;
                }
                int count = Spreadsheet.this.getRowCount();
                if (count != 0) {
                    Spreadsheet.this.setRowSelectionInterval(0, count - 1);
                }
                if (column < Spreadsheet.this.startDraggedColumn) {
                    selection.setSelectionInterval(column, Spreadsheet.this.startDraggedColumn);
                } else {
                    selection.setSelectionInterval(Spreadsheet.this.startDraggedColumn, column);
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Spreadsheet.this.dragged = false;
                Spreadsheet.this.startDraggedColumn = -1;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTableHeader header = Spreadsheet.this.getTableHeader();
                TableColumnModel columns = header.getColumnModel();
                int column = header.columnAtPoint(e.getPoint());
                ListSelectionModel selection = columns.getSelectionModel();
                if (Spreadsheet.this.dragged) {
                    selection.clearSelection();
                    Spreadsheet.this.dragged = false;
                    Spreadsheet.this.startDraggedColumn = -1;
                }
                if (column == -1) {
                    return;
                }
                Spreadsheet.this.dragged = true;
                int count = Spreadsheet.this.getRowCount();
                if (count != 0) {
                    Spreadsheet.this.setRowSelectionInterval(0, count - 1);
                }
                selection.addSelectionInterval(column, column);
                Spreadsheet.this.startDraggedColumn = column;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JTableHeader header = Spreadsheet.this.getTableHeader();
                TableColumnModel columns = header.getColumnModel();
                int column = header.columnAtPoint(e.getPoint());
                if (column == -1) {
                    return;
                }
                int count = Spreadsheet.this.getRowCount();
                if (count != 0) {
                    Spreadsheet.this.setRowSelectionInterval(0, count - 1);
                }
                ListSelectionModel selection = columns.getSelectionModel();
                int anchor = selection.getAnchorSelectionIndex();
                int lead = selection.getLeadSelectionIndex();
                if (e.isShiftDown()) {
                    if (Spreadsheet.this.lastSelectedColumn != -1) {
                        if (Spreadsheet.this.lastSelectedColumn <= column) {
                            selection.setSelectionInterval(Spreadsheet.this.lastSelectedColumn, column);
                        } else {
                            selection.setSelectionInterval(column, Spreadsheet.this.lastSelectedColumn);
                        }
                    }
                } else if (!e.isControlDown()) {
                    selection.setSelectionInterval(column, column);
                }
                Spreadsheet.this.lastSelectedColumn = column;
            }
        };
        JTableHeader header = this.getTableHeader();
        header.addMouseListener(mouseAdapter);
        header.addMouseMotionListener(motionListener);
    }

    private Vector<String> convertColumnNumbersToDescriptions(Vector<Integer> ColumnsNumbers) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        Vector<String> ColumnsDesc = new Vector<String>();
        Enumeration<Integer> e = ColumnsNumbers.elements();
        while (e.hasMoreElements()) {
            int col = e.nextElement();
            String desc = DataSpreadsheetModel.getColumnName(col);
            String variable = DataSpreadsheetModel.getVariableName(col);
            desc = desc + "  " + (variable.length() > 20 ? variable.substring(0, 16) + "..." : variable);
            ColumnsDesc.addElement(desc);
        }
        return ColumnsDesc;
    }

    public void populateColumnsList(JList List2) {
        List2.setSelectionMode(2);
        List2.setLayoutOrientation(1);
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        Vector ColumnsNumbers = DataSpreadsheetModel.getColumnsWithData();
        List2.setListData(this.convertColumnNumbersToDescriptions(ColumnsNumbers));
    }

    public void populateMutableColumnsList(JList List2) {
        DefaultListModel listModel = (DefaultListModel)List2.getModel();
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        Vector ColumnsNumbers = DataSpreadsheetModel.getColumnsWithData();
        Vector<String> ColumnsLabels = this.convertColumnNumbersToDescriptions(ColumnsNumbers);
        Enumeration<String> e = ColumnsLabels.elements();
        while (e.hasMoreElements()) {
            listModel.addElement(e.nextElement());
        }
    }

    public void populateAllColumnsList(JList List2) {
        List2.setSelectionMode(2);
        List2.setLayoutOrientation(1);
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        Vector ColumnsNumbers = DataSpreadsheetModel.getAllColumnNumbers();
        List2.setListData(this.convertColumnNumbersToDescriptions(ColumnsNumbers));
    }

    public void populateComboBox(JComboBox Combo) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        Vector ColumnsNumbers = DataSpreadsheetModel.getColumnsWithData();
        Vector<String> ColumnsDesc = this.convertColumnNumbersToDescriptions(ColumnsNumbers);
        Combo.removeAllItems();
        Combo.addItem("");
        Combo.setSelectedItem("");
        Enumeration<String> e = ColumnsDesc.elements();
        while (e.hasMoreElements()) {
            Combo.addItem(e.nextElement());
        }
    }

    public int parseColumnNumber(String str) {
        String[] items = str.split(" ");
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        return DataSpreadsheetModel.getColumnNumber(items[0]);
    }

    public Vector<Cell> getColumn(int col) {
        return ((SpreadsheetModel)this.getModel()).getColumn(col);
    }

    public Vector<Cell> getRow(int row) {
        return ((SpreadsheetModel)this.getModel()).getRow(row);
    }

    public int getColumnNumber(String str) {
        return ((SpreadsheetModel)this.getModel()).getColumnNumber(str);
    }

    public String getColumnFullLabel(int column) {
        SpreadsheetModel model = (SpreadsheetModel)this.getModel();
        return SpreadsheetModel.getColumnLabel(column) + " " + model.getVariableName(column);
    }

    public Vector<Integer> getColumnNumbers(String str) {
        int dash = str.indexOf(45);
        Vector<Integer> columns = new Vector<Integer>();
        if (dash == -1) {
            int col = this.getColumnNumber(str);
            if (col != -1) {
                columns.addElement(new Integer(col));
            }
        } else {
            int min = this.getColumnNumber(str.substring(0, dash));
            int max = this.getColumnNumber(str.substring(dash + 1));
            if (min != -1 && max != -1) {
                if (min > max) {
                    int temp = max;
                    max = min;
                    min = temp;
                }
                for (int i = min; i <= max; ++i) {
                    columns.addElement(new Integer(i));
                }
            }
        }
        return columns;
    }

    public Vector<Integer> getColumnNumbersFromString(String str) {
        Object[] columns = HelperFunctions.parseString(str).toArray();
        Vector<Integer> nums = new Vector<Integer>();
        for (int x = 0; x < columns.length; ++x) {
            String label = (String)columns[x];
            if (label.equals("")) continue;
            Vector<Integer> ColumnNums = this.getColumnNumbers(label);
            if (ColumnNums.size() == 0) {
                return null;
            }
            for (int i = 0; i < ColumnNums.size(); ++i) {
                nums.addElement(ColumnNums.elementAt(i));
            }
        }
        return nums;
    }

    public int[] getColumnNumbersArrayFromString(String str) {
        Vector<Integer> v = this.getColumnNumbersFromString(str);
        return HelperFunctions.ConvertIntegerVectorToArray(v);
    }

    public int getRowNumber(String str) {
        return ((SpreadsheetModel)this.getModel()).getRowNumber(str);
    }

    @Override
    public Cell getValueAt(int row, int col) {
        return (Cell)((SpreadsheetModel)this.getModel()).getValueAt(row, col);
    }

    public int getLastRowNumber() {
        int lastRow = 0;
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        for (int r = 1; r < DataSpreadsheetModel.getRowCount(); ++r) {
            boolean hasData = false;
            for (int c = 0; c < DataSpreadsheetModel.getColumnCount(); ++c) {
                Cell data = (Cell)DataSpreadsheetModel.getValueAt(r, c);
                if (!SpreadsheetModel.hasData(data)) continue;
                hasData = true;
            }
            if (!hasData) continue;
            lastRow = r;
        }
        return lastRow;
    }

    public void setColumn(int column, Vector<String> data) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "set column " + SpreadsheetModel.getColumnLabel(column));
        if (column >= this.getColumnCount()) {
            for (int c = this.getColumnCount(); c <= column; ++c) {
                DataSpreadsheetModel.insertColumn(c);
            }
        }
        if (data.size() >= this.getRowCount()) {
            for (int r = this.getRowCount(); r <= data.size(); ++r) {
                DataSpreadsheetModel.insertRow(r);
                this.updateRowHeader();
            }
        }
        DataSpreadsheetModel.setColumn(column, data);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void setCellColumn(int column, Vector<Cell> data) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "set column " + SpreadsheetModel.getColumnLabel(column));
        if (column >= this.getColumnCount()) {
            for (int c = this.getColumnCount(); c <= column; ++c) {
                DataSpreadsheetModel.insertColumn(c);
            }
        }
        if (data.size() >= this.getRowCount()) {
            for (int r = this.getRowCount(); r <= data.size(); ++r) {
                DataSpreadsheetModel.insertRow(r);
                this.updateRowHeader();
            }
        }
        DataSpreadsheetModel.setCellColumn(column, data);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void setRow(int row, Vector<String> data) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "set row " + row);
        if (row >= this.getRowCount()) {
            for (int r = this.getRowCount(); r <= row; ++r) {
                DataSpreadsheetModel.insertRow(r);
                this.updateRowHeader();
            }
        }
        if (data.size() >= this.getColumnCount()) {
            for (int c = this.getColumnCount(); c <= data.size(); ++c) {
                DataSpreadsheetModel.insertColumn(c);
            }
        }
        DataSpreadsheetModel.setRow(row, data);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void setCellRow(int row, Vector<Cell> data) {
        this.setRow(row, HelperFunctions.ConvertCellVectorToStringVector(data));
    }

    public void setVariablesRow(Vector<String> data) {
        this.setRow(0, data);
    }

    public void setVariableLabel(int column, String name) {
        if (!this.getValueAt(0, column).hasData()) {
            this.setValueAt(name, 0, column);
        }
    }

    public int[] convertColumnLabelsToNumbers(Object[] Labels) {
        int[] columnNumbers = new int[Labels.length];
        for (int i = 0; i < Labels.length; ++i) {
            String value = Labels[i].toString();
            columnNumbers[i] = this.parseColumnNumber(value);
        }
        return columnNumbers;
    }

    public Vector<Vector<Cell>> getRowsWithDataAtGivenColumns(int[] columns) {
        Vector<Vector<Cell>> Rows = new Vector<Vector<Cell>>();
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        int numEmptyRowsSinceLastNonEmpty = 0;
        for (int r = 1; r < DataSpreadsheetModel.getRowCount(); ++r) {
            boolean hasData = false;
            Vector<Cell> Row = new Vector<Cell>(0);
            for (int c = 0; c < columns.length; ++c) {
                Cell data = (Cell)DataSpreadsheetModel.getValueAt(r, columns[c]);
                if (SpreadsheetModel.hasData(data)) {
                    hasData = true;
                }
                Row.addElement(data);
            }
            if (hasData) {
                for (int i = 0; i < numEmptyRowsSinceLastNonEmpty; ++i) {
                    Rows.addElement(new Vector(0));
                }
                Rows.addElement(Row);
                numEmptyRowsSinceLastNonEmpty = 0;
                continue;
            }
            ++numEmptyRowsSinceLastNonEmpty;
        }
        return Rows;
    }

    public int getLastNonEmptyRow() {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        return DataSpreadsheetModel.getLastNonEmptyRow();
    }

    public int getLastNonEmptyColumn(int row) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        return DataSpreadsheetModel.getLastNonEmptyColumn(row);
    }

    public int getLastNonEmptyColumn() {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        return DataSpreadsheetModel.getLastNonEmptyColumn();
    }

    public void setData(String data) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        String[] lines = data.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] items = lines[i].split("\\t");
            for (int j = 0; j < items.length; ++j) {
                this.setStringValueAt(items[j], i, j);
            }
        }
        this.setChangedStatus();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        if (value.getClass() != String.class || !((String)value).equals("")) {
            this.edit = new StateEdit(this, "set cell R" + row + ", " + SpreadsheetModel.getColumnLabel(col));
        }
        if (row >= this.getRowCount()) {
            for (int r = this.getRowCount(); r <= row; ++r) {
                DataSpreadsheetModel.insertRow(r);
                this.updateRowHeader();
            }
        }
        if (col >= this.getColumnCount()) {
            for (int c = this.getColumnCount(); c <= col; ++c) {
                DataSpreadsheetModel.insertColumn(c);
            }
        }
        DataSpreadsheetModel.setValueAt(value, row, col);
        if (value.getClass() != String.class || !((String)value).equals("")) {
            this.edit.end();
            this.undoableEditSupport.postEdit(this.edit);
        }
    }

    public void setStringValueAt(String value, int row, int col) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        if (row >= this.getRowCount()) {
            for (int r = this.getRowCount(); r <= row; ++r) {
                DataSpreadsheetModel.insertRow(r);
                this.updateRowHeader();
            }
        }
        if (col >= this.getColumnCount()) {
            for (int c = this.getColumnCount(); c <= col; ++c) {
                DataSpreadsheetModel.insertColumn(c);
            }
        }
        DataSpreadsheetModel.setStringValueAt(value, row, col);
    }

    public void setDataUnchangedStatus(String data) {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        String[] lines = data.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] items = lines[i].split("\\t");
            for (int j = 0; j < items.length; ++j) {
                this.setStringValueAt(items[j], i, j);
            }
        }
        this.app.undoManager.discardAllEdits();
    }

    public void setData(Vector<Vector<String>> data) {
        int row = data.size();
        int col = data.elementAt(0).size();
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        if (row >= this.getRowCount()) {
            for (int r = this.getRowCount(); r <= row; ++r) {
                DataSpreadsheetModel.insertRow(r);
                this.updateRowHeader();
            }
        }
        if (col >= this.getColumnCount()) {
            for (int c = this.getColumnCount(); c <= col; ++c) {
                DataSpreadsheetModel.insertColumn(c);
            }
        }
        ((SpreadsheetModel)this.getModel()).setData(data);
        this.setChangedStatus();
        this.app.undoManager.discardAllEdits();
    }

    public Spreadsheet getSubTable(int minRow, int minCol, int maxRow, int maxCol) {
        Spreadsheet NewSS = new Spreadsheet(this.app, maxRow - minRow + 2, maxCol - minCol + 1);
        SpreadsheetModel DataSSModel = (SpreadsheetModel)this.getModel();
        SpreadsheetModel NewDataSSModel = (SpreadsheetModel)NewSS.getModel();
        for (int i = minRow; i <= maxRow; ++i) {
            for (int j = minCol; j <= maxCol; ++j) {
                Object value = DataSSModel.getValueAt(i, j);
                int row = i - minRow + 1;
                int col = j - minCol;
                NewDataSSModel.setValueAt(value, row, col);
            }
        }
        return NewSS;
    }

    public void display() {
        ((SpreadsheetModel)this.getModel()).printDebugData();
    }

    public File writeToFile(JFrame frame, boolean saveAs) {
        String path = "";
        String extension = "";
        if (this.savedFile != null && !saveAs) {
            path = this.savedFile.getPath();
            extension = FileChooserUtils.getExtension(this.savedFile);
            this.writeFileHelper(frame, path, extension);
            return this.savedFile;
        }
        JFileChooser fc = new JFileChooser(FileOperations.getRecentDatasheet() == null ? null : FileOperations.getRecentDatasheet().getParentFile());
        ExtensionFileFilter ExcelFilter = new ExtensionFileFilter("Excel (*.xls)", "xls");
        ExtensionFileFilter CSVFilter = new ExtensionFileFilter("Comma-separated values(*.csv)", "csv");
        ExtensionFileFilter TDVFilter = new ExtensionFileFilter("Tab-delimited values (*.txt)", "txt");
        fc.addChoosableFileFilter(ExcelFilter);
        fc.addChoosableFileFilter(CSVFilter);
        fc.addChoosableFileFilter(TDVFilter);
        fc.setAcceptAllFileFilterUsed(false);
        int returnValue = fc.showSaveDialog(frame);
        if (returnValue == 0) {
            File file = fc.getSelectedFile();
            path = file.getPath();
            extension = "";
            FileFilter filter = fc.getFileFilter();
            extension = filter.equals(ExcelFilter) ? "xls" : (filter.equals(CSVFilter) ? "csv" : "txt");
            if (!path.toLowerCase().endsWith("." + extension)) {
                path = path + "." + extension;
                file = new File(path);
            }
            if (file.exists()) {
                System.out.println("file exists already");
                Object[] options = new Object[]{"Overwrite file", "Cancel"};
                int choice = JOptionPane.showOptionDialog(frame, "The specified file already exists.  Overwrite existing file?", "Overwrite file?", 0, 2, null, options, options[1]);
                if (choice != 0) {
                    return null;
                }
            }
            this.writeFileHelper(frame, path, extension);
            this.savedFile = file;
            return file;
        }
        return null;
    }

    private void writeFileHelper(JFrame frame, String path, String extension) {
        try {
            BufferedWriter Writer2 = new BufferedWriter(new FileWriter(path));
            String contents = "";
            if (extension != null && extension.equals("xls")) {
                System.out.println("write excel");
                HSSFWorkbook wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet("new sheet");
                SpreadsheetModel sm = (SpreadsheetModel)this.getModel();
                int lastNonEmptyRow = this.getLastNonEmptyRow();
                for (int i = 0; i <= lastNonEmptyRow; ++i) {
                    HSSFRow row = sheet.createRow((int)((short)i));
                    int lastNonEmptyCol = this.getLastNonEmptyColumn(i);
                    for (int j = 0; j <= lastNonEmptyCol; ++j) {
                        Cell cell = (Cell)sm.getValueAt(i, j);
                        if (cell.isNumeric()) {
                            row.createCell((short)j).setCellValue(cell.getNumValue().doubleValue());
                            continue;
                        }
                        row.createCell((short)j).setCellValue(cell.getContents());
                    }
                }
                FileOutputStream fileOut = new FileOutputStream(path);
                wb.write((OutputStream)fileOut);
                fileOut.close();
                this.setUnchangedStatus();
                return;
            }
            if (extension != null && extension.equals("csv")) {
                System.out.println("write csv");
                contents = ((SpreadsheetModel)this.getModel()).getCommaSeparatedValues();
            } else {
                System.out.println("write txt");
                contents = ((SpreadsheetModel)this.getModel()).getTabDelimitedValues();
            }
            String[] lines = contents.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                Writer2.write(lines[i]);
                Writer2.newLine();
            }
            Writer2.close();
            this.setUnchangedStatus();
        }
        catch (IOException e) {
            HelperFunctions.showErrorDialog(frame, "Write file failed!");
        }
    }

    public void setFile(File file) {
        this.savedFile = file;
    }

    public void clearSelectedCells() {
        int[] selectedColumns = this.getSelectedColumns();
        int[] selectedRows = this.getSelectedRows();
        int minRow = BasicStatistics.min(selectedRows);
        int minCol = BasicStatistics.min(selectedColumns);
        int maxRow = BasicStatistics.max(selectedRows);
        int maxCol = BasicStatistics.max(selectedColumns);
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "clear cells");
        for (int row = minRow; row <= maxRow; ++row) {
            for (int col = minCol; col <= maxCol; ++col) {
                DataSpreadsheetModel.clearCell(row, col);
            }
        }
        this.setRowSelectionInterval(minRow, minRow);
        this.setColumnSelectionInterval(minCol, minCol);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void clearAllCells() {
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                DataSpreadsheetModel.clearCell(i, j);
            }
        }
        this.setChangedStatus();
    }

    public void deleteSelectedCells() {
        int[] selectedColumns = this.getSelectedColumns();
        int[] selectedRows = this.getSelectedRows();
        int minRow = BasicStatistics.min(selectedRows);
        int minCol = BasicStatistics.min(selectedColumns);
        int maxRow = BasicStatistics.max(selectedRows);
        int maxCol = BasicStatistics.max(selectedColumns);
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "delete cells");
        if (maxRow - minRow == DataSpreadsheetModel.getRowCount() - 1) {
            for (int col = minCol; col <= maxCol; ++col) {
                DataSpreadsheetModel.deleteColumn(minCol);
            }
        } else if (maxCol - minCol == DataSpreadsheetModel.getColumnCount() - 1) {
            if (minRow == 0) {
                DataSpreadsheetModel.deleteRow(0);
                minRow = 1;
            }
            for (int row = minRow; row <= maxRow; ++row) {
                DataSpreadsheetModel.deleteRow(minRow);
            }
        } else {
            DataSpreadsheetModel.deleteCells(minRow, maxRow, minCol, maxCol);
        }
        this.setRowSelectionInterval(minRow, minRow);
        this.setColumnSelectionInterval(minCol, minCol);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void insertRow() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = 1;
        }
        if (col == -1) {
            col = 0;
        }
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        DataSpreadsheetModel.insertRow(this.getRowCount());
        this.updateRowHeader();
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(col, col);
        this.setChangedStatus();
    }

    public void insertRowAbove() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = 1;
        }
        if (col == -1) {
            col = 0;
        }
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "insert row above");
        DataSpreadsheetModel.insertRow(row);
        this.updateRowHeader();
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(col, col);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void insertRowBelow() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = 1;
        }
        if (col == -1) {
            col = 0;
        }
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "insert row below");
        DataSpreadsheetModel.insertRow(row + 1);
        this.updateRowHeader();
        this.setRowSelectionInterval(row + 1, row + 1);
        this.setColumnSelectionInterval(col, col);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void insertColumn() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (col == -1) {
            col = 0;
        }
        if (row == -1) {
            row = 1;
        }
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        DataSpreadsheetModel.insertColumn(this.getColumnCount());
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(col, col);
        this.setChangedStatus();
    }

    public void insertColumnLeft() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (col == -1) {
            col = 0;
        }
        if (row == -1) {
            row = 1;
        }
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "insert column left");
        DataSpreadsheetModel.insertColumn(col);
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(col, col);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void insertColumnRight() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = 1;
        }
        if (col == -1) {
            col = 0;
        }
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "insert column right");
        DataSpreadsheetModel.insertColumn(col + 1);
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(col + 1, col + 1);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void insertCellAbove() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = 1;
        }
        if (col == -1) {
            col = 0;
        }
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "insert cell above");
        DataSpreadsheetModel.insertCell(row, col);
        this.updateRowHeader();
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(col, col);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    public void insertCellBelow() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = 1;
        }
        if (col == -1) {
            col = 0;
        }
        SpreadsheetModel DataSpreadsheetModel = (SpreadsheetModel)this.getModel();
        this.edit = new StateEdit(this, "insert cell below");
        DataSpreadsheetModel.insertCell(row + 1, col);
        this.updateRowHeader();
        this.setRowSelectionInterval(row + 1, row + 1);
        this.setColumnSelectionInterval(col, col);
        this.setChangedStatus();
        this.edit.end();
        this.undoableEditSupport.postEdit(this.edit);
    }

    private void updateRowHeader() {
        RowHeaderTable rowHeader = ((SpreadsheetScrollPane)this.app.getDatasheetTabbedPane().getSelectedComponent()).getRowHeaderTable();
        rowHeader.addHeaderRow();
    }

    public void selectAllCells() {
        this.selectAll();
    }
}

