/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.graph;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.statcato.Statcato;
import org.statcato.utils.HelperFunctions;

public class StatcatoChartFrame
extends ChartFrame
implements ActionListener {
    private transient ImageSelection imgsel;
    public transient Statcato parent;
    protected transient JFreeChart chart;
    protected String title;

    public StatcatoChartFrame(String title, JFreeChart chart, Statcato parent0) {
        super(title, chart);
        this.title = title;
        this.chart = chart;
        this.parent = parent0;
        this.setupFrame();
    }

    private void setupFrame() {
        JMenuBar menuBar = new JMenuBar();
        JMenu FileMenu = new JMenu("Graph");
        JMenuItem copy = new JMenuItem("Copy Graph to Clipboard");
        FileMenu.add(copy);
        copy.setActionCommand("copy");
        copy.addActionListener(this);
        JMenuItem save = new JMenuItem("Save...");
        FileMenu.add(save);
        save.setActionCommand("save");
        save.addActionListener(this);
        JMenuItem print = new JMenuItem("Print...");
        FileMenu.add(print);
        print.setActionCommand("print");
        print.addActionListener(this);
        JMenuItem properties = new JMenuItem("Properties...");
        FileMenu.add(properties);
        properties.setActionCommand("properties");
        properties.addActionListener(this);
        menuBar.add(FileMenu);
        this.setJMenuBar(menuBar);
        this.imgsel = new ImageSelection();
        this.setDefaultCloseOperation(0);
        this.parent.addWindowFrame(this);
        this.addCloseListener();
        this.restore();
    }

    public void addCloseListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Object[] options = new Object[]{"Confirm", "Cancel"};
                int choice = JOptionPane.showOptionDialog(StatcatoChartFrame.this, "Are you sure you want to remove the graph from the project?", "Closing Chart...", 0, 3, null, options, options[0]);
                if (choice == 0) {
                    StatcatoChartFrame.this.parent.removeWindowFrame(StatcatoChartFrame.this);
                    StatcatoChartFrame.this.dispose();
                }
            }
        });
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public String getChartTitle() {
        return this.title;
    }

    public void setParent(Statcato parent) {
        this.parent = parent;
    }

    public void restore() {
        this.setState(0);
        this.toFront();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("copy")) {
            this.setClipboard(this.getChartPanel().getChart().createBufferedImage(680, 420, 2, null));
        } else if (ae.getActionCommand().equals("save")) {
            try {
                this.getChartPanel().doSaveAs();
            }
            catch (IOException e) {
                HelperFunctions.showErrorDialog(this, "Unexpected error");
            }
        } else if (ae.getActionCommand().equals("print")) {
            this.getChartPanel().createChartPrintJob();
        } else if (ae.getActionCommand().equals("properties")) {
            this.getChartPanel().doEditChartProperties();
            this.getChartPanel().repaint();
        } else {
            this.getChartPanel().actionPerformed(ae);
        }
    }

    private void setClipboard(Image image) {
        this.imgsel.setImage(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(this.imgsel, null);
    }

    private class ImageSelection
    implements Transferable {
        private Image image;

        private ImageSelection() {
        }

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

