/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.nonparametrics;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.nonparametrics.RunsTest;
import org.statcato.utils.HelperFunctions;

public class RunsTestDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JRadioButton CatRadioButton;
    private JComboBox ColComboBox;
    private JRadioButton ColRadioButton;
    private JRadioButton MeanRadioButton;
    private JRadioButton NumRadioButton;
    private JButton OKButton;
    private JPanel OptionsPanel;
    private JRadioButton SepRadioButton;
    private JTextField SepTextField;
    private JTextField SigTextField;
    private JRadioButton SummaryRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JTextField n1TextField;
    private JTextField n2TextField;
    private JTextField runsTextField;

    public RunsTestDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.customInitComponents();
        this.setHelpFile("stat-nonparam-runs-test");
        this.name = "Runs Test";
        this.description = "For performing the runs test for randomness.";
        this.helpStrings.add("Provide the matched pairs in two separate columns and add the series of two variables to the list of variable series.");
        this.helpStrings.add("Provide the significance level.");
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.ColComboBox);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.ColRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.CatRadioButton);
        group2.add(this.NumRadioButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.MeanRadioButton);
        group3.add(this.SepRadioButton);
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColComboBox);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.n2TextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.ColRadioButton = new JRadioButton();
        this.ColComboBox = new JComboBox();
        this.SummaryRadioButton = new JRadioButton();
        this.n1TextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.runsTextField = new JTextField();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel9 = new JLabel();
        this.SigTextField = new JTextField();
        this.OptionsPanel = new JPanel();
        this.CatRadioButton = new JRadioButton();
        this.NumRadioButton = new JRadioButton();
        this.MeanRadioButton = new JRadioButton();
        this.SepRadioButton = new JRadioButton();
        this.SepTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Runs Test");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.n2TextField.setEnabled(false);
        this.jLabel5.setText("Number of category 1:");
        this.jLabel1.setText("Column:");
        this.ColRadioButton.setSelected(true);
        this.ColRadioButton.setText("Samples in one column");
        this.ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RunsTestDialog.this.ColRadioButtonStateChanged(evt);
            }
        });
        this.SummaryRadioButton.setText("Summarized sample data");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RunsTestDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.n1TextField.setEnabled(false);
        this.jLabel6.setText("Number of category 2:");
        this.jLabel7.setText("Number of runs:");
        this.runsTextField.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ColRadioButton).addComponent(this.SummaryRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(5, 5, 5).addComponent(this.ColComboBox, -2, 94, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.n1TextField)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.runsTextField, -2, 68, -2).addComponent(this.n2TextField, -2, 68, -2))))))).addContainerGap(20, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.ColComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.n1TextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.n2TextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.runsTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunsTestDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunsTestDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel9.setText("Significance level:");
        this.SigTextField.setText("0.05");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addContainerGap(51, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.SigTextField, -2, -1, -2)).addContainerGap()));
        this.OptionsPanel.setBorder(BorderFactory.createTitledBorder("Data Options"));
        this.CatRadioButton.setSelected(true);
        this.CatRadioButton.setText("Categorical");
        this.CatRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RunsTestDialog.this.CatRadioButtonStateChanged(evt);
            }
        });
        this.NumRadioButton.setText("Numerical");
        this.NumRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RunsTestDialog.this.NumRadioButtonStateChanged(evt);
            }
        });
        this.MeanRadioButton.setSelected(true);
        this.MeanRadioButton.setText("Above and below mean");
        this.MeanRadioButton.setEnabled(false);
        this.MeanRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RunsTestDialog.this.MeanRadioButtonStateChanged(evt);
            }
        });
        this.SepRadioButton.setText("Above and below:");
        this.SepRadioButton.setEnabled(false);
        this.SepRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RunsTestDialog.this.SepRadioButtonStateChanged(evt);
            }
        });
        this.SepTextField.setEnabled(false);
        GroupLayout OptionsPanelLayout = new GroupLayout(this.OptionsPanel);
        this.OptionsPanel.setLayout(OptionsPanelLayout);
        OptionsPanelLayout.setHorizontalGroup(OptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(OptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(OptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CatRadioButton).addComponent(this.NumRadioButton).addGroup(OptionsPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(OptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(OptionsPanelLayout.createSequentialGroup().addComponent(this.SepRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.SepTextField, -2, 63, -2)).addComponent(this.MeanRadioButton)))).addContainerGap(22, Short.MAX_VALUE)));
        OptionsPanelLayout.setVerticalGroup(OptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(OptionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.CatRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.NumRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.MeanRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(OptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SepRadioButton).addComponent(this.SepTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(203, 203, 203).addComponent(this.OKButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CancelButton).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.OptionsPanel, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addGap(3, 3, 3).addComponent(this.OptionsPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel1, -2, -1, -2)).addGap(41, 41, 41).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    private void ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ColRadioButton.isSelected()) {
            this.ColComboBox.setEnabled(true);
            this.OptionsPanel.setVisible(true);
        } else {
            this.ColComboBox.setEnabled(false);
            this.OptionsPanel.setVisible(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.n1TextField.setEnabled(true);
            this.n2TextField.setEnabled(true);
            this.runsTextField.setEnabled(true);
            this.OptionsPanel.setVisible(false);
        } else {
            this.n1TextField.setEnabled(false);
            this.n2TextField.setEnabled(false);
            this.runsTextField.setEnabled(false);
            this.OptionsPanel.setVisible(true);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double significance;
        this.app.compoundEdit = new DialogEdit("runs test");
        String heading = "Runs Test:";
        String text = "";
        try {
            significance = Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        if (significance <= 0.0 || significance >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        heading = heading + "  Significance level = " + significance;
        if (this.ColRadioButton.isSelected()) {
            String columnLabel = this.ColComboBox.getSelectedItem().toString();
            text = text + "Data in column " + columnLabel + "<br>";
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the column containing data.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> ColVector = HelperFunctions.removeNullCells(this.ParentSpreadsheet.getColumn(column));
            if (this.CatRadioButton.isSelected()) {
                try {
                    Object[] Values2 = HelperFunctions.splitValuesVector(ColVector);
                    String cat1 = (String)Values2[0];
                    String cat2 = (String)Values2[2];
                    RunsTest runsTest = new RunsTest(ColVector, cat1, cat2, significance);
                    text = text + "Categorical data: " + cat1 + ", " + cat2 + "<br>";
                    text = text + runsTest;
                }
                catch (Exception e) {
                    this.app.showErrorDialog("Only data of two categories are allowed.");
                    return;
                }
            } else {
                Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(ColVector);
                if (XColumnVector == null) {
                    this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                    return;
                }
                if ((XColumnVector = HelperFunctions.removeNullValues(XColumnVector)).size() == 0) {
                    this.app.showErrorDialog("Invalid input column " + columnLabel + ": empty column.");
                }
                if (this.MeanRadioButton.isSelected()) {
                    double mean = BasicStatistics.mean(XColumnVector);
                    RunsTest runsTest = new RunsTest(XColumnVector, mean, significance);
                    text = text + "Numerical data, above and below " + HelperFunctions.formatFloat(mean, 4) + "<br>";
                    text = text + runsTest;
                } else {
                    try {
                        double separator = Double.parseDouble(this.SepTextField.getText());
                        RunsTest runsTest = new RunsTest(XColumnVector, separator, significance);
                        text = text + "Numerical data, above and below " + HelperFunctions.formatFloat(separator, 4) + "<br>";
                        text = text + runsTest;
                    }
                    catch (Exception e) {
                        this.app.showErrorDialog("Enter a valid number of the above and below separating value.");
                        return;
                    }
                }
            }
        } else {
            try {
                int n1 = Integer.parseInt(this.n1TextField.getText());
                int n2 = Integer.parseInt(this.n2TextField.getText());
                int runs = Integer.parseInt(this.runsTextField.getText());
                RunsTest runsTest = new RunsTest(n1, n2, runs, significance);
                text = text + runsTest;
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter integers for the number of category 1, number of category 2, and number of runs.");
                return;
            }
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void CatRadioButtonStateChanged(ChangeEvent evt) {
        if (this.CatRadioButton.isSelected()) {
            this.MeanRadioButton.setEnabled(false);
            this.SepRadioButton.setEnabled(false);
            this.SepTextField.setEnabled(false);
        } else {
            this.MeanRadioButton.setEnabled(true);
            this.SepRadioButton.setEnabled(true);
            if (this.SepRadioButton.isSelected()) {
                this.SepTextField.setEnabled(true);
            } else {
                this.SepTextField.setEnabled(false);
            }
        }
    }

    private void NumRadioButtonStateChanged(ChangeEvent evt) {
        if (this.CatRadioButton.isSelected()) {
            this.MeanRadioButton.setEnabled(false);
            this.SepRadioButton.setEnabled(false);
            this.SepTextField.setEnabled(false);
        } else {
            this.MeanRadioButton.setEnabled(true);
            this.SepRadioButton.setEnabled(true);
            if (this.SepRadioButton.isSelected()) {
                this.SepTextField.setEnabled(true);
            } else {
                this.SepTextField.setEnabled(false);
            }
        }
    }

    private void MeanRadioButtonStateChanged(ChangeEvent evt) {
        if (this.MeanRadioButton.isSelected()) {
            this.SepTextField.setEnabled(false);
        } else {
            this.SepTextField.setEnabled(true);
        }
    }

    private void SepRadioButtonStateChanged(ChangeEvent evt) {
        if (this.MeanRadioButton.isSelected()) {
            this.SepTextField.setEnabled(false);
        } else {
            this.SepTextField.setEnabled(true);
        }
    }
}

