/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.nonparametrics;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.nonparametrics.KruskalWallisTest;
import org.statcato.utils.HelperFunctions;

public class KruskalWallisDialog
extends StatcatoDialog {
    private JButton AddButton;
    private JButton CancelButton;
    private JButton ClearButton;
    private JList ColList;
    private JButton OKButton;
    private JButton RemoveButton;
    private JTextField SigTextField;
    private JList VarList;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public KruskalWallisDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.customInitComponents();
        this.setHelpFile("stat-nonparam-kruskal-wallis");
        this.name = "Kruskal-Wallis Test";
        this.description = "For performing the Kruskal-Wallis Test for samples from three or more independent populations.";
        this.helpStrings.add("Provide sample values for different populations in separate columns and add the columns to the list of responses.");
        this.helpStrings.add("Provide the significance level.");
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
        this.ColList.setSelectionMode(2);
        this.VarList.setSelectionMode(2);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    @Override
    public void updateElements() {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.VarList = new JList(new DefaultListModel());
        this.RemoveButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.ColList = new JList(new DefaultListModel());
        this.jLabel1 = new JLabel();
        this.AddButton = new JButton();
        this.ClearButton = new JButton();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Kruskal-Wallis Test");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2)).addContainerGap()));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KruskalWallisDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KruskalWallisDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.VarList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                KruskalWallisDialog.this.VarListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.VarList);
        this.RemoveButton.setText("Remove from list >>");
        this.RemoveButton.setEnabled(false);
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KruskalWallisDialog.this.RemoveButtonActionPerformed(evt);
            }
        });
        this.ColList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                KruskalWallisDialog.this.ColListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.ColList);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Responses:");
        this.AddButton.setText("<< Add to list");
        this.AddButton.setEnabled(false);
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KruskalWallisDialog.this.AddButtonActionPerformed(evt);
            }
        });
        this.ClearButton.setText("Clear Input List");
        this.ClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KruskalWallisDialog.this.ClearButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("<html>Select the column to be <br>included in the analysis<br>\n(Ctrl-click or Shift-click to <br>\nselect multiple columns):");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ClearButton).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -2, 103, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.AddButton).addComponent(this.RemoveButton)))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane2, -2, 100, -2))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.AddButton, this.RemoveButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1)).addComponent(this.jLabel3, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.AddButton).addGap(31, 31, 31).addComponent(this.RemoveButton).addGap(36, 36, 36)).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ClearButton).addGap(11, 11, 11)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel2, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(160, 160, 160).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(12, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("kruskal-wallis test");
        String heading = "Kruskal-Wallis Test:";
        String text = "";
        Vector<Vector<Double>> vectors = new Vector<Vector<Double>>();
        double significance = 0.0;
        try {
            significance = Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        if (significance <= 0.0 || significance >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        heading = heading + "  Significance level = " + significance;
        if (this.VarList.getModel().getSize() < 3) {
            this.app.showErrorDialog("Select at least three columns to include in the analysis.");
            return;
        }
        text = text + "Selected column variables:  ";
        for (int i = 0; i < this.VarList.getModel().getSize(); ++i) {
            String x = (String)this.VarList.getModel().getElementAt(i);
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(x);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (XColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + x + ": all data must be numbers.");
                return;
            }
            if ((XColumnVector = HelperFunctions.removeNullValues(XColumnVector)).size() == 0) {
                this.app.showErrorDialog("Invalid input column " + x + ": empty column.");
            }
            vectors.addElement(XColumnVector);
            text = text + x + "  ";
        }
        text = text + "<br><br>";
        KruskalWallisTest kw = new KruskalWallisTest(vectors, significance);
        text = text + kw;
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void VarListValueChanged(ListSelectionEvent evt) {
        if (this.VarList.getSelectedIndex() != -1) {
            this.RemoveButton.setEnabled(true);
            this.RemoveButton.requestFocusInWindow();
        } else {
            this.RemoveButton.setEnabled(false);
        }
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.VarList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.ColList.getModel()).addElement(x);
            ((DefaultListModel)this.VarList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void ColListValueChanged(ListSelectionEvent evt) {
        if (this.ColList.getSelectedIndex() != -1) {
            this.AddButton.setEnabled(true);
            this.AddButton.requestFocusInWindow();
        } else {
            this.AddButton.setEnabled(false);
        }
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.ColList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.VarList.getModel()).addElement(x);
            ((DefaultListModel)this.ColList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void ClearButtonActionPerformed(ActionEvent evt) {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }
}

