/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.multinomial;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.spreadsheet.Spreadsheet;
import org.statcato.statistics.inferential.ContingencyTable;
import org.statcato.statistics.inferential.CrossTabulation;
import org.statcato.utils.CategoryCounter;
import org.statcato.utils.HelperFunctions;

public class CrossTabulationDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JCheckBox ChiSquareCheckBox;
    private JComboBox ColComboBox;
    private JComboBox FreqComboBox;
    private JButton OKButton;
    private JComboBox RowComboBox;
    private JTextField SigTextField;
    private JCheckBox StoreCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public CrossTabulationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.customInitComponents();
        this.setHelpFile("stat-cross-tabulation");
        this.name = "Cross Tabulation and Chi-Square Test";
        this.description = "For performing cross tabulation and the Chi-square Test for two variables.";
        this.helpStrings.add("Provide row and column labels in two separate columns.  Select the columns in the corresponding drop-down menus.");
        this.helpStrings.add("Provide the frequencies in a column (optional).");
        this.helpStrings.add("Select if a Chi-square test should be performed and provide the significance level.");
        this.helpStrings.add("Select whether to store the results in a new datasheet.");
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.FreqComboBox);
        this.ParentSpreadsheet.populateComboBox(this.RowComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ColComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.ColComboBox = new JComboBox();
        this.RowComboBox = new JComboBox();
        this.FreqComboBox = new JComboBox();
        this.CancelButton = new JButton();
        this.OKButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.ChiSquareCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.StoreCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Cross Tabulation");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel3.setText("Column:");
        this.jLabel2.setText("Row:");
        this.jLabel1.setText("<html>Frequency:<br>(optional)</html>\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.FreqComboBox, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel3)).addGroup(jPanel1Layout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ColComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.RowComboBox, 0, 121, Short.MAX_VALUE)))).addContainerGap(52, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RowComboBox, -2, -1, -2).addComponent(this.jLabel2)).addGap(27, 27, 27).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ColComboBox, -2, -1, -2).addComponent(this.jLabel3)).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.FreqComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CrossTabulationDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CrossTabulationDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Chi-Square Test"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        this.jLabel4.setText("0 - 1.00 (e.g. 0.05)");
        this.ChiSquareCheckBox.setSelected(true);
        this.ChiSquareCheckBox.setText("Perform Chi-square test");
        this.ChiSquareCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CrossTabulationDialog.this.ChiSquareCheckBoxStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ChiSquareCheckBox).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SigTextField, -2, 81, -2).addComponent(this.jLabel4)))).addContainerGap(47, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.ChiSquareCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Results"));
        this.StoreCheckBox.setText("Store table in a new datasheet");
        this.StoreCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CrossTabulationDialog.this.StoreCheckBoxStateChanged(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.StoreCheckBox).addGap(63, 63, 63)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.StoreCheckBox).addContainerGap(29, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(86, 86, 86).addComponent(this.OKButton, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addGap(40, 40, 40).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton))));
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.FreqComboBox);
        this.updateComboBox(this.RowComboBox);
        this.updateComboBox(this.ColComboBox);
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        int j;
        this.app.compoundEdit = new DialogEdit("cross tabulation");
        String heading = "Cross Tabulation and Chi-Square";
        String text = "";
        boolean hasFrequency = true;
        Vector<Double> ResponseVector = null;
        String columnLabel = this.FreqComboBox.getSelectedItem().toString();
        if (columnLabel.equals("")) {
            hasFrequency = false;
        } else {
            text = text + "frequencies in " + columnLabel + ", ";
            hasFrequency = true;
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            ResponseVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector = HelperFunctions.removeEndingEmptyCells(StrColumnVector));
            if (ResponseVector == null) {
                this.app.showErrorDialog("Invalid frequency column " + columnLabel + ": all data must be numbers.");
                return;
            }
        }
        String rowLabel = this.RowComboBox.getSelectedItem().toString();
        text = text + "rows in " + rowLabel;
        if (rowLabel.equals("")) {
            this.app.showErrorDialog("Select the row factor variable.");
            return;
        }
        int rowColumn = this.ParentSpreadsheet.parseColumnNumber(rowLabel);
        Vector<Cell> RowVector = this.ParentSpreadsheet.getColumn(rowColumn);
        RowVector = HelperFunctions.removeEndingEmptyCells(RowVector);
        if (hasFrequency && RowVector.size() < ResponseVector.size()) {
            this.app.showErrorDialog("missing row factor label(s)");
            return;
        }
        String colLabel = this.ColComboBox.getSelectedItem().toString();
        text = text + ", columns in " + colLabel + "<br>";
        if (colLabel.equals("")) {
            this.app.showErrorDialog("Select the column factor variable.");
            return;
        }
        int colColumn = this.ParentSpreadsheet.parseColumnNumber(colLabel);
        Vector<Cell> ColVector = this.ParentSpreadsheet.getColumn(colColumn);
        ColVector = HelperFunctions.removeEndingEmptyCells(ColVector);
        if (hasFrequency && ColVector.size() < ResponseVector.size()) {
            this.app.showErrorDialog("missing column factor label(s)");
            return;
        }
        if (RowVector.size() != ColVector.size()) {
            this.app.showErrorDialog("The number of row labels and the number of column labels should be the same.");
            return;
        }
        if (hasFrequency && ResponseVector.size() != RowVector.size()) {
            this.app.showErrorDialog("The number of frequencies and row/column labels should be the same.");
            return;
        }
        CategoryCounter rowCategoryCounter = new CategoryCounter();
        for (int i = 0; i < RowVector.size(); ++i) {
            rowCategoryCounter.addCategory(RowVector.elementAt(i).getContents());
        }
        CategoryCounter colCategoryCounter = new CategoryCounter();
        for (int i = 0; i < ColVector.size(); ++i) {
            colCategoryCounter.addCategory(ColVector.elementAt(i).getContents());
        }
        CrossTabulation ct = new CrossTabulation(rowCategoryCounter.getSize(), colCategoryCounter.getSize());
        for (int i = 0; i < RowVector.size(); ++i) {
            double freq = 1.0;
            if (hasFrequency) {
                freq = ResponseVector.elementAt(i) != null ? ResponseVector.elementAt(i) : 0.0;
            }
            Cell row = RowVector.elementAt(i);
            Cell col = ColVector.elementAt(i);
            if (row == null || col == null || row.getContents().equals("") || col.getContents().equals("")) {
                this.app.showErrorDialog("Missing row or column label for data at row " + (i + 1));
                return;
            }
            ct.addObservation(rowCategoryCounter.getIndex(row.getContents()), colCategoryCounter.getIndex(col.getContents()), freq);
        }
        Vector<String> rowCategories = rowCategoryCounter.getCategories();
        Vector<String> colCategories = colCategoryCounter.getCategories();
        Vector<Vector<String>> resultVectors = new Vector<Vector<String>>();
        for (int j2 = 0; j2 < rowCategories.size() + 1; ++j2) {
            resultVectors.addElement(new Vector());
        }
        Vector<String> varNameVector = new Vector<String>();
        varNameVector.addElement("");
        text = text + "<table border=1>";
        text = text + "<tr><th>&nbsp;</th>";
        for (j = 0; j < colCategories.size(); ++j) {
            text = text + "<th>" + colCategories.elementAt(j) + "</th>";
            varNameVector.addElement(colCategories.elementAt(j));
        }
        varNameVector.addElement("All");
        text = text + "<th>All</th></tr>";
        for (int i = 0; i < rowCategories.size(); ++i) {
            String rowCategory = rowCategories.elementAt(i);
            int rowIndex = rowCategoryCounter.getIndex(rowCategory);
            text = text + "<tr><th>" + rowCategory + "</th>";
            ((Vector)resultVectors.elementAt(i)).addElement(rowCategory);
            for (int j3 = 0; j3 < colCategories.size(); ++j3) {
                String colCategory = colCategories.elementAt(j3);
                int colIndex = colCategoryCounter.getIndex(colCategory);
                double f = ct.getFrequency(rowIndex, colIndex);
                double percent = ct.getPercent(rowIndex, colIndex);
                text = text + "<td>" + f + " (" + HelperFunctions.formatFloat(percent * 100.0, 2) + "%)</td>";
                ((Vector)resultVectors.elementAt(i)).addElement(f + "");
            }
            double rowSum = ct.getRowSum(rowIndex);
            text = text + "<td>" + rowSum + " (" + HelperFunctions.formatFloat(ct.getRowSumPercent(rowIndex) * 100.0, 2) + "%)</td>";
            text = text + "</tr>";
            ((Vector)resultVectors.elementAt(i)).addElement(rowSum + "");
        }
        text = text + "<tr><th>All</th>";
        ((Vector)resultVectors.elementAt(rowCategories.size())).addElement("All");
        for (j = 0; j < colCategories.size(); ++j) {
            String colCategory = colCategories.elementAt(j);
            int colIndex = colCategoryCounter.getIndex(colCategory);
            double colSum = ct.getColumnSum(colIndex);
            text = text + "<td>" + colSum + " (" + HelperFunctions.formatFloat(ct.getColumnSumPercent(colIndex) * 100.0, 2) + "%)</td>";
            ((Vector)resultVectors.elementAt(rowCategories.size())).addElement(colSum + "");
        }
        double totalSum = ct.getTotalSum();
        text = text + "<td>" + totalSum + " (100.00%)</td>";
        text = text + "</tr></table>";
        text = text + "<br>";
        ((Vector)resultVectors.elementAt(rowCategories.size())).addElement(totalSum + "");
        if (this.ChiSquareCheckBox.isSelected()) {
            double significance;
            try {
                significance = Double.parseDouble(this.SigTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
            if (significance <= 0.0 || significance >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            ct.computeChiSquare();
            ContingencyTable table = ct.getContingencyTable();
            text = text + "<b>Chi-Square Test</b><br>";
            text = text + "<table border=1>";
            text = text + "<tr><td>Significance Level</td><td>DOF</td><td>&Chi;<sup>2</sup></td><td>Critical value</td><td>p-Value</td></tr>";
            text = text + "<tr><td>" + HelperFunctions.formatFloat(significance, 2) + "</td><td>" + table.DOF() + "</td><td>" + HelperFunctions.formatFloat(table.testStatistics(), 4) + "</td><td>" + HelperFunctions.formatFloat(table.criticalValue(significance), 4) + "</td><td>" + HelperFunctions.formatFloat(table.pValue(), 4) + "</td></tr>";
            text = text + "</table>";
        }
        if (this.StoreCheckBox.isSelected()) {
            Spreadsheet ThisSpreadsheet = new Spreadsheet(this.app);
            this.app.getDatasheetTabbedPane().addDatasheet(ThisSpreadsheet);
            ThisSpreadsheet.setData(resultVectors);
            ThisSpreadsheet.setVariablesRow(varNameVector);
            this.app.getDatasheetTabbedPane().setCurrentTabTitle("CrossTabulation*");
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ChiSquareCheckBoxStateChanged(ChangeEvent evt) {
        if (this.ChiSquareCheckBox.isSelected()) {
            this.SigTextField.setEnabled(true);
        } else {
            this.SigTextField.setEnabled(false);
        }
    }

    private void StoreCheckBoxStateChanged(ChangeEvent evt) {
    }
}

