/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.hytest;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;

public class HyTestConclusionDialog
extends StatcatoDialog {
    private static final int LESS = 0;
    private static final int LESSEQ = 1;
    private static final int GREATER = 2;
    private static final int GREATEREQ = 3;
    private static final int EQUAL = 4;
    private static final int NEQUAL = 5;
    private static final int LEFTTAIL = 0;
    private static final int RIGHTTAIL = 1;
    private static final int TWOTAIL = 2;
    private int tail = -1;
    private String claim = "";
    private String h0 = "";
    private String h1 = "";
    private String parameter;
    private int condition;
    private double value;
    private JTextField CVTextField;
    private JButton CancelButton;
    private JPanel ClaimPanel;
    private JTextField ClaimValueTextField1;
    private JButton ClearButton;
    private JLabel ConclusionLabel;
    private JPanel ConclusionPanel;
    private JComboBox ConditionalComboBox1;
    private JLabel GraphLabel;
    private JPanel GraphPanel;
    private JLabel H0Label;
    private JButton Next1Button;
    private JButton Next2Button;
    private JLabel PValueLabel;
    private JRadioButton PValueRadioButton;
    private JTextField PValueTextField;
    private JComboBox ParamComboBox1;
    private JPanel RejectPanel;
    private JLabel SigLabel;
    private JTextField SigTextField;
    private JTextField TSTextField;
    private JLabel TailLabel;
    private JRadioButton TradRadioButton;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;

    public HyTestConclusionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group = new ButtonGroup();
        group.add(this.TradRadioButton);
        group.add(this.PValueRadioButton);
        this.getRootPane().setDefaultButton(this.Next1Button);
        this.RejectPanel.setVisible(false);
        this.ConclusionPanel.setVisible(false);
        this.GraphPanel.setVisible(false);
        this.setHelpFile("stat-hytest-conc");
        this.name = "Hypothesis Test Conclusion Tool";
        this.description = "For determining the conclusion of a hypothesis test using the traditional or p-value approaches.";
        this.helpStrings.add("Enter the original claim of the hypothesis test.");
        this.helpStrings.add("Enter the critial value and test statistic if using the traditional approach.");
        this.helpStrings.add("Enter the significance and p-value if using the p-value approach.");
    }

    private void initComponents() {
        this.ClearButton = new JButton();
        this.CancelButton = new JButton();
        this.ClaimPanel = new JPanel();
        this.ParamComboBox1 = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.ConditionalComboBox1 = new JComboBox();
        this.ClaimValueTextField1 = new JTextField();
        this.jLabel13 = new JLabel();
        this.TailLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.Next1Button = new JButton();
        this.RejectPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.TSTextField = new JTextField();
        this.CVTextField = new JTextField();
        this.TradRadioButton = new JRadioButton();
        this.PValueRadioButton = new JRadioButton();
        this.SigLabel = new JLabel();
        this.PValueLabel = new JLabel();
        this.PValueTextField = new JTextField();
        this.SigTextField = new JTextField();
        this.H0Label = new JLabel();
        this.Next2Button = new JButton();
        this.ConclusionPanel = new JPanel();
        this.ConclusionLabel = new JLabel();
        this.GraphPanel = new JPanel();
        this.GraphLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hypothesis Test: Reaching a Conclusion");
        this.ClearButton.setText("Clear");
        this.ClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTestConclusionDialog.this.ClearButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTestConclusionDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.ClaimPanel.setBorder(BorderFactory.createTitledBorder("Original Claim"));
        this.ParamComboBox1.setEditable(true);
        this.ParamComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"mean ", "proportion", "variance", "standard deviation", ""}));
        this.jLabel11.setText("Parameter");
        this.jLabel12.setText("Condition");
        this.ConditionalComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"<html>&lt;</html", "<html>&le;</html>", "<html>&gt;</html>", "<html>&ge;</html>", "<html>=</html>", "<html>&ne;</html>"}));
        this.ConditionalComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HyTestConclusionDialog.this.ConditionalComboBox1ItemStateChanged(evt);
            }
        });
        this.ClaimValueTextField1.setText("0");
        this.jLabel13.setText("<html>Parameter name is editable if desired name is not <br>\navailable in the drop-down menu.<br>\nExamples of claims: mean &lt; 5, proportion = 0.4, <br>\nvariance &gt; 2.3, standard deviation &ne; 1.2</html>");
        this.jLabel2.setText("Value");
        this.Next1Button.setText("Next >>");
        this.Next1Button.setToolTipText("Next >>");
        this.Next1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTestConclusionDialog.this.Next1ButtonActionPerformed(evt);
            }
        });
        GroupLayout ClaimPanelLayout = new GroupLayout(this.ClaimPanel);
        this.ClaimPanel.setLayout(ClaimPanelLayout);
        ClaimPanelLayout.setHorizontalGroup(ClaimPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ClaimPanelLayout.createSequentialGroup().addContainerGap().addGroup(ClaimPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ClaimPanelLayout.createSequentialGroup().addGroup(ClaimPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ParamComboBox1, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ClaimPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ClaimPanelLayout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2)).addGroup(ClaimPanelLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.ConditionalComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ClaimValueTextField1, -2, 73, -2)))).addGroup(ClaimPanelLayout.createSequentialGroup().addComponent(this.Next1Button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.TailLabel, -2, 150, -2)).addComponent(this.jLabel13, -2, -1, -2)).addContainerGap(60, Short.MAX_VALUE)));
        ClaimPanelLayout.setVerticalGroup(ClaimPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ClaimPanelLayout.createSequentialGroup().addContainerGap().addGroup(ClaimPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ClaimPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ParamComboBox1, -2, -1, -2).addComponent(this.ClaimValueTextField1, -2, -1, -2).addComponent(this.ConditionalComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ClaimPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.Next1Button).addComponent(this.TailLabel, -2, 22, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.RejectPanel.setBorder(BorderFactory.createTitledBorder("Hypotheses and Sample Statistics"));
        this.jLabel6.setText("Select method:");
        this.jLabel7.setText("Critical Value:");
        this.jLabel8.setText("Test Statistic:");
        this.TradRadioButton.setSelected(true);
        this.TradRadioButton.setText("Traditional Method:");
        this.TradRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTestConclusionDialog.this.TradRadioButtonStateChanged(evt);
            }
        });
        this.PValueRadioButton.setText("p-Value Method:");
        this.PValueRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTestConclusionDialog.this.PValueRadioButtonStateChanged(evt);
            }
        });
        this.SigLabel.setText("Significance:");
        this.PValueLabel.setText("p-Value:");
        this.PValueTextField.setEnabled(false);
        this.SigTextField.setEnabled(false);
        this.H0Label.setText("Null Hypothesis:");
        this.Next2Button.setText("Next >>");
        this.Next2Button.setToolTipText("Next >>");
        this.Next2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTestConclusionDialog.this.Next2ButtonActionPerformed(evt);
            }
        });
        GroupLayout RejectPanelLayout = new GroupLayout(this.RejectPanel);
        this.RejectPanel.setLayout(RejectPanelLayout);
        RejectPanelLayout.setHorizontalGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RejectPanelLayout.createSequentialGroup().addContainerGap().addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RejectPanelLayout.createSequentialGroup().addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RejectPanelLayout.createSequentialGroup().addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.TSTextField).addComponent(this.CVTextField, -1, 64, Short.MAX_VALUE))).addComponent(this.TradRadioButton)).addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RejectPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.SigLabel).addComponent(this.PValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.PValueTextField).addComponent(this.SigTextField, -1, 59, Short.MAX_VALUE))).addGroup(RejectPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.PValueRadioButton)))).addGroup(RejectPanelLayout.createSequentialGroup().addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.H0Label).addComponent(this.jLabel6).addComponent(this.Next2Button)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        RejectPanelLayout.setVerticalGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RejectPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.H0Label).addGap(72, 72, 72).addComponent(this.jLabel6).addGap(18, 18, 18).addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TradRadioButton).addComponent(this.PValueRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CVTextField, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.SigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RejectPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TSTextField, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.PValueTextField, -2, -1, -2).addComponent(this.PValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Next2Button).addContainerGap(-1, Short.MAX_VALUE)));
        this.ConclusionPanel.setBorder(BorderFactory.createTitledBorder("Conclusion"));
        this.ConclusionLabel.setText("conclusion");
        GroupLayout ConclusionPanelLayout = new GroupLayout(this.ConclusionPanel);
        this.ConclusionPanel.setLayout(ConclusionPanelLayout);
        ConclusionPanelLayout.setHorizontalGroup(ConclusionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ConclusionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ConclusionLabel, -2, 357, -2).addContainerGap(18, Short.MAX_VALUE)));
        ConclusionPanelLayout.setVerticalGroup(ConclusionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ConclusionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ConclusionLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.GraphPanel.setBorder(BorderFactory.createTitledBorder("Type of Test"));
        GroupLayout GraphPanelLayout = new GroupLayout(this.GraphPanel);
        this.GraphPanel.setLayout(GraphPanelLayout);
        GraphPanelLayout.setHorizontalGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, GraphPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.GraphLabel, -1, 365, Short.MAX_VALUE).addContainerGap()));
        GraphPanelLayout.setVerticalGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GraphPanelLayout.createSequentialGroup().addComponent(this.GraphLabel, -1, 242, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ClaimPanel, -1, -1, Short.MAX_VALUE).addComponent(this.RejectPanel, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.ClearButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.GraphPanel, -2, -1, -2).addComponent(this.ConclusionPanel, -2, -1, -2).addComponent(this.CancelButton)).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.ClearButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.ClaimPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RejectPanel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.GraphPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConclusionPanel, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 48, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.ClearButton))));
        this.pack();
    }

    private void Next1ButtonActionPerformed(ActionEvent evt) {
        this.parameter = "";
        this.value = 0.0;
        this.constructHypotheses();
        this.getRootPane().setDefaultButton(this.Next2Button);
        this.RejectPanel.setVisible(true);
        this.GraphPanel.setVisible(true);
        this.pack();
    }

    private void constructHypotheses() {
        String selected = (String)this.ParamComboBox1.getSelectedItem();
        if (selected.equals("")) {
            this.app.showErrorDialog("Enter the paramter name or select one in the paramter list.");
            return;
        }
        this.parameter = selected;
        this.condition = this.ConditionalComboBox1.getSelectedIndex();
        this.setTestType(this.condition);
        String conditionString = this.convertConditionToString(this.condition);
        try {
            this.value = Double.parseDouble(this.ClaimValueTextField1.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number for hypothesized value in the original claim");
            return;
        }
        conditionString = this.convertConditionToString(this.condition);
        this.claim = this.parameter + " " + conditionString + " " + this.value;
        this.h0 = this.parameter + " = " + this.value;
        this.h1 = this.parameter + " " + this.convertConditionToString(this.returnAlternativeCondition(this.condition)) + " " + this.value;
        this.H0Label.setText("<html><b>Claim:</b>  " + this.claim + "<br>" + "<b>Null Hypothesis:</b>  " + this.h0 + "<br>" + "<b>Alternative Hypothesis:</b> " + this.h1 + "</html>");
    }

    private void setTestType(int condition) {
        switch (condition) {
            case 0: {
                this.tail = 0;
                break;
            }
            case 1: {
                this.tail = 1;
                break;
            }
            case 2: {
                this.tail = 1;
                break;
            }
            case 3: {
                this.tail = 0;
                break;
            }
            case 4: {
                this.tail = 2;
                break;
            }
            case 5: {
                this.tail = 2;
            }
        }
        if (this.tail == 0) {
            this.TailLabel.setText("Left tail test");
            ImageIcon icon = this.app.createImageIcon("normal-ltt.gif", "ltt");
            this.GraphLabel.setIcon(icon);
        } else if (this.tail == 1) {
            this.TailLabel.setText("Right tail test");
            ImageIcon icon = this.app.createImageIcon("normal-rtt.gif", "ltt");
            this.GraphLabel.setIcon(icon);
        } else {
            this.TailLabel.setText("Two tail test");
            ImageIcon icon = this.app.createImageIcon("normal-ttt.gif", "ltt");
            this.GraphLabel.setIcon(icon);
        }
    }

    private String convertConditionToString(int condition) {
        switch (condition) {
            case 0: {
                return "&lt;";
            }
            case 1: {
                return "&le;";
            }
            case 2: {
                return "&gt;";
            }
            case 3: {
                return "&ge;";
            }
            case 4: {
                return "=";
            }
            case 5: {
                return "&ne;";
            }
        }
        return "";
    }

    private int returnAlternativeCondition(int condition) {
        switch (condition) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    private void TradRadioButtonStateChanged(ChangeEvent evt) {
        if (this.TradRadioButton.isSelected()) {
            this.CVTextField.setEnabled(true);
            this.TSTextField.setEnabled(true);
        } else {
            this.CVTextField.setEnabled(false);
            this.TSTextField.setEnabled(false);
        }
    }

    private void PValueRadioButtonStateChanged(ChangeEvent evt) {
        if (this.PValueRadioButton.isSelected()) {
            this.SigTextField.setEnabled(true);
            this.PValueTextField.setEnabled(true);
        } else {
            this.SigTextField.setEnabled(false);
            this.PValueTextField.setEnabled(false);
        }
    }

    private void Next2ButtonActionPerformed(ActionEvent evt) {
        this.Next1ButtonActionPerformed(null);
        boolean rejectNull = false;
        if (this.TradRadioButton.isSelected()) {
            try {
                double CV = Double.parseDouble(this.CVTextField.getText());
                double TS = Double.parseDouble(this.TSTextField.getText());
                if (this.tail == 1) {
                    if (TS >= CV) {
                        rejectNull = true;
                    }
                    rejectNull = false;
                }
                if (this.tail == 0) {
                    if (TS <= CV) {
                        rejectNull = true;
                    }
                    rejectNull = false;
                }
                if (Math.abs(TS) >= Math.abs(CV)) {
                    rejectNull = true;
                }
                rejectNull = false;
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter valid numbers for the critical value and test statistic.");
                return;
            }
        } else {
            try {
                double significance = Double.parseDouble(this.SigTextField.getText());
                double pvalue = Double.parseDouble(this.PValueTextField.getText());
                rejectNull = pvalue <= significance;
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter valid numbers for the significance and p-Value.");
                return;
            }
        }
        String text = "<html>";
        text = rejectNull ? text + "Reject null hypothesis.<br><br>" : text + "Fail to reject null hypothesis.<br><br>";
        this.condition = this.ConditionalComboBox1.getSelectedIndex();
        text = this.condition == 4 || this.condition == 1 || this.condition == 3 ? (rejectNull ? text + "This is sufficient evidence to warrant rejection of the claim that " : text + "There is not sufficient evidence to warrant rejection of the claim that ") : (rejectNull ? text + "The sample data support the claim that " : text + "There is not sufficient evidence to support the claim that ");
        text = text + this.claim + ".</html>";
        this.ConclusionLabel.setText(text);
        this.ConclusionPanel.setVisible(true);
        this.pack();
    }

    private void ClearButtonActionPerformed(ActionEvent evt) {
        this.ParamComboBox1.setSelectedIndex(0);
        this.ConditionalComboBox1.setSelectedIndex(0);
        this.ClaimValueTextField1.setText("0");
        this.CVTextField.setText("");
        this.TSTextField.setText("");
        this.SigTextField.setText("");
        this.PValueTextField.setText("");
        this.RejectPanel.setVisible(false);
        this.ConclusionPanel.setVisible(false);
        this.GraphPanel.setVisible(false);
        this.pack();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ConditionalComboBox1ItemStateChanged(ItemEvent evt) {
        this.condition = this.ConditionalComboBox1.getSelectedIndex();
        this.setTestType(this.condition);
    }
}

