/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.hytest;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.statistics.inferential.HypothesisTest1Prop;
import org.statcato.utils.HelperFunctions;

public class HyTest1PopPropDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JPanel AltPanel;
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JLabel ConfLabel;
    private JRadioButton ConfRadioButton;
    private JTextField ConfidenceTextField;
    private JLabel EventsLabel;
    private JTextField EventsTextField;
    private JTextField HyTextField;
    private JPanel InputPanel;
    private JButton OKButton;
    private JRadioButton SampleRadioButton;
    private JLabel SigLabel;
    private JPanel SigPanel;
    private JRadioButton SigRadioButton;
    private JTextField SigTextField;
    private JRadioButton SummaryRadioButton;
    private JLabel TrialsLabel;
    private JTextField TrialsTextField;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public HyTest1PopPropDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SampleRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.SigRadioButton);
        group3.add(this.ConfRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-hytest-prop");
        this.name = "Hypothesis Test: 1-Population Proportion";
        this.description = "For performing calculations for testing claims about a population proportion.";
        this.helpStrings.add("If individual samples are entered in a single column of the datasheet, select the Samples in column: radio button, and select the column name in the drop-down menu.");
        this.helpStrings.add("To use summary statistics of the sample data, select the Summarized sample data: radio button, and input the number of events and the number of trials in the provided text fields.");
        this.helpStrings.add("Enter the significance or confidence level (between 0 and 1).");
        this.helpStrings.add("Select the form of the alternative hypothesis and enter the hypothesized population proportion in the provided text box.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.InputPanel = new JPanel();
        this.SampleRadioButton = new JRadioButton();
        this.TrialsLabel = new JLabel();
        this.SummaryRadioButton = new JRadioButton();
        this.ColumnComboBox = new JComboBox();
        this.EventsLabel = new JLabel();
        this.EventsTextField = new JTextField();
        this.TrialsTextField = new JTextField();
        this.AltPanel = new JPanel();
        this.AltComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.HyTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.SigPanel = new JPanel();
        this.SigLabel = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.ConfRadioButton = new JRadioButton();
        this.SigRadioButton = new JRadioButton();
        this.SigTextField = new JTextField();
        this.ConfLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hypothesis Test: 1-Population Proportion");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest1PopPropDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyTest1PopPropDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.InputPanel.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in column:");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopPropDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.TrialsLabel.setText("Number of trials:");
        this.TrialsLabel.setEnabled(false);
        this.SummaryRadioButton.setText("Summarized sample data:");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopPropDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.EventsLabel.setText("Number of events:");
        this.EventsLabel.setEnabled(false);
        this.EventsTextField.setEnabled(false);
        this.TrialsTextField.setEnabled(false);
        GroupLayout InputPanelLayout = new GroupLayout(this.InputPanel);
        this.InputPanel.setLayout(InputPanelLayout);
        InputPanelLayout.setHorizontalGroup(InputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(InputPanelLayout.createSequentialGroup().addContainerGap().addGroup(InputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleRadioButton).addGroup(InputPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(InputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.EventsLabel).addGroup(InputPanelLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.TrialsLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(InputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.TrialsTextField).addComponent(this.EventsTextField, -2, 106, -2))).addGroup(InputPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, InputPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.ColumnComboBox, 0, -1, Short.MAX_VALUE)).addComponent(this.SummaryRadioButton, GroupLayout.Alignment.LEADING))).addContainerGap(20, Short.MAX_VALUE)));
        InputPanelLayout.setVerticalGroup(InputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(InputPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColumnComboBox, -2, -1, -2).addGap(10, 10, 10).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(InputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.EventsLabel).addComponent(this.EventsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(InputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TrialsLabel).addComponent(this.TrialsTextField, -2, -1, -2)).addContainerGap(31, Short.MAX_VALUE)));
        this.AltPanel.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        this.jLabel3.setText("Alternative Hypothesis:");
        this.jLabel2.setText("Hypothesized Proportion:");
        GroupLayout AltPanelLayout = new GroupLayout(this.AltPanel);
        this.AltPanel.setLayout(AltPanelLayout);
        AltPanelLayout.setHorizontalGroup(AltPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AltPanelLayout.createSequentialGroup().addContainerGap().addGroup(AltPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AltPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AltComboBox, -2, -1, -2)).addGroup(AltPanelLayout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HyTextField, -2, 78, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        AltPanelLayout.setVerticalGroup(AltPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AltPanelLayout.createSequentialGroup().addContainerGap().addGroup(AltPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.AltComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(AltPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.HyTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.SigPanel.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.SigLabel.setText("0 - 1.00 (e.g. 0.05)");
        this.ConfidenceTextField.setText("0.95");
        this.ConfidenceTextField.setEnabled(false);
        this.ConfidenceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest1PopPropDialog.this.ConfidenceTextFieldFocusLost(evt);
            }
        });
        this.ConfRadioButton.setText("Confidence Level:");
        this.ConfRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopPropDialog.this.ConfRadioButtonStateChanged(evt);
            }
        });
        this.SigRadioButton.setSelected(true);
        this.SigRadioButton.setText("Significance Level:");
        this.SigRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HyTest1PopPropDialog.this.SigRadioButtonStateChanged(evt);
            }
        });
        this.SigTextField.setText("0.05");
        this.SigTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyTest1PopPropDialog.this.SigTextFieldFocusLost(evt);
            }
        });
        this.ConfLabel.setText("0 - 1.00 (e.g. 0.95)");
        this.ConfLabel.setEnabled(false);
        GroupLayout SigPanelLayout = new GroupLayout(this.SigPanel);
        this.SigPanel.setLayout(SigPanelLayout);
        SigPanelLayout.setHorizontalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addContainerGap().addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, SigPanelLayout.createSequentialGroup().addComponent(this.ConfRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.ConfidenceTextField, -2, 81, -2)).addGroup(SigPanelLayout.createSequentialGroup().addComponent(this.SigRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 79, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SigLabel).addComponent(this.ConfLabel)).addContainerGap()));
        SigPanelLayout.setVerticalGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SigPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigRadioButton).addComponent(this.SigTextField, -2, -1, -2).addComponent(this.SigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.ConfRadioButton).addComponent(this.ConfLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.InputPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.AltPanel, -1, -1, Short.MAX_VALUE).addComponent(this.SigPanel, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(228, 228, 228).addComponent(this.OKButton, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(15, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.SigPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AltPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.InputPanel, -1, -1, Short.MAX_VALUE)).addGap(43, 43, 43).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.EventsLabel.setEnabled(true);
            this.EventsTextField.setEnabled(true);
            this.TrialsLabel.setEnabled(true);
            this.TrialsTextField.setEnabled(true);
        } else {
            this.EventsLabel.setEnabled(false);
            this.EventsTextField.setEnabled(false);
            this.TrialsLabel.setEnabled(false);
            this.TrialsTextField.setEnabled(false);
        }
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("hypothesis test 1 proportion");
        int events = 0;
        int trials = 0;
        double confidenceLevel = 0.0;
        double pHat = 0.0;
        String heading = "Hypothesis Test - One population proportion:";
        String text = "";
        if (this.ConfRadioButton.isSelected()) {
            try {
                confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
        } else {
            try {
                confidenceLevel = 1.0 - Double.parseDouble(this.SigTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
                return;
            }
        }
        heading = heading + "  confidence level = " + String.format("%." + HelperFunctions.getNumDecimalPlaces(this.ConfidenceTextField.getText()) + "f", confidenceLevel);
        if (this.SampleRadioButton.isSelected()) {
            String columnLabel = this.ColumnComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            String cat1 = "";
            String cat2 = "";
            int count1 = 0;
            int count2 = 0;
            for (int i = 0; i < StrColumnVector.size(); ++i) {
                String s = StrColumnVector.elementAt(i).getContents().trim();
                if (s.equals("")) continue;
                if (cat1.equals("")) {
                    cat1 = s;
                    ++count1;
                    continue;
                }
                if (s.equals(cat1)) {
                    ++count1;
                    continue;
                }
                if (cat2.equals("")) {
                    cat2 = s;
                    ++count2;
                    continue;
                }
                if (s.equals(cat2)) {
                    ++count2;
                    continue;
                }
                this.app.showErrorDialog("The input column contains more than two categories.");
                return;
            }
            trials = count1 + count2;
            if (trials == 0) {
                this.app.showErrorDialog("The input column is empty.");
                return;
            }
            events = count1;
            text = text + "Input: " + columnLabel + "<br>";
            text = text + "Event: " + cat1 + "<br>";
        } else {
            try {
                events = Integer.parseInt(this.EventsTextField.getText());
                trials = Integer.parseInt(this.TrialsTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            if (events > trials) {
                this.app.showErrorDialog("The number of events must not be greater than the number of trials.");
                return;
            }
            text = text + "Input: Summary data<br>";
        }
        try {
            pHat = Double.parseDouble(this.HyTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the hypothesized proportion.");
            return;
        }
        if (pHat <= 0.0 || pHat >= 1.0) {
            this.app.showErrorDialog("Enter a valid number for the hypothesized proportion.");
            return;
        }
        double p = (double)events / (double)trials;
        if ((double)trials * p < 5.0 || (double)trials * (1.0 - p) < 5.0) {
            text = text + "* WARNING: The sample size is too small for normal approximation to be valid. *<br>";
        }
        int typeTest = this.AltComboBox.getSelectedIndex();
        HypothesisTest1Prop ht = new HypothesisTest1Prop(trials, pHat, confidenceLevel, typeTest);
        text = text + "Null hypothesis: p = " + pHat + "<br>";
        text = text + "Alternative hypothesis: p ";
        text = typeTest == HypothesisTest.LEFT_TAIL ? text + "&lt;" : (typeTest == HypothesisTest.RIGHT_TAIL ? text + "&gt;" : text + "&ne;");
        text = text + " " + pHat + "<br>";
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>N</td><td>Sample Proportion</td>";
        text = text + "<td>Significance Level</td></td><td>Critical Value</td><td>Test Statistic Z</td><td>p-Value</td></tr>";
        text = text + "<tr><td>" + trials + "</td><td>" + HelperFunctions.formatFloat(p, 3) + "</td><td>" + HelperFunctions.formatFloat(1.0 - confidenceLevel, 2) + "</td><td>" + ht.criticalValue() + "</td><td>" + HelperFunctions.formatFloat(ht.testStatistics(p), 3) + "</td><td>" + HelperFunctions.formatFloat(ht.pValue(p), 4) + "</td></tr></table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ConfidenceTextFieldFocusLost(FocusEvent evt) {
        try {
            String confString = this.ConfidenceTextField.getText();
            double conf = Double.parseDouble(confString);
            double sig = 1.0 - conf;
            this.SigTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(confString) + "f", sig));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void ConfRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ConfRadioButton.isSelected()) {
            this.ConfidenceTextField.setEnabled(true);
            this.ConfLabel.setEnabled(true);
        } else {
            this.ConfidenceTextField.setEnabled(false);
            this.ConfLabel.setEnabled(false);
        }
    }

    private void SigRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SigRadioButton.isSelected()) {
            this.SigTextField.setEnabled(true);
            this.SigLabel.setEnabled(true);
        } else {
            this.SigTextField.setEnabled(false);
            this.SigLabel.setEnabled(false);
        }
    }

    private void SigTextFieldFocusLost(FocusEvent evt) {
        try {
            String sigString = this.SigTextField.getText();
            double sig = Double.parseDouble(sigString);
            double conf = 1.0 - sig;
            this.ConfidenceTextField.setText(String.format("%." + HelperFunctions.getNumDecimalPlaces(sigString) + "f", conf));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

