/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.correg;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.graph.StatcatoMultipleChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.CorrelationRegression;
import org.statcato.utils.HelperFunctions;

public class CorrelationRegressionDialog
extends StatcatoDialog {
    private static int HISTOGRAM_NUM_BINS = 10;
    private JButton AddButton;
    private JButton CancelButton;
    private JButton ClearButton1;
    private JCheckBox GraphCheckBox;
    private JCheckBox HistogramResidualCheckBox;
    private JCheckBox LegendCheckBox;
    private JCheckBox LineCheckBox;
    private JCheckBox NormalResidualPlotCheckBox;
    private JButton OKButton;
    private JButton RemoveButton;
    private JCheckBox ResidualCheckBox;
    private JPanel ResidualPanel;
    private JCheckBox ResidualVsPredictedCheckBox;
    private JCheckBox ResidualVsXCheckBox;
    private JCheckBox ResidualsVsOrderCheckBox;
    private JPanel ScatterplotPanel;
    private JList SeriesList;
    private JTextField SigTextField;
    private JTextField TitleTextField;
    private JComboBox XComboBox;
    private JTextField XTextField;
    private JComboBox YComboBox;
    private JTextField YTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public CorrelationRegressionDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("stat-reg-two-variables");
        this.name = "Linear Correlation and Regression";
        this.description = "For performing computations that determine the correlation and regression between two variables. ";
        this.helpStrings.add("Select the columns containing data values for the input variables.");
        this.helpStrings.add("A correlation and regression analysis is done for each pair of variables.");
        this.helpStrings.add("Enter the significance level of the hypothesis test for correlation.");
        this.helpStrings.add("Select the Show a scatterplot for all pairs of data values check box to display a scatter plot showing data values in each pair of input variables.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.XComboBox);
        this.updateComboBox(this.YComboBox);
        this.clearMutableColumnsList(this.SeriesList);
    }

    public void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.XComboBox);
        this.ParentSpreadsheet.populateComboBox(this.YComboBox);
        this.SeriesList.setSelectionMode(0);
        this.ScatterplotPanel.setVisible(false);
        this.ResidualPanel.setVisible(false);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.pack();
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.SeriesList = new JList(new DefaultListModel());
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.XComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.YComboBox = new JComboBox();
        this.AddButton = new JButton();
        this.jLabel9 = new JLabel();
        this.RemoveButton = new JButton();
        this.ClearButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.GraphCheckBox = new JCheckBox();
        this.ScatterplotPanel = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.LegendCheckBox = new JCheckBox();
        this.YTextField = new JTextField();
        this.TitleTextField = new JTextField();
        this.XTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.LineCheckBox = new JCheckBox();
        this.ResidualCheckBox = new JCheckBox();
        this.ResidualPanel = new JPanel();
        this.ResidualVsXCheckBox = new JCheckBox();
        this.ResidualVsPredictedCheckBox = new JCheckBox();
        this.NormalResidualPlotCheckBox = new JCheckBox();
        this.HistogramResidualCheckBox = new JCheckBox();
        this.ResidualsVsOrderCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Linear Correlation and Regression");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationRegressionDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationRegressionDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Independent/dependent variable series");
        this.SeriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CorrelationRegressionDialog.this.SeriesListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.SeriesList);
        this.jLabel2.setText("<html>Select the independent (x) and the <br>\ndependent (y) variables of a new series:");
        this.jLabel3.setText("X variable:");
        this.XComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CorrelationRegressionDialog.this.XComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel4.setText("y variable:");
        this.YComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CorrelationRegressionDialog.this.YComboBoxItemStateChanged(evt);
            }
        });
        this.AddButton.setText("Add Series");
        this.AddButton.setEnabled(false);
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationRegressionDialog.this.AddButtonActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Select the series to be removed:");
        this.RemoveButton.setText("Remove Series");
        this.RemoveButton.setEnabled(false);
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationRegressionDialog.this.RemoveButtonActionPerformed(evt);
            }
        });
        this.ClearButton1.setText("Clear Input List");
        this.ClearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationRegressionDialog.this.ClearButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 103, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.YComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.XComboBox, 0, 110, Short.MAX_VALUE))).addComponent(this.AddButton))).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel2, -2, -1, -2)))).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addGap(18, 18, 18).addComponent(this.RemoveButton))).addGap(90, 90, 90)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.ClearButton1).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.XComboBox, -2, -1, -2).addComponent(this.jLabel3)).addGap(13, 13, 13).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YComboBox, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AddButton)).addComponent(this.jScrollPane1, -2, -1, -2)).addGap(15, 15, 15).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.RemoveButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ClearButton1).addContainerGap(15, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addContainerGap(175, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2)).addContainerGap()));
        this.GraphCheckBox.setText("Show a scatterplot for all pairs of data values");
        this.GraphCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CorrelationRegressionDialog.this.GraphCheckBoxStateChanged(evt);
            }
        });
        this.ScatterplotPanel.setBorder(BorderFactory.createTitledBorder("Scatterplot Options"));
        this.jLabel7.setText("Plot Title:");
        this.jLabel8.setText("X-axis Label:");
        this.LegendCheckBox.setSelected(true);
        this.LegendCheckBox.setText("Show legend");
        this.YTextField.setText("y");
        this.TitleTextField.setText("Scatterplot");
        this.XTextField.setText("x");
        this.jLabel5.setText("Y-axis Label:");
        this.LineCheckBox.setSelected(true);
        this.LineCheckBox.setText("Show regression line");
        GroupLayout ScatterplotPanelLayout = new GroupLayout(this.ScatterplotPanel);
        this.ScatterplotPanel.setLayout(ScatterplotPanelLayout);
        ScatterplotPanelLayout.setHorizontalGroup(ScatterplotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ScatterplotPanelLayout.createSequentialGroup().addContainerGap().addGroup(ScatterplotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LineCheckBox).addComponent(this.LegendCheckBox).addGroup(ScatterplotPanelLayout.createSequentialGroup().addGroup(ScatterplotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(ScatterplotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.TitleTextField, -1, 188, Short.MAX_VALUE).addComponent(this.XTextField).addComponent(this.YTextField))).addComponent(this.jLabel8)).addContainerGap(-1, Short.MAX_VALUE)));
        ScatterplotPanelLayout.setVerticalGroup(ScatterplotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ScatterplotPanelLayout.createSequentialGroup().addContainerGap().addGroup(ScatterplotPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.XTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ScatterplotPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.YTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ScatterplotPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LegendCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LineCheckBox).addContainerGap(17, Short.MAX_VALUE)));
        this.ResidualCheckBox.setText("Show Residual Plots");
        this.ResidualCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CorrelationRegressionDialog.this.ResidualCheckBoxStateChanged(evt);
            }
        });
        this.ResidualPanel.setBorder(BorderFactory.createTitledBorder("Residual Plot Options"));
        this.ResidualVsXCheckBox.setText("Residuals vs. X Variable");
        this.ResidualVsPredictedCheckBox.setSelected(true);
        this.ResidualVsPredictedCheckBox.setText("Residuals vs. Predicted (Fitted) Values");
        this.NormalResidualPlotCheckBox.setText("Normal Probability Plot of Residuals");
        this.HistogramResidualCheckBox.setText("Histogram of Residuals");
        this.ResidualsVsOrderCheckBox.setText("Residuals vs. Observation Order");
        GroupLayout ResidualPanelLayout = new GroupLayout(this.ResidualPanel);
        this.ResidualPanel.setLayout(ResidualPanelLayout);
        ResidualPanelLayout.setHorizontalGroup(ResidualPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResidualPanelLayout.createSequentialGroup().addContainerGap().addGroup(ResidualPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ResidualVsXCheckBox).addComponent(this.ResidualVsPredictedCheckBox).addComponent(this.NormalResidualPlotCheckBox).addComponent(this.HistogramResidualCheckBox).addComponent(this.ResidualsVsOrderCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        ResidualPanelLayout.setVerticalGroup(ResidualPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResidualPanelLayout.createSequentialGroup().addComponent(this.ResidualVsXCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ResidualVsPredictedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NormalResidualPlotCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HistogramResidualCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ResidualsVsOrderCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 393, -2).addComponent(this.jPanel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.GraphCheckBox).addComponent(this.ResidualCheckBox)).addGap(19, 19, 19)).addGroup(layout.createSequentialGroup().addComponent(this.ScatterplotPanel, -1, -1, Short.MAX_VALUE).addContainerGap()))).addGroup(layout.createSequentialGroup().addComponent(this.ResidualPanel, -1, -1, Short.MAX_VALUE).addContainerGap()))).addGroup(layout.createSequentialGroup().addGap(279, 279, 279).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.GraphCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ScatterplotPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ResidualCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ResidualPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 22, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("correlation & regression");
        double significance = 0.0;
        String heading = "Correlation and Regression:";
        String text = "";
        if (this.SeriesList.getModel().getSize() == 0) {
            this.app.showErrorDialog("Add at least one series.");
            return;
        }
        try {
            significance = Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (significance <= 0.0 || significance >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  Significance level = " + significance;
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.SeriesList.getModel().getSize(); ++i) {
            JFreeChart residualVsXChart;
            String xy = (String)this.SeriesList.getModel().getElementAt(i);
            text = text + "--------------------------<br>";
            text = text + "Series: " + xy + "<br>";
            String[] items = xy.split(",");
            String itemX = items[0];
            String itemY = items[1];
            text = text + "x = " + itemX + "<br>";
            text = text + "y = " + itemY + "<br>";
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(items[0]);
            int selectedYColumn = this.ParentSpreadsheet.parseColumnNumber(items[1]);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (XColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + items[0] + ": all data must be numbers.");
                return;
            }
            XColumnVector = HelperFunctions.removeNullValues(XColumnVector);
            StrColumnVector = this.ParentSpreadsheet.getColumn(selectedYColumn);
            Vector<Double> YColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (YColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + items[1] + ": all data must be numbers.");
                return;
            }
            YColumnVector = HelperFunctions.removeNullValues(YColumnVector);
            if (XColumnVector.size() != YColumnVector.size()) {
                this.app.showErrorDialog("The number of x values must be the same as the number of y values.");
                return;
            }
            CorrelationRegression CG = new CorrelationRegression(XColumnVector, YColumnVector, significance);
            text = text + CG + "</td>";
            this.app.addLogParagraph(heading, text);
            ArrayList<Double> predictedValues = CG.PredictedValues();
            ArrayList<Double> residuals = CG.Residuals();
            XYSeries series = new XYSeries((Comparable)((Object)xy));
            XYSeries residualsVsXSeries = new XYSeries((Comparable)((Object)("Residuals vs. " + itemX)));
            XYSeries residualsVsOrder = new XYSeries((Comparable)((Object)"Residuals vs. Observation Order"));
            double seriesMin = Double.POSITIVE_INFINITY;
            double seriesMax = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < XColumnVector.size(); ++j) {
                double x = XColumnVector.elementAt(j);
                if (x < min) {
                    min = x;
                }
                if (x < seriesMin) {
                    seriesMin = x;
                }
                if (x > max) {
                    max = x;
                }
                if (x > seriesMax) {
                    seriesMax = x;
                }
                series.add(x, YColumnVector.elementAt(j));
                residualsVsXSeries.add(x, (Number)residuals.get(j));
                residualsVsOrder.add((double)(j + 1), (Number)residuals.get(j));
            }
            seriesCollection.addSeries(series);
            XYSeries residualsVsPredictedSeries = new XYSeries((Comparable)((Object)("Residuals vs. Predicted " + itemY)));
            double predictedMin = Double.POSITIVE_INFINITY;
            double predictedMax = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < predictedValues.size(); ++j) {
                double predicted = predictedValues.get(j);
                if (predicted < predictedMin) {
                    predictedMin = predicted;
                }
                if (predicted > predictedMax) {
                    predictedMax = predicted;
                }
                residualsVsPredictedSeries.add(predicted, (Number)residuals.get(j));
            }
            ArrayList<JFreeChart> chartList = new ArrayList<JFreeChart>();
            if (this.ResidualVsXCheckBox.isSelected()) {
                XYSeriesCollection residualSeriesCollection = new XYSeriesCollection();
                residualSeriesCollection.addSeries(residualsVsXSeries);
                residualVsXChart = GraphFactory.createResidualPlot(residualSeriesCollection, "Residuals vs. " + itemX, itemX, "Residuals", false, true, seriesMin, seriesMax);
                chartList.add(residualVsXChart);
            }
            if (this.ResidualVsPredictedCheckBox.isSelected()) {
                XYSeriesCollection residualSeriesCollection = new XYSeriesCollection();
                residualSeriesCollection.addSeries(residualsVsPredictedSeries);
                residualVsXChart = GraphFactory.createResidualPlot(residualSeriesCollection, "Residuals vs. Predicted (" + itemY + ")", "Predicted Values (" + itemY + ")", "Residuals", false, true, predictedMin, predictedMax);
                chartList.add(residualVsXChart);
            }
            if (this.NormalResidualPlotCheckBox.isSelected()) {
                JFreeChart plot = GraphFactory.createNormalQuantilePlot(residuals, "Normal Probability Plot of Residuals (" + itemY + ")", "Residual", "Z Score", true, true);
                chartList.add(plot);
            }
            if (this.HistogramResidualCheckBox.isSelected()) {
                HistogramDataset dataset = new HistogramDataset();
                dataset.setType(HistogramType.FREQUENCY);
                double residualMin = BasicStatistics.min(residuals);
                double residualMax = BasicStatistics.max(residuals);
                double minBin = residualMin;
                dataset.addSeries((Comparable)((Object)"Residuals"), HelperFunctions.ConvertDoubleArrayListToArray(residuals), HISTOGRAM_NUM_BINS, residualMin, residualMax);
                TickUnits units = new TickUnits();
                for (int k = 0; k < dataset.getSeriesCount(); ++k) {
                    double width = dataset.getEndX(k, 0).doubleValue() - dataset.getStartX(k, 0).doubleValue();
                    units.add(new NumberTickUnit(width));
                }
                JFreeChart chart = GraphFactory.createHistogram("Histogram of Residuals (" + itemY + ")", "Residuals", "Frequency", dataset, false, units, HISTOGRAM_NUM_BINS, minBin, false, -1.0);
                chartList.add(chart);
            }
            if (this.ResidualsVsOrderCheckBox.isSelected()) {
                XYSeriesCollection residualSeriesCollection = new XYSeriesCollection();
                residualSeriesCollection.addSeries(residualsVsOrder);
                JFreeChart residualVsOrderChart = GraphFactory.createResidualPlot(residualSeriesCollection, "Residuals (" + itemY + ") vs. Observation Order", "Observation Order", "Residuals", false, true, 0.0, residuals.size());
                chartList.add(residualVsOrderChart);
            }
            StatcatoMultipleChartFrame chartFrame = new StatcatoMultipleChartFrame("Residual Plots", chartList, this.app);
            chartFrame.pack();
            chartFrame.setVisible(true);
        }
        if (this.GraphCheckBox.isSelected()) {
            JFreeChart chart = GraphFactory.createScatterplot(seriesCollection, this.TitleTextField.getText(), this.XTextField.getText(), this.YTextField.getText(), this.LegendCheckBox.isSelected(), this.LineCheckBox.isSelected(), min, max);
            StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), chart, this.app);
            frame.pack();
            frame.setVisible(true);
        }
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void GraphCheckBoxStateChanged(ChangeEvent evt) {
        if (this.GraphCheckBox.isSelected()) {
            this.ScatterplotPanel.setVisible(true);
        } else {
            this.ScatterplotPanel.setVisible(false);
        }
        this.pack();
    }

    private void SeriesListValueChanged(ListSelectionEvent evt) {
        if (this.SeriesList.getSelectedIndex() != -1) {
            this.RemoveButton.setEnabled(true);
        } else {
            this.RemoveButton.setEnabled(false);
        }
    }

    private void XComboBoxItemStateChanged(ItemEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0 || this.YComboBox.getSelectedIndex() == 0) {
            this.AddButton.setEnabled(false);
        } else {
            this.AddButton.setEnabled(true);
        }
    }

    private void YComboBoxItemStateChanged(ItemEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0 || this.YComboBox.getSelectedIndex() == 0) {
            this.AddButton.setEnabled(false);
        } else {
            this.AddButton.setEnabled(true);
        }
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select x variable of the new series.");
            return;
        }
        if (this.YComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select y variable of the new series.");
            return;
        }
        String x = this.XComboBox.getSelectedItem().toString();
        String y = this.YComboBox.getSelectedItem().toString();
        String z = x.trim() + "," + y.trim();
        ((DefaultListModel)this.SeriesList.getModel()).addElement(z);
        this.SeriesList.setSelectedValue(z, true);
        this.OKButton.requestFocusInWindow();
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        if (this.SeriesList.getSelectedValue() != null) {
            ((DefaultListModel)this.SeriesList.getModel()).removeElementAt(this.SeriesList.getSelectedIndex());
            this.AddButton.requestFocusInWindow();
        }
    }

    private void ClearButton1ActionPerformed(ActionEvent evt) {
        this.clearMutableColumnsList(this.SeriesList);
    }

    private void ResidualCheckBoxStateChanged(ChangeEvent evt) {
        if (this.ResidualCheckBox.isSelected()) {
            this.ResidualPanel.setVisible(true);
        } else {
            this.ResidualPanel.setVisible(false);
        }
        this.pack();
    }

    public void selectResidualCheckBox() {
        this.ResidualCheckBox.setSelected(true);
    }
}

