/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.ci;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.CI2PopProp;
import org.statcato.statistics.inferential.ConfidenceInterval;
import org.statcato.utils.HelperFunctions;

public class CI2PopPropDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField ConfidenceTextField;
    private JTextField Events1TextField;
    private JTextField Events2TextField;
    private JComboBox LabelsComboBox;
    private JButton OKButton;
    private JComboBox Pop1ComboBox;
    private JComboBox Pop2ComboBox;
    private JRadioButton Sample1ColRadioButton;
    private JRadioButton Sample2ColRadioButton;
    private JRadioButton SummaryRadioButton;
    private JTextField Trials1TextField;
    private JTextField Trials2TextField;
    private JComboBox ValuesComboBox;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public CI2PopPropDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.Sample1ColRadioButton);
        group1.add(this.Sample2ColRadioButton);
        group1.add(this.SummaryRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.LabelsComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ValuesComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Pop1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Pop2ComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-ci-2prop");
        this.name = "Confidence Interval: Two Population Proportion";
        this.description = "For computing confidence intervals for the difference of two population proportions.";
        this.helpStrings.add("The sample data of the population must be of only two categories. They can be inputted in one of three ways...");
        this.helpStrings.add("Samples in one column: The population labels of samples are in one column of the datasheet, and the individual samples are in another column.");
        this.helpStrings.add("Samples in two columns: The samples of the two population are in two separate columns.");
        this.helpStrings.add("Summarized sample data: The number of events and the number of trials of each of the two populations are provided.");
        this.helpStrings.add("The confidence level must be between 0 and 1.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.LabelsComboBox);
        this.updateComboBox(this.ValuesComboBox);
        this.updateComboBox(this.Pop1ComboBox);
        this.updateComboBox(this.Pop2ComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.Pop2ComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel4 = new JLabel();
        this.Trials1TextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.Pop1ComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.Sample1ColRadioButton = new JRadioButton();
        this.LabelsComboBox = new JComboBox();
        this.Sample2ColRadioButton = new JRadioButton();
        this.Trials2TextField = new JTextField();
        this.ValuesComboBox = new JComboBox();
        this.Events1TextField = new JTextField();
        this.Events2TextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.SummaryRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Confidence Interval: Two Population Proportion");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI2PopPropDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI2PopPropDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel8.setText("Trials");
        this.Pop2ComboBox.setEnabled(false);
        this.jLabel6.setText("Population 2:");
        this.jLabel4.setText("Population 2:");
        this.Trials1TextField.setEnabled(false);
        this.jLabel7.setText("Events");
        this.Pop1ComboBox.setEnabled(false);
        this.jLabel2.setText("Values in column:");
        this.Sample1ColRadioButton.setSelected(true);
        this.Sample1ColRadioButton.setText("Samples in one column");
        this.Sample1ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI2PopPropDialog.this.Sample1ColRadioButtonStateChanged(evt);
            }
        });
        this.Sample2ColRadioButton.setText("Samples in two columns");
        this.Sample2ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI2PopPropDialog.this.Sample2ColRadioButtonStateChanged(evt);
            }
        });
        this.Trials2TextField.setEnabled(false);
        this.Events1TextField.setEnabled(false);
        this.Events2TextField.setEnabled(false);
        this.jLabel3.setText("Population 1:");
        this.jLabel1.setText("Labels in column:");
        this.jLabel5.setText("Population 1:");
        this.SummaryRadioButton.setText("Summarized sample data");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI2PopPropDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SummaryRadioButton).addComponent(this.Sample1ColRadioButton).addComponent(this.Sample2ColRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5)).addGap(35, 35, 35).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.Events1TextField, GroupLayout.Alignment.LEADING).addComponent(this.Events2TextField, GroupLayout.Alignment.LEADING, -2, 68, -2)).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.Trials2TextField, -1, 78, Short.MAX_VALUE).addComponent(this.Trials1TextField, -2, 66, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ValuesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.LabelsComboBox, 0, 103, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 71, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Pop2ComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.Pop1ComboBox, -2, 89, -2)))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.Events1TextField, this.Events2TextField, this.Trials1TextField, this.Trials2TextField);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.Sample1ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.LabelsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ValuesComboBox, -2, -1, -2)).addGap(23, 23, 23).addComponent(this.Sample2ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.Pop1ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Pop2ComboBox, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8)).addGap(11, 11, 11).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.Events1TextField, -2, -1, -2).addComponent(this.Trials1TextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.Events2TextField, -2, -1, -2).addComponent(this.Trials2TextField, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Confidence"));
        this.jLabel9.setText("Confidence Level:");
        this.jLabel10.setText("0 - 1.00 (e.g. 0.95)");
        this.ConfidenceTextField.setText("0.95");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfidenceTextField, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addContainerGap(37, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.jLabel10)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(99, 99, 99).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        String text;
        String heading;
        int events2;
        int events1;
        int trials2;
        int trials1;
        block23: {
            this.app.compoundEdit = new DialogEdit("CI 2 proportion");
            trials1 = 0;
            trials2 = 0;
            events1 = 0;
            events2 = 0;
            heading = "Confidence Interval - Two population proportions:";
            text = "";
            try {
                confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
                this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
                return;
            }
            heading = heading + "  confidence level = " + confidenceLevel;
            if (this.SummaryRadioButton.isSelected()) {
                try {
                    events1 = Integer.parseInt(this.Events1TextField.getText());
                    events2 = Integer.parseInt(this.Events2TextField.getText());
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter an integer for the number of events.");
                    return;
                }
                try {
                    trials1 = Integer.parseInt(this.Trials1TextField.getText());
                    trials2 = Integer.parseInt(this.Trials2TextField.getText());
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter an integer for the number of trials.");
                    return;
                }
                if (events1 > trials1 || events2 > trials2) {
                    this.app.showErrorDialog("The number of events cannot be greater than the number of trials.");
                    return;
                }
            } else {
                int column;
                String columnLabel;
                Vector Vector1 = null;
                Vector Vector2 = null;
                if (this.Sample1ColRadioButton.isSelected()) {
                    columnLabel = this.LabelsComboBox.getSelectedItem().toString();
                    text = text + "Population labels in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing category labels.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector<Cell> LabelsVector = this.ParentSpreadsheet.getColumn(column);
                    columnLabel = this.ValuesComboBox.getSelectedItem().toString();
                    text = text + "Samples values in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector<Cell> ValuesVector = this.ParentSpreadsheet.getColumn(column);
                    try {
                        Object[] returnValues = HelperFunctions.splitValuesVectorByLabels(LabelsVector, ValuesVector);
                        HelperFunctions.printVector((Vector)returnValues[1]);
                        HelperFunctions.printVector((Vector)returnValues[3]);
                        text = text + "Population 1 = " + returnValues[0] + "<br>";
                        text = text + "Population 2 = " + returnValues[2] + "<br>";
                        Vector1 = (Vector)returnValues[1];
                        Vector2 = (Vector)returnValues[3];
                    }
                    catch (Exception e) {
                        this.app.showErrorDialog(e.getMessage());
                        return;
                    }
                } else if (this.Sample2ColRadioButton.isSelected()) {
                    columnLabel = this.Pop1ComboBox.getSelectedItem().toString();
                    text = text + "Samples of population 1 in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values for the first population.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector1 = this.ParentSpreadsheet.getColumn(column);
                    columnLabel = this.Pop2ComboBox.getSelectedItem().toString();
                    text = text + "Samples of population 2 in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values for the second population.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector2 = this.ParentSpreadsheet.getColumn(column);
                }
                try {
                    Object[] Values1 = HelperFunctions.splitValuesVector(Vector1);
                    String cat11 = (String)Values1[0];
                    String cat12 = (String)Values1[2];
                    Vector vector11 = (Vector)Values1[1];
                    Vector vector12 = (Vector)Values1[3];
                    Object[] Values2 = HelperFunctions.splitValuesVector(Vector2);
                    String cat21 = (String)Values2[0];
                    String cat22 = (String)Values2[2];
                    Vector vector21 = (Vector)Values2[1];
                    Vector vector22 = (Vector)Values2[3];
                    if (cat11.equals(cat21) && cat12.equals(cat22)) {
                        text = text + "Event = " + cat11;
                        events1 = vector11.size();
                        trials1 = vector11.size() + vector12.size();
                        events2 = vector21.size();
                        trials2 = vector21.size() + vector22.size();
                        break block23;
                    }
                    if (cat11.equals(cat22) && cat12.equals(cat21)) {
                        text = text + "Event = " + cat11;
                        events1 = vector11.size();
                        trials1 = vector11.size() + vector12.size();
                        events2 = vector22.size();
                        trials2 = vector21.size() + vector22.size();
                        break block23;
                    }
                    this.app.showErrorDialog("The two categories in the two population samples are not the same.");
                    return;
                }
                catch (Exception e) {
                    this.app.showErrorDialog(e.getMessage());
                    return;
                }
            }
        }
        double p1 = (double)events1 / (double)trials1;
        double p2 = (double)events2 / (double)trials2;
        CI2PopProp CI = new CI2PopProp(confidenceLevel, trials1, trials2, p1, p2);
        text = text + "<br><br><table border='1'>";
        text = text + "<tr><td>&nbsp;</td><td>Number of Events</td><td>Number of trials</td><td>Proportion</td></tr>";
        text = text + "<tr><td>Sample 1</td><td>" + events1 + "</td><td>" + trials1 + "</td><td>" + HelperFunctions.formatFloat(p1, 3) + "</td></tr>";
        text = text + "<tr><td>Sample 2</td><td>" + events2 + "</td><td>" + trials2 + "</td><td>" + HelperFunctions.formatFloat(p2, 3) + "</td></tr>" + "</table><br><br>";
        text = text + "Estimate for difference of population proportion = " + HelperFunctions.formatFloat(p1 - p2, 3) + "<br>";
        text = text + "Margin of error = " + HelperFunctions.formatFloat(((ConfidenceInterval)CI).marginOfError(), 3) + "<br>";
        text = text + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI = " + CI.toString();
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void Sample1ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample1ColRadioButton.isSelected()) {
            this.LabelsComboBox.setEnabled(true);
            this.ValuesComboBox.setEnabled(true);
        } else {
            this.LabelsComboBox.setEnabled(false);
            this.ValuesComboBox.setEnabled(false);
        }
    }

    private void Sample2ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample2ColRadioButton.isSelected()) {
            this.Pop1ComboBox.setEnabled(true);
            this.Pop2ComboBox.setEnabled(true);
        } else {
            this.Pop1ComboBox.setEnabled(false);
            this.Pop2ComboBox.setEnabled(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.Events1TextField.setEnabled(true);
            this.Events2TextField.setEnabled(true);
            this.Trials1TextField.setEnabled(true);
            this.Trials2TextField.setEnabled(true);
        } else {
            this.Events1TextField.setEnabled(false);
            this.Events2TextField.setEnabled(false);
            this.Trials1TextField.setEnabled(false);
            this.Trials2TextField.setEnabled(false);
        }
    }
}

