/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.ci;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.CIOnePopVar;
import org.statcato.utils.HelperFunctions;

public class CI1PopVarDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JTextField ConfidenceTextField;
    private JButton OKButton;
    private JRadioButton SampleRadioButton;
    private JLabel SampleSizeLabel;
    private JTextField SampleSizeTextField;
    private JTextField SampleStdevTextField;
    private JTextField SampleVarTextField;
    private JRadioButton StdevRadioButton;
    private JRadioButton SummaryRadioButton;
    private JRadioButton VarRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public CI1PopVarDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SampleRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.VarRadioButton);
        group2.add(this.StdevRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-ci-1var");
        this.name = "Confidence Interval: One Population Variance";
        this.description = "For computing the confidence intervals for a population variance in one population.";
        this.helpStrings.add("To provde sample data in a column, select the Samples in column: radio button, and select the column name in the given drop-down menu.");
        this.helpStrings.add("If individual sample data is not available, select the Summarized sample data radio button. Enter sample size and either sample variance or sample standard deviation in the provided text boxes.");
        this.helpStrings.add("Enter the confidence level (between 0 and 1) in the Confidence level: text box.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.ColumnComboBox = new JComboBox();
        this.SummaryRadioButton = new JRadioButton();
        this.SampleRadioButton = new JRadioButton();
        this.SampleStdevTextField = new JTextField();
        this.SampleSizeTextField = new JTextField();
        this.SampleSizeLabel = new JLabel();
        this.StdevRadioButton = new JRadioButton();
        this.SampleVarTextField = new JTextField();
        this.VarRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("1-Population Variance");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI1PopVarDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI1PopVarDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.SummaryRadioButton.setText("Summarized sample data:");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopVarDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in column:");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopVarDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.SampleStdevTextField.setEnabled(false);
        this.SampleSizeTextField.setEnabled(false);
        this.SampleSizeLabel.setText("Sample Size:");
        this.SampleSizeLabel.setEnabled(false);
        this.StdevRadioButton.setText("Standard deviation:");
        this.StdevRadioButton.setEnabled(false);
        this.StdevRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopVarDialog.this.StdevRadioButtonStateChanged(evt);
            }
        });
        this.SampleVarTextField.setEnabled(false);
        this.VarRadioButton.setSelected(true);
        this.VarRadioButton.setText("Variance:");
        this.VarRadioButton.setEnabled(false);
        this.VarRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopVarDialog.this.VarRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleSizeLabel).addComponent(this.VarRadioButton).addComponent(this.StdevRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleSizeTextField, -2, 75, -2).addComponent(this.SampleVarTextField, -2, 79, -2).addComponent(this.SampleStdevTextField, -2, 85, -2))).addComponent(this.SampleRadioButton).addComponent(this.SummaryRadioButton).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.ColumnComboBox, -2, 120, -2).addGap(96, 96, 96))).addContainerGap(51, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.SampleSizeTextField, this.SampleStdevTextField, this.SampleVarTextField);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColumnComboBox, -2, -1, -2).addGap(10, 10, 10).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SampleSizeLabel).addComponent(this.SampleSizeTextField, -2, -1, -2)).addGap(14, 14, 14).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.SampleVarTextField, -2, -1, -2).addComponent(this.VarRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SampleStdevTextField, -2, -1, -2).addComponent(this.StdevRadioButton)).addContainerGap(19, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Confidence"));
        this.jLabel1.setText("0 - 1.00 (e.g. 0.95)");
        this.jLabel6.setText("Confidence level:");
        this.ConfidenceTextField.setText("0.95");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfidenceTextField, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addContainerGap(15, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jLabel1)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(44, 44, 44).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addGap(90, 90, 90).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(201, 201, 201).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.SampleSizeLabel.setEnabled(true);
            this.SampleSizeTextField.setEnabled(true);
            this.StdevRadioButton.setEnabled(true);
            this.VarRadioButton.setEnabled(true);
            if (this.StdevRadioButton.isSelected()) {
                this.SampleStdevTextField.setEnabled(true);
            } else {
                this.SampleVarTextField.setEnabled(true);
            }
        } else {
            this.SampleSizeLabel.setEnabled(false);
            this.SampleSizeTextField.setEnabled(false);
            this.SampleStdevTextField.setEnabled(false);
            this.SampleVarTextField.setEnabled(false);
            this.VarRadioButton.setEnabled(false);
            this.StdevRadioButton.setEnabled(false);
        }
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("CI 1 variance");
        int n = 0;
        double s = 0.0;
        double s2 = 0.0;
        Vector<Double> ColumnVector = new Vector();
        String heading = "Confidence Interval - One population variance:";
        String text = "";
        try {
            confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  confidence level = " + confidenceLevel;
        if (this.SampleRadioButton.isSelected()) {
            String columnLabel = this.ColumnComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            text = text + "Input: " + columnLabel + "<br>";
            n = BasicStatistics.Nnonmissing(ColumnVector);
            s2 = BasicStatistics.variance(ColumnVector);
            s = BasicStatistics.stdev(ColumnVector);
        } else {
            try {
                n = Integer.parseInt(this.SampleSizeTextField.getText());
                if (this.VarRadioButton.isSelected()) {
                    s2 = Double.parseDouble(this.SampleVarTextField.getText());
                    s = Math.sqrt(s2);
                } else {
                    s = Double.parseDouble(this.SampleStdevTextField.getText());
                    s2 = s * s;
                }
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            text = text + "Input: Summary data<br>";
        }
        CIOnePopVar CI = new CIOnePopVar(confidenceLevel, n, s2);
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>N</td><td>Variance</td><td>Stdev</td><td>";
        text = text + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI Variance</td><td>" + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI Stdev</td></tr>";
        text = text + "<tr><td>" + n + "</td><td>" + HelperFunctions.formatFloat(s2, 3) + "</td><td>" + HelperFunctions.formatFloat(s, 3) + "</td><td>" + CI.toString() + "</td><td>" + CI.stdevCI() + "</td></tr></table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void VarRadioButtonStateChanged(ChangeEvent evt) {
        if (this.VarRadioButton.isSelected()) {
            this.SampleVarTextField.setEnabled(true);
            this.SampleStdevTextField.setEnabled(false);
        } else {
            this.SampleVarTextField.setEnabled(false);
            this.SampleStdevTextField.setEnabled(true);
        }
    }

    private void StdevRadioButtonStateChanged(ChangeEvent evt) {
        if (this.StdevRadioButton.isSelected()) {
            this.SampleVarTextField.setEnabled(false);
            this.SampleStdevTextField.setEnabled(true);
        } else {
            this.SampleVarTextField.setEnabled(true);
            this.SampleStdevTextField.setEnabled(false);
        }
    }
}

