/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.basicstats;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.HelperFunctions;

public class ColumnStatisticsDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JRadioButton ColumnRadioButton;
    private JTextField ColumnTextField;
    private JComboBox InputVarComboBox;
    private JCheckBox MaxCheckBox;
    private JCheckBox MeanCheckBox;
    private JCheckBox MedianCheckBox;
    private JCheckBox MinCheckBox;
    private JCheckBox NMissingCheckBox;
    private JCheckBox NNonmissingCheckBox;
    private JCheckBox NTotalCheckBox;
    private JButton OKButton;
    private JCheckBox RangeCheckBox;
    private JRadioButton RowRadioButton;
    private JTextField RowTextField;
    private JCheckBox SelectAllCheckBox;
    private JCheckBox StdevCheckBox;
    private JCheckBox SumCheckBox;
    private JCheckBox SumOfSqCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public ColumnStatisticsDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        this.ParentSpreadsheet.populateComboBox(this.InputVarComboBox);
        ButtonGroup group = new ButtonGroup();
        group.add(this.ColumnRadioButton);
        group.add(this.RowRadioButton);
        this.ColumnRadioButton.setSelected(false);
        this.RowRadioButton.setSelected(false);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-basic-column");
        this.name = "Column Statistics";
        this.description = "For computing various statistics on the data within a specific column in a Datasheet. (The computed statistics are displayed in the log window and can be optionally stored in the datasheet.)";
        this.helpStrings.add("Select the input column for which you want to calculate statistics.");
        this.helpStrings.add("[optional] If you want to store the computed statistics in a column of the Datasheet, select the Column radio button and enter the column number or the variable name.");
        this.helpStrings.add("[optional] If you want to store the computed statistics in a row of the datasheet, select the Row radio button and enter the row number.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.InputVarComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.InputVarComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.NNonmissingCheckBox = new JCheckBox();
        this.NMissingCheckBox = new JCheckBox();
        this.SumOfSqCheckBox = new JCheckBox();
        this.NTotalCheckBox = new JCheckBox();
        this.SumCheckBox = new JCheckBox();
        this.MeanCheckBox = new JCheckBox();
        this.RangeCheckBox = new JCheckBox();
        this.MaxCheckBox = new JCheckBox();
        this.MedianCheckBox = new JCheckBox();
        this.MinCheckBox = new JCheckBox();
        this.StdevCheckBox = new JCheckBox();
        this.SelectAllCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.RowTextField = new JTextField();
        this.ColumnRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.ColumnTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.RowRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Column Statistics");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnStatisticsDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnStatisticsDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Input"));
        this.jLabel1.setText("Column Input Variable:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InputVarComboBox, -2, 105, -2).addContainerGap(140, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.InputVarComboBox, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Statistics"));
        this.NNonmissingCheckBox.setText("N nonmissing");
        this.NMissingCheckBox.setText("N missing");
        this.SumOfSqCheckBox.setText("Sum of squares");
        this.NTotalCheckBox.setText("N total");
        this.SumCheckBox.setText("Sum");
        this.MeanCheckBox.setText("Mean");
        this.RangeCheckBox.setText("Range");
        this.MaxCheckBox.setText("Maximum");
        this.MedianCheckBox.setText("Median");
        this.MinCheckBox.setText("Minimum");
        this.StdevCheckBox.setText("Standard deviation");
        this.SelectAllCheckBox.setText("Select All");
        this.SelectAllCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ColumnStatisticsDialog.this.SelectAllCheckBoxStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SumCheckBox).addComponent(this.MeanCheckBox).addComponent(this.StdevCheckBox).addComponent(this.MinCheckBox).addComponent(this.MaxCheckBox)).addGap(57, 57, 57).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.NMissingCheckBox).addComponent(this.NNonmissingCheckBox).addComponent(this.NTotalCheckBox).addComponent(this.SumOfSqCheckBox).addComponent(this.MedianCheckBox))).addComponent(this.RangeCheckBox).addComponent(this.SelectAllCheckBox)).addContainerGap(71, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.MaxCheckBox, this.MeanCheckBox, this.MedianCheckBox, this.MinCheckBox, this.NMissingCheckBox, this.NNonmissingCheckBox, this.NTotalCheckBox, this.RangeCheckBox, this.StdevCheckBox, this.SumCheckBox, this.SumOfSqCheckBox);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.SelectAllCheckBox).addGap(7, 7, 7).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SumCheckBox).addComponent(this.MedianCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MeanCheckBox).addComponent(this.SumOfSqCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.StdevCheckBox).addComponent(this.NTotalCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MinCheckBox).addComponent(this.NNonmissingCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MaxCheckBox).addComponent(this.NMissingCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RangeCheckBox).addContainerGap()));
        jPanel2Layout.linkSize(1, this.MaxCheckBox, this.MeanCheckBox, this.MedianCheckBox, this.MinCheckBox, this.NMissingCheckBox, this.NNonmissingCheckBox, this.NTotalCheckBox, this.RangeCheckBox, this.StdevCheckBox, this.SumCheckBox, this.SumOfSqCheckBox);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel3.setText("Store Results in:");
        this.jLabel6.setText("e.g. C1 or variable name");
        this.ColumnRadioButton.setText("Column");
        this.jLabel4.setText("[optional]");
        this.jLabel5.setText("e.g. 11");
        this.RowRadioButton.setText("Row");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ColumnRadioButton).addComponent(this.RowRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.RowTextField).addComponent(this.ColumnTextField, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.ColumnRadioButton).addComponent(this.ColumnTextField, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RowRadioButton).addComponent(this.RowTextField, -2, -1, -2).addComponent(this.jLabel5)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, Short.MAX_VALUE).addGap(21, 21, 21)).addGroup(layout.createSequentialGroup().addGap(123, 123, 123).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addContainerGap(148, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(21, 21, 21)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        String m;
        int column;
        Vector<Cell> StrColumnVector;
        Object[] conversions;
        String StoreRow;
        this.app.compoundEdit = new DialogEdit("column statistics");
        boolean storeColumnResult = false;
        boolean storeRowResult = false;
        int storeColumnNum = -1;
        int storeRowNum = -1;
        String columnLabel = this.InputVarComboBox.getSelectedItem().toString();
        if (columnLabel.equals("")) {
            this.app.showErrorDialog("Select the input variable.");
            return;
        }
        if (this.ColumnRadioButton.isSelected()) {
            String StoreColumn = this.ColumnTextField.getText();
            if (!StoreColumn.equals("")) {
                storeColumnResult = true;
                storeColumnNum = this.ParentSpreadsheet.getColumnNumber(StoreColumn);
                if (storeColumnNum == -1) {
                    this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the results.");
                    return;
                }
            }
        } else if (this.RowRadioButton.isSelected() && !(StoreRow = this.RowTextField.getText()).equals("")) {
            storeRowResult = true;
            storeRowNum = this.ParentSpreadsheet.getRowNumber(StoreRow);
            if (storeRowNum == -1) {
                this.app.showErrorDialog("Enter a valid row number.");
                return;
            }
        }
        if ((conversions = HelperFunctions.ConvertInputVectorToNumbers(StrColumnVector = this.ParentSpreadsheet.getColumn(column = this.ParentSpreadsheet.parseColumnNumber(columnLabel)))) == null) {
            this.app.showErrorDialog("Invalid input column: all data must be numbers.");
            return;
        }
        Vector ColumnVector = (Vector)conversions[0];
        int missing = (Integer)conversions[1];
        int nonmissing = (Integer)conversions[2];
        int total = missing + nonmissing;
        Vector<String> ResultVector = new Vector<String>(0);
        this.app.addLogHeading("Column Statistics");
        if (this.MeanCheckBox.isSelected()) {
            Double mean = BasicStatistics.mean(ColumnVector);
            m = mean == null ? "*" : HelperFunctions.formatFloat((double)mean);
            ResultVector.addElement(m);
            this.app.addLogHeading("Mean of " + columnLabel);
            this.app.addLogText("Mean of " + columnLabel + " = " + m);
        }
        if (this.SumCheckBox.isSelected()) {
            double sum = BasicStatistics.sum(ColumnVector);
            ResultVector.addElement(sum + "");
            this.app.addLogHeading("Sum of " + columnLabel);
            this.app.addLogText("Sum of " + columnLabel + " = " + HelperFunctions.formatFloat(sum));
        }
        if (this.StdevCheckBox.isSelected()) {
            Double stdev = BasicStatistics.stdev(ColumnVector);
            String s = stdev == null ? "*" : HelperFunctions.formatFloat((double)stdev);
            ResultVector.addElement(s);
            this.app.addLogHeading("<b>Standard Deviation of " + columnLabel);
            this.app.addLogText("Standard deviation of " + columnLabel + " = " + s);
        }
        if (this.MaxCheckBox.isSelected()) {
            Double max = BasicStatistics.max(ColumnVector);
            m = max == null ? "*" : HelperFunctions.formatFloat((double)max);
            ResultVector.addElement(m);
            this.app.addLogHeading("<b>Maximum of " + columnLabel);
            this.app.addLogText("Maximum of " + columnLabel + " = " + m);
        }
        if (this.MinCheckBox.isSelected()) {
            Double min = BasicStatistics.min(ColumnVector);
            m = min == null ? "*" : HelperFunctions.formatFloat((double)min);
            ResultVector.addElement(m);
            this.app.addLogHeading("Minimum of " + columnLabel);
            this.app.addLogText("Minimum of " + columnLabel + " = " + m);
        }
        if (this.RangeCheckBox.isSelected()) {
            Double range = BasicStatistics.range(ColumnVector);
            String r = range == null ? "*" : HelperFunctions.formatFloat((double)range);
            ResultVector.addElement(r);
            this.app.addLogHeading("Range of " + columnLabel);
            this.app.addLogText("Range of " + columnLabel + " = " + r);
        }
        if (this.MedianCheckBox.isSelected()) {
            Double median = BasicStatistics.median(ColumnVector);
            m = median == null ? "*" : HelperFunctions.formatFloat((double)median);
            ResultVector.addElement(m);
            this.app.addLogHeading("Median of " + columnLabel);
            this.app.addLogText("Median of " + columnLabel + " = " + m);
        }
        if (this.SumOfSqCheckBox.isSelected()) {
            double sum = BasicStatistics.sumOfSquares(ColumnVector);
            ResultVector.addElement(sum + "");
            this.app.addLogHeading("Sum of Squares of " + columnLabel);
            this.app.addLogText("Sum of squares of " + columnLabel + " = " + sum);
        }
        if (this.NTotalCheckBox.isSelected()) {
            ResultVector.addElement(total + "");
            this.app.addLogHeading("Total Number of Observations in " + columnLabel);
            this.app.addLogText("Total number of observations in " + columnLabel + " = " + total);
        }
        if (this.NNonmissingCheckBox.isSelected()) {
            ResultVector.addElement(nonmissing + "");
            this.app.addLogHeading("Number of Nonmissings in " + columnLabel);
            this.app.addLogText("Number of nonmissings in " + columnLabel + " = " + nonmissing);
        }
        if (this.NMissingCheckBox.isSelected()) {
            ResultVector.addElement(missing + "");
            this.app.addLogHeading("Number of Missings in " + columnLabel);
            this.app.addLogText("Number of missings in " + columnLabel + " = " + missing);
        }
        if (storeColumnResult) {
            this.ParentSpreadsheet.setColumn(storeColumnNum, ResultVector);
        } else if (storeRowResult) {
            this.ParentSpreadsheet.setRow(storeRowNum, ResultVector);
        }
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void SelectAllCheckBoxStateChanged(ChangeEvent evt) {
        if (this.SelectAllCheckBox.isSelected()) {
            this.SumCheckBox.setSelected(true);
            this.MeanCheckBox.setSelected(true);
            this.StdevCheckBox.setSelected(true);
            this.MinCheckBox.setSelected(true);
            this.MaxCheckBox.setSelected(true);
            this.RangeCheckBox.setSelected(true);
            this.MedianCheckBox.setSelected(true);
            this.SumOfSqCheckBox.setSelected(true);
            this.NTotalCheckBox.setSelected(true);
            this.NNonmissingCheckBox.setSelected(true);
            this.NMissingCheckBox.setSelected(true);
        } else {
            this.SumCheckBox.setSelected(false);
            this.MeanCheckBox.setSelected(false);
            this.StdevCheckBox.setSelected(false);
            this.MinCheckBox.setSelected(false);
            this.MaxCheckBox.setSelected(false);
            this.RangeCheckBox.setSelected(false);
            this.MedianCheckBox.setSelected(false);
            this.SumOfSqCheckBox.setSelected(false);
            this.NTotalCheckBox.setSelected(false);
            this.NNonmissingCheckBox.setSelected(false);
            this.NMissingCheckBox.setSelected(false);
        }
    }
}

