/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.anova;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.TwoWayANOVA;
import org.statcato.utils.CategoryCounter;
import org.statcato.utils.HelperFunctions;

public class TwoWayANOVADialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox ColComboBox;
    private JButton OKButton;
    private JComboBox ResponseComboBox;
    private JComboBox RowComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public TwoWayANOVADialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.OKButton);
        this.ParentSpreadsheet.populateComboBox(this.ResponseComboBox);
        this.ParentSpreadsheet.populateComboBox(this.RowComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ColComboBox);
        this.setHelpFile("stat-anova2");
        this.name = "Two-Way ANOVA";
        this.description = "For performing two-way ANOVA.";
        this.helpStrings.add("In the Response drop-down menu, select the column contains the observations.");
        this.helpStrings.add("Select the column containing the row factor labels corresponding to the observations.");
        this.helpStrings.add("Select the column containing the column factor labels corresponding to the observations.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ResponseComboBox);
        this.updateComboBox(this.RowComboBox);
        this.updateComboBox(this.ColComboBox);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.ResponseComboBox = new JComboBox();
        this.RowComboBox = new JComboBox();
        this.ColComboBox = new JComboBox();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Two-Way ANOVA");
        this.jLabel1.setText("Response:");
        this.jLabel2.setText("Row Factor:");
        this.jLabel3.setText("Column Factor:");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TwoWayANOVADialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TwoWayANOVADialog.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.OKButton, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addGap(30, 30, 30)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ColComboBox, 0, 122, Short.MAX_VALUE).addComponent(this.ResponseComboBox, 0, 122, Short.MAX_VALUE).addComponent(this.RowComboBox, 0, 122, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.ResponseComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.RowComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.ColComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(26, 26, 26)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("two-way ANOVA");
        String heading = "Two-way ANOVA";
        String text = "";
        String columnLabel = this.ResponseComboBox.getSelectedItem().toString();
        text = text + "responses in " + columnLabel;
        if (columnLabel.equals("")) {
            this.app.showErrorDialog("Select the input variable.");
            return;
        }
        int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
        Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
        Vector<Double> ResponseVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector = HelperFunctions.removeEndingEmptyCells(StrColumnVector));
        if (ResponseVector == null) {
            this.app.showErrorDialog("Invalid response column " + columnLabel + ": all data must be numbers.");
            return;
        }
        String rowLabel = this.RowComboBox.getSelectedItem().toString();
        text = text + ", row factor " + rowLabel;
        if (rowLabel.equals("")) {
            this.app.showErrorDialog("Select the row factor variable.");
            return;
        }
        int rowColumn = this.ParentSpreadsheet.parseColumnNumber(rowLabel);
        Vector<Cell> RowVector = this.ParentSpreadsheet.getColumn(rowColumn);
        if ((RowVector = HelperFunctions.removeEndingEmptyCells(RowVector)).size() < ResponseVector.size()) {
            this.app.showErrorDialog("missing row factor label(s)");
            return;
        }
        String colLabel = this.ColComboBox.getSelectedItem().toString();
        text = text + ", column factor " + colLabel + "<br>";
        if (colLabel.equals("")) {
            this.app.showErrorDialog("Select the column factor variable.");
            return;
        }
        int colColumn = this.ParentSpreadsheet.parseColumnNumber(colLabel);
        Vector<Cell> ColVector = this.ParentSpreadsheet.getColumn(colColumn);
        if ((ColVector = HelperFunctions.removeEndingEmptyCells(ColVector)).size() < ResponseVector.size()) {
            this.app.showErrorDialog("missing column factor label(s)");
            return;
        }
        CategoryCounter rowCategoryCounter = new CategoryCounter();
        for (int i = 0; i < RowVector.size(); ++i) {
            rowCategoryCounter.addCategory(RowVector.elementAt(i).getContents());
        }
        CategoryCounter colCategoryCounter = new CategoryCounter();
        for (int i = 0; i < ColVector.size(); ++i) {
            colCategoryCounter.addCategory(ColVector.elementAt(i).getContents());
        }
        TwoWayANOVA anova = new TwoWayANOVA(rowCategoryCounter.getSize(), colCategoryCounter.getSize());
        for (int i = 0; i < ResponseVector.size(); ++i) {
            Double value = ResponseVector.elementAt(i);
            if (value == null) continue;
            double observation = value;
            Cell row = RowVector.elementAt(i);
            Cell col = ColVector.elementAt(i);
            if (row == null || col == null || row.getContents().equals("") || col.getContents().equals("")) {
                this.app.showErrorDialog("Missing row or column label for data " + observation);
                return;
            }
            anova.addObservation(rowCategoryCounter.getIndex(row.getContents()), colCategoryCounter.getIndex(col.getContents()), observation);
        }
        if (!anova.isValidData()) {
            this.app.showErrorDialog("Invalid data for two-way ANOVA--all treatment group must be of the same size.");
            return;
        }
        text = text + anova;
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

