/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.graph;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.StemAndLeafPlot;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.HelperFunctions;
import org.statcato.utils.NumDataset;

public class StemAndLeafPlotDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JCheckBox DisplayCheckBox;
    private JComboBox GroupByComboBox;
    private JList InputVarList;
    private JTextField LeafUnitTextField;
    private JButton OKButton;
    private JCheckBox OutlierCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public StemAndLeafPlotDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        this.ParentSpreadsheet.populateColumnsList(this.InputVarList);
        this.ParentSpreadsheet.populateComboBox(this.GroupByComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("graph-stemplot");
        this.name = "Stem-and-Leaf Plot";
        this.description = "For creating stem-and-leaf-plots, which divide each data value into a stem and a leaf and show the leaves corresponding to each distinct stem in the data set in a tabular fashion.";
        this.helpStrings.add("Select the columns containing data values. Control-click to select multiple variables. ");
        this.helpStrings.add("<html>Enter the leaf unit (must be equal to 10<sup>x</sup>, where x is an integer).</html>");
        this.helpStrings.add("Select the Exclude outliers checkbox to exclude the outliers from the plot.");
        this.helpStrings.add("Select the Display stems that have no leaves checkbox to display the stems with no leaves.");
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.GroupByComboBox);
        this.updateColumnsList(this.InputVarList);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.OutlierCheckBox = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.LeafUnitTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.DisplayCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.InputVarList = new JList();
        this.GroupByComboBox = new JComboBox();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Stem-and-Leaf Plot");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.OutlierCheckBox.setSelected(true);
        this.OutlierCheckBox.setText("Exclude outliers");
        this.jLabel3.setText("Leaf unit:");
        this.jLabel5.setText("<html>e.g. With a leaf unit of 1, the leaf of 23 is 3.<br>\nWith a leaf unit of 0.1, the leaf of 5.6 is 6.</html>");
        this.jLabel6.setText("[automatic if left blank]");
        this.DisplayCheckBox.setSelected(true);
        this.DisplayCheckBox.setText("Display stems that have no leaves");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.jLabel5, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(22, 22, 22).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.OutlierCheckBox).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.LeafUnitTextField, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addComponent(this.DisplayCheckBox)))).addContainerGap(25, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.LeafUnitTextField, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, -1, -2).addGap(18, 18, 18).addComponent(this.OutlierCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DisplayCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graph Variables"));
        this.jLabel4.setText("Grouped By Categories in: [optional]");
        this.jLabel2.setText("Ctrl-click to select multiple variables");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Graph Variables:");
        this.jScrollPane1.setViewportView(this.InputVarList);
        this.GroupByComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StemAndLeafPlotDialog.this.GroupByComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.GroupByComboBox, -2, 212, -2)).addComponent(this.jScrollPane1, -2, 205, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 118, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.GroupByComboBox, -2, -1, -2).addContainerGap()));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StemAndLeafPlotDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StemAndLeafPlotDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(83, 83, 83).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(10, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void GroupByComboBoxItemStateChanged(ItemEvent evt) {
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("stem-and-leaf plot");
        Object[] SelectedColumns = this.InputVarList.getSelectedValues();
        int[] columnNumbers = this.ParentSpreadsheet.convertColumnLabelsToNumbers(SelectedColumns);
        if (columnNumbers.length == 0) {
            this.app.showErrorDialog("Select at least one input variable.");
            return;
        }
        String text = "";
        String byVarLabel = this.GroupByComboBox.getSelectedItem().toString();
        int byVarColNum = -1;
        Vector<Cell> byVarColVector = null;
        boolean hasByVar = false;
        NumDataset dataset = new NumDataset();
        if (!byVarLabel.equals("")) {
            text = text + "Group By variable: " + byVarLabel + "<br>";
            hasByVar = true;
            byVarColNum = this.ParentSpreadsheet.parseColumnNumber(byVarLabel);
            byVarColVector = this.ParentSpreadsheet.getColumn(byVarColNum);
            byVarColVector = HelperFunctions.removeNullCells(byVarColVector);
        }
        text = text + "Graph variables: ";
        for (int i = 0; i < columnNumbers.length; ++i) {
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(columnNumbers[i]);
            String columnLabel = (String)SelectedColumns[i];
            text = text + columnLabel + " ";
            Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if ((ColumnVector = HelperFunctions.removeNullValues(ColumnVector)) == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            if (hasByVar) {
                if (ColumnVector.size() != byVarColVector.size()) {
                    this.app.showErrorDialog("There must be one category label for each data value.");
                    return;
                }
                dataset.addDataVectorWithByVarLabels(ColumnVector, byVarColVector);
                continue;
            }
            dataset.add(ColumnVector, columnLabel);
        }
        double leafUnit = -1.0;
        if (!this.LeafUnitTextField.getText().equals("")) {
            try {
                double u = Double.parseDouble(this.LeafUnitTextField.getText());
                if (u <= 0.0 || Math.log10(u) - Math.floor(Math.log10(u)) != 0.0) {
                    throw new NumberFormatException();
                }
                leafUnit = u;
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid number for the leaf unit.");
                return;
            }
        }
        text = text + "<br>";
        Vector<Vector<Double>> data = dataset.getValues();
        Vector<String> labels = dataset.getLabels();
        for (int i = 0; i < data.size(); ++i) {
            text = text + "<br>Graph Variable: " + labels.elementAt(i) + "<br>";
            if (this.OutlierCheckBox.isSelected()) {
                Vector<Double> outliers = BasicStatistics.removeOutliers(data.elementAt(i));
                text = text + "Outliers: " + HelperFunctions.printDoubleVectorToString(outliers) + "<br>";
            }
            StemAndLeafPlot plot = new StemAndLeafPlot(data.elementAt(i), leafUnit);
            plot.displayEmptyStem = this.DisplayCheckBox.isSelected();
            text = text + "Leaf units: " + plot.getLeafUnits() + "<br>";
            text = text + plot;
        }
        this.app.addLogParagraph("Stem-and-Leaf Plot", text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

