/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.graph;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jfree.chart.JFreeChart;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.NormalityTest;
import org.statcato.utils.HelperFunctions;

public class NormalQuantilePlotDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox ColComboBox;
    private JRadioButton DataRadioButton;
    private JCheckBox LineCheckBox;
    private JButton OKButton;
    private JComboBox SigComboBox;
    private JTextField TitleTextField;
    private JRadioButton ZscoresRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField xTextField;
    private JTextField yTextField;

    public NormalQuantilePlotDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("graph-nqp");
        this.name = "Normal Quantile Plot";
        this.description = "For creating normal quantile (probability) plots.";
        this.helpStrings.add("Select the column containing the data values.");
        this.helpStrings.add("Enter the plot title and labels for the x and y axes in the corresponding text fields.");
        this.helpStrings.add("Select the Show regression line check box to show a best-fit line to the points on the plot.");
        this.helpStrings.add("Select the significance level used in the Ryan-Joiner normality test.");
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColComboBox);
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.ColComboBox);
        ButtonGroup group = new ButtonGroup();
        group.add(this.DataRadioButton);
        group.add(this.ZscoresRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ColComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.yTextField = new JTextField();
        this.TitleTextField = new JTextField();
        this.xTextField = new JTextField();
        this.LineCheckBox = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.DataRadioButton = new JRadioButton();
        this.ZscoresRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.SigComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Normal Quantile Plot");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalQuantilePlotDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalQuantilePlotDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graph Variable"));
        this.ColComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NormalQuantilePlotDialog.this.ColComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("Select the column for which the plot will be created:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.ColComboBox, -2, 196, -2)).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColComboBox, -2, -1, -2).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jLabel2.setText("Plot Title:");
        this.TitleTextField.setText("Normal Quantile Plot");
        this.LineCheckBox.setSelected(true);
        this.LineCheckBox.setText("Show regression line");
        this.jLabel4.setText("Y-axis Label:");
        this.jLabel3.setText("X-axis Label:");
        this.jLabel5.setText("X-axis values represent:");
        this.DataRadioButton.setSelected(true);
        this.DataRadioButton.setText("data");
        this.ZscoresRadioButton.setText("z-scores");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.TitleTextField, -2, 231, -2).addComponent(this.xTextField, -2, 253, -2).addComponent(this.yTextField, -2, 253, -2))).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LineCheckBox).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.DataRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ZscoresRadioButton))).addContainerGap(28, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.TitleTextField, this.xTextField, this.yTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.xTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.yTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.LineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ZscoresRadioButton).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.DataRadioButton))).addContainerGap(30, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Normality Test (Ryan-Joiner)"));
        this.SigComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0.01", "0.05", "0.10"}));
        this.jLabel6.setText("Significance Level:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.SigComboBox, -2, 114, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigComboBox, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(100, 100, 100).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("normal quantile plot");
        String heading = "Normal Quartile Plot";
        if (this.ColComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select the column containing the values to be plotted.");
            return;
        }
        String yCol = (String)this.ColComboBox.getSelectedItem();
        int yColumn = this.ParentSpreadsheet.parseColumnNumber(yCol);
        Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(yColumn);
        Vector<Double> YColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
        if (YColumnVector == null) {
            this.app.showErrorDialog("Invalid input column " + yCol + ": all data must be numbers.");
            return;
        }
        YColumnVector = HelperFunctions.removeNullValues(YColumnVector);
        String text = "Input variable: " + yCol + "<br>";
        double significance = Double.parseDouble((String)this.SigComboBox.getSelectedItem());
        NormalityTest normalityTest = new NormalityTest(YColumnVector, significance);
        text = text + normalityTest;
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.CreatePlot(YColumnVector);
        this.setVisible(false);
    }

    private void CreatePlot(Vector<Double> YColumnVector) {
        JFreeChart plot = GraphFactory.createNormalQuantilePlot(YColumnVector, this.TitleTextField.getText(), this.xTextField.getText(), this.yTextField.getText(), this.DataRadioButton.isSelected(), this.LineCheckBox.isSelected());
        StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), plot, this.app);
        frame.pack();
        frame.setVisible(true);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ColComboBoxItemStateChanged(ItemEvent evt) {
        if (this.ColComboBox.getSelectedIndex() != 0 && this.xTextField.getText().equals("")) {
            String yCol = (String)this.ColComboBox.getSelectedItem();
            this.xTextField.setText(yCol);
        }
    }
}

