/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.file;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import org.jfree.report.ElementAlignment;
import org.jfree.report.JFreeReport;
import org.jfree.report.SimplePageDefinition;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextFieldElementFactory;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Spreadsheet;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.JFreeReportPrintUtil;

public class PrintDatasheetDialog
extends StatcatoDialog {
    int[] selectedColumns;
    int[] selectedRows;
    private JRadioButton AllRadioButton;
    private JButton CancelButton;
    private JTextField ColEndTextField;
    private JTextField ColStartTextField;
    private JTextField FooterTextField;
    private JTextField HeaderTextField;
    private JButton PrintButton;
    private JRadioButton RowColRadioButton;
    private JLabel RowEndLabel;
    private JTextField RowEndTextField;
    private JTextField RowStartTextField;
    private JRadioButton SelectionRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;

    public PrintDatasheetDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group = new ButtonGroup();
        group.add(this.AllRadioButton);
        group.add(this.SelectionRadioButton);
        group.add(this.RowColRadioButton);
        this.RowStartTextField.setEnabled(false);
        this.RowEndTextField.setEnabled(false);
        this.ColStartTextField.setEnabled(false);
        this.ColEndTextField.setEnabled(false);
        RadioAction listener = new RadioAction();
        this.RowColRadioButton.addItemListener(listener);
        this.SelectionRadioButton.addItemListener(listener);
        this.AllRadioButton.addItemListener(listener);
        this.selectedColumns = this.ParentSpreadsheet.getSelectedColumns();
        this.selectedRows = this.ParentSpreadsheet.getSelectedRows();
        if (this.selectedColumns.length != 0 && this.selectedRows.length != 0) {
            this.SelectionRadioButton.setEnabled(true);
        } else {
            this.SelectionRadioButton.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(this.PrintButton);
        this.setHelpFile("file-menu");
        this.name = "Print Datasheet";
        this.description = "For printing the current datasheet.";
        this.helpStrings.add("Specify the print area, header, and footer.");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.HeaderTextField = new JTextField();
        this.FooterTextField = new JTextField();
        this.AllRadioButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.SelectionRadioButton = new JRadioButton();
        this.RowColRadioButton = new JRadioButton();
        this.RowStartTextField = new JTextField();
        this.RowEndLabel = new JLabel();
        this.RowEndTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.ColStartTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.ColEndTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.CancelButton = new JButton();
        this.PrintButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Print Worksheet");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Print Options"));
        this.HeaderTextField.setText("Worksheet");
        this.AllRadioButton.setSelected(true);
        this.AllRadioButton.setText("All");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Print Area");
        this.SelectionRadioButton.setText("Selection");
        this.RowColRadioButton.setText("The following rows and columns:");
        this.RowEndLabel.setText("to");
        this.jLabel3.setText("Row");
        this.jLabel4.setText("Column");
        this.jLabel5.setText("to");
        this.jLabel2.setText("Header:");
        this.jLabel6.setText("Footer:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ColStartTextField, -2, 46, -2).addComponent(this.RowStartTextField, -2, 47, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.RowEndLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.RowEndTextField)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ColEndTextField, -2, -1, -2)))).addComponent(this.RowColRadioButton, GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.AllRadioButton, GroupLayout.Alignment.LEADING).addComponent(this.SelectionRadioButton, GroupLayout.Alignment.LEADING)).addGap(216, 216, 216)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.HeaderTextField, -1, 128, Short.MAX_VALUE).addComponent(this.FooterTextField))))));
        jPanel1Layout.linkSize(0, this.ColEndTextField, this.ColStartTextField, this.RowEndTextField, this.RowStartTextField);
        jPanel1Layout.linkSize(0, this.FooterTextField, this.HeaderTextField);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AllRadioButton).addGap(9, 9, 9).addComponent(this.SelectionRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RowColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.RowStartTextField, -2, -1, -2).addComponent(this.RowEndLabel).addComponent(this.RowEndTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.ColStartTextField, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.ColEndTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.HeaderTextField, -2, 22, -2).addComponent(this.jLabel2)).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.FooterTextField, -2, -1, -2).addComponent(this.jLabel6)).addContainerGap(-1, Short.MAX_VALUE)));
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDatasheetDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.PrintButton.setText("Print");
        this.PrintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDatasheetDialog.this.PrintButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 319, -2)).addGroup(layout.createSequentialGroup().addGap(82, 82, 82).addComponent(this.PrintButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.PrintButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PrintButton).addComponent(this.CancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void PrintButtonActionPerformed(ActionEvent evt) {
        String header = this.HeaderTextField.getText();
        String footer = this.FooterTextField.getText();
        Spreadsheet PrintArea = null;
        int minRow = -1;
        int minCol = -1;
        int maxRow = -1;
        int maxCol = -1;
        if (this.AllRadioButton.isSelected()) {
            int lastrow = this.ParentSpreadsheet.getLastNonEmptyRow();
            int lastcol = this.ParentSpreadsheet.getLastNonEmptyColumn();
            PrintArea = this.ParentSpreadsheet.getSubTable(0, 0, lastrow, lastcol);
        } else if (this.SelectionRadioButton.isSelected()) {
            minRow = BasicStatistics.min(this.selectedRows);
            minCol = BasicStatistics.min(this.selectedColumns);
            maxRow = BasicStatistics.max(this.selectedRows);
            maxCol = BasicStatistics.max(this.selectedColumns);
            PrintArea = this.ParentSpreadsheet.getSubTable(minRow, minCol, maxRow, maxCol);
        } else if (this.RowColRadioButton.isSelected()) {
            try {
                minRow = Integer.parseInt(this.RowStartTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid starting row number.");
                return;
            }
            try {
                maxRow = Integer.parseInt(this.RowEndTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid ending row number.");
                return;
            }
            try {
                minCol = Integer.parseInt(this.ColStartTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid starting column number.");
                return;
            }
            try {
                maxCol = Integer.parseInt(this.ColEndTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid ending column number.");
                return;
            }
            if (minRow > maxRow) {
                this.app.showErrorDialog("Starting row number must not be greater than the ending row numbers.");
                return;
            }
            if (minCol > maxCol) {
                this.app.showErrorDialog("Starting column number must not be greater than the ending column numbers");
                return;
            }
            if (minRow > this.ParentSpreadsheet.getRowCount() || maxRow > this.ParentSpreadsheet.getRowCount()) {
                this.app.showErrorDialog("Enter valid row numbers");
                return;
            }
            if (minCol > this.ParentSpreadsheet.getColumnCount() || maxCol > this.ParentSpreadsheet.getColumnCount()) {
                this.app.showErrorDialog("Enter valid column numbers");
            }
            PrintArea = this.ParentSpreadsheet.getSubTable(minRow, minCol - 1, maxRow, maxCol - 1);
        }
        JFreeReportPrintUtil.PrintControlTable(PrintArea, "", "", header, footer);
        this.dispose();
    }

    private JFreeReport createReportDefinition(TableModel model) {
        JFreeReport report = new JFreeReport();
        report.setName("Datasheet");
        TextFieldElementFactory factory = new TextFieldElementFactory();
        int numRows = model.getRowCount();
        int numCols = model.getColumnCount();
        PageFormat ThisPageformat = new PageFormat();
        report.setPageDefinition(new SimplePageDefinition(ThisPageformat, (int)Math.ceil(numCols / 10), 1));
        for (int i = 0; i < numCols; ++i) {
            TextElement t = TextFieldElementFactory.createStringElement("T" + i, new Rectangle2D.Double(50 * i, 0.0, 50.0, 20.0), Color.black, ElementAlignment.LEFT, ElementAlignment.MIDDLE, null, "-", model.getColumnName(i));
            report.getItemBand().addElement(t);
        }
        return report;
    }

    class RadioAction
    implements ItemListener {
        RadioAction() {
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (PrintDatasheetDialog.this.RowColRadioButton.isSelected()) {
                PrintDatasheetDialog.this.RowStartTextField.setEnabled(true);
                PrintDatasheetDialog.this.RowEndTextField.setEnabled(true);
                PrintDatasheetDialog.this.ColStartTextField.setEnabled(true);
                PrintDatasheetDialog.this.ColEndTextField.setEnabled(true);
            } else {
                PrintDatasheetDialog.this.RowStartTextField.setEnabled(false);
                PrintDatasheetDialog.this.RowEndTextField.setEnabled(false);
                PrintDatasheetDialog.this.ColStartTextField.setEnabled(false);
                PrintDatasheetDialog.this.ColEndTextField.setEnabled(false);
            }
        }
    }
}

