/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.file;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;

public class OptionsDialog
extends StatcatoDialog {
    private JCheckBox DelCheckBox;
    private JTextField IntTextField;
    private JButton OKButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;

    public OptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("file-options");
        this.name = "Options";
        this.description = "For changing various settings of Statcato.";
        this.helpStrings.add("Statcato automatically saves a back up copy of the current project file at one minute after the start of the program execution.");
        this.helpStrings.add("The back up file is saved in the same directory as the program files and is named in the form ~statcato.tmp.mmddyyyyhhmmss.stc, where mmddyyyyhhmmss is a timestamp of when the file is created.");
        this.helpStrings.add("Enter the interval in which a back up file of the current project file is saved. The interval must be a positive integer and is measured in minutes.");
        this.helpStrings.add("Select the Delete backup file upon exit checkbox if you want the backup file to be deleted when you exit the application.");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.IntTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.DelCheckBox = new JCheckBox();
        this.OKButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Options");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Auto Save"));
        this.jLabel1.setText("Auto save a backup copy of project every");
        this.IntTextField.setHorizontalAlignment(4);
        this.IntTextField.setText("5");
        this.jLabel2.setText("minutes.");
        this.DelCheckBox.setSelected(true);
        this.DelCheckBox.setText("Delete backup file upon exit.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DelCheckBox).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.IntTextField, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2))).addContainerGap(19, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.IntTextField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.DelCheckBox).addContainerGap(16, Short.MAX_VALUE)));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.OKButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(170, 170, 170).addComponent(this.OKButton))).addContainerGap(26, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.OKButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        try {
            int saveInterval = Integer.parseInt(this.IntTextField.getText());
            if (saveInterval <= 0) {
                throw new NumberFormatException("positive integer required");
            }
            this.app.project.setAutoSaveInterval(saveInterval * 60);
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a positive integer for the auto save interval.");
            return;
        }
        this.app.project.setDeleteAutoSaveFile(this.DelCheckBox.isSelected());
        this.setVisible(false);
    }
}

