/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.file;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.file.DownloadFile;
import org.statcato.file.FileChooserUtils;
import org.statcato.utils.HelperFunctions;

public class LoadDatasetDialog
extends StatcatoDialog {
    private static int EXCEL = 0;
    private static int CSV = 1;
    private static int TXT = 2;
    private static String[] extensions = new String[]{"xls", "csv", "txt"};
    private static String[] titles = new String[]{"", "Beam Deflections", "Caffeine Consumption at Starbucks vs. Time of Day", "Cuckoo Eggs & Foster Parents", "Eye Gain Ratio Measurements for Schizophrenic Patients", "GPA vs. Environmental Concern", "Homework Scores vs. Overall Course Percentages for Statistics Students", "Lifetimes of Aluminum Strips Under Alternating Stress", "Machine # vs. Part Diameter", "Mass vs. Spring Frequency", "Pain Reliever vs. Body Temperature", "Pendulum Length vs. Period", "Precipitation vs. Lake Level", "Rainfall Totals for Seeded and Unseeded Clouds", "Sample Size vs. Error", "Smoking vs. GPA", "Time vs. H1N1 Cases", "Time vs. Ibuprofen Qty.", "Time vs. Success Rate", "Tips vs. Gender", "Women in Math Courses"};
    static String[] paths = new String[]{"", "BeamDeflections.xls", "CaffeineConsumptionVsTime.xls", "CuckooEggVsFosterParents.xls", "SchizEye.xls", "GPAVsEnvConcern.xls", "HWvsOverall.xls", "AlumLife.xls", "MachineVsPartDiameter.xls", "MassVsSpringFreq.xls", "PainRelieverVsBodyTemp.xls", "PendulumLengthVsTime.xls", "PrecipitationVsLakeLevel.xls", "Rainfall.xls", "SampleSizeVsError.xls", "SmokingVsGPA.xls", "TimeVsH1N1.xls", "TimeVsIbuprofen.xls", "TimeVsSuccessRate.xls", "TipsVsGender.xls", "WomenInMath.xls"};
    private JButton CancelButton;
    private JButton OKButton;
    private JComboBox SampleComboBox;
    private JRadioButton SampleRadioButton;
    private JComboBox TypeComboBox;
    private JTextField URLTextField;
    private JRadioButton WebRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JSeparator jSeparator1;

    public LoadDatasetDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group = new ButtonGroup();
        group.add(this.SampleRadioButton);
        group.add(this.WebRadioButton);
        this.loadSampleComboBox();
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("file-menu");
        this.name = "Load Dataset";
        this.description = "For loading a built-in dataset or a dataset available on the web.";
        this.helpStrings.add("Select a built-in sample dataset or enter the url of a dataset available on the web.");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.SampleComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.URLTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.TypeComboBox = new JComboBox();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.SampleRadioButton = new JRadioButton();
        this.WebRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Load Dataset");
        this.jLabel1.setFont(new Font("Tahoma", 1, 12));
        this.jLabel1.setText("Built-in Datasets");
        this.jLabel2.setFont(new Font("Tahoma", 1, 12));
        this.jLabel2.setText("Online Datasets");
        this.URLTextField.setEnabled(false);
        this.jLabel5.setText("Select dataset file type:");
        this.TypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Excel (.xls)", "Comma-separated values (.csv)", "Tab-delimited text (.txt)"}));
        this.TypeComboBox.setEnabled(false);
        this.OKButton.setText("Load Dataset");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadDatasetDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadDatasetDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Choose a sample dataset:");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LoadDatasetDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.WebRadioButton.setText("Enter web address of the dataset (e.g. http://www.statcato.org/labs/data/ages.csv):");
        this.WebRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LoadDatasetDialog.this.WebRadioButtonStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jSeparator1, -2, 412, -2).addComponent(this.jLabel2))).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.WebRadioButton).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.TypeComboBox, -2, 162, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.SampleComboBox, -2, 462, -2).addComponent(this.URLTextField, -2, 462, -2)))))).addGroup(layout.createSequentialGroup().addGap(189, 189, 189).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.SampleRadioButton))).addContainerGap(24, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.SampleRadioButton).addGap(7, 7, 7).addComponent(this.SampleComboBox, -2, -1, -2).addGap(28, 28, 28).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.WebRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.URLTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.TypeComboBox, -2, -1, -2).addGap(33, 33, 33).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void OKButtonActionPerformed(ActionEvent evt) {
        int index = this.SampleComboBox.getSelectedIndex();
        File currentDir = new File(".");
        String currentDirStr = "";
        try {
            String filename;
            DownloadFile d;
            String fileType;
            currentDirStr = currentDir.getCanonicalPath();
            File file = null;
            if (this.SampleRadioButton.isSelected()) {
                if (index == 0) {
                    this.app.showErrorDialog("Select a built-in sample dataset");
                    return;
                }
                String path = "dataset/" + paths[index];
                URL URL2 = this.getClass().getResource(path);
                fileType = FileChooserUtils.getExtension(URL2.toString());
                if (URL2 == null) {
                    this.app.showErrorDialog("Cannot read file");
                    return;
                }
                d = new DownloadFile(URL2.toString());
                filename = d.download();
                if (filename == null) {
                    this.app.showErrorDialog("Error downloading file! Please check URL.");
                    return;
                }
                file = new File(filename);
            } else {
                String URL3 = this.URLTextField.getText();
                if (URL3.equals("")) {
                    this.app.showErrorDialog("Enter the web address of the dataset.");
                    return;
                }
                int type = this.TypeComboBox.getSelectedIndex();
                if (!FileChooserUtils.getExtension(URL3).equals(extensions[type])) {
                    this.app.showErrorDialog("URL is not compatible with the expected file type.");
                    return;
                }
                d = new DownloadFile(URL3);
                filename = d.download();
                if (filename == null) {
                    this.app.showErrorDialog("Error downloading file! Please check URL.");
                    return;
                }
                file = new File(filename);
                fileType = extensions[type];
            }
            if (fileType.equals("xls")) {
                Vector<String> sheets = HelperFunctions.readExcelFile(file);
                if (sheets == null) {
                    this.app.showErrorDialog("Error reading excel file.");
                    return;
                }
                Enumeration<String> e = sheets.elements();
                while (e.hasMoreElements()) {
                    String str = e.nextElement();
                    if (str.trim().equals("")) continue;
                    this.app.getDatasheetTabbedPane().addDatasheet(str, null);
                }
            } else {
                String contents = HelperFunctions.getFileContents(file);
                if (fileType.equals("csv")) {
                    contents = HelperFunctions.parseCSV(contents);
                }
                this.app.getDatasheetTabbedPane().addDatasheet(contents, null);
            }
            boolean success = file.delete();
            if (!success) {
                System.out.println("cannot delete temp file");
            }
        }
        catch (IOException e) {
            this.app.showErrorDialog("Cannot access current directory");
            return;
        }
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.SampleComboBox.setEnabled(true);
        } else {
            this.SampleComboBox.setEnabled(false);
        }
    }

    private void WebRadioButtonStateChanged(ChangeEvent evt) {
        if (this.WebRadioButton.isSelected()) {
            this.URLTextField.setEnabled(true);
            this.TypeComboBox.setEnabled(true);
        } else {
            this.URLTextField.setEnabled(false);
            this.TypeComboBox.setEnabled(false);
        }
    }

    private void loadSampleComboBox() {
        this.SampleComboBox.removeAllItems();
        this.SampleComboBox.addItem("");
        this.SampleComboBox.setSelectedItem("");
        for (int i = 1; i < titles.length; ++i) {
            this.SampleComboBox.addItem(titles[i]);
        }
    }
}

