/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.utils.OrderingFunctions;

public class SortDialog
extends StatcatoDialog {
    private JRadioButton AscendingRadioButton1;
    private JRadioButton AscendingRadioButton2;
    private JRadioButton AscendingRadioButton3;
    private JRadioButton AscendingRadioButton4;
    private JRadioButton DescendingRadioButton1;
    private JRadioButton DescendingRadioButton2;
    private JRadioButton DescendingRadioButton3;
    private JRadioButton DescendingRadioButton4;
    private JTextField InputTextField;
    private JTextField OutputTextField;
    private JButton SortCancelButton;
    private JComboBox SortColumnsComboBox1;
    private JComboBox SortColumnsComboBox2;
    private JComboBox SortColumnsComboBox3;
    private JComboBox SortColumnsComboBox4;
    private JButton SortOKButton;
    private JRadioButton StoreOrgRadioButton;
    private JRadioButton StoreSpecRadioButton;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public SortDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.AscendingRadioButton1);
        group1.add(this.DescendingRadioButton1);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.AscendingRadioButton2);
        group2.add(this.DescendingRadioButton2);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.AscendingRadioButton3);
        group3.add(this.DescendingRadioButton3);
        ButtonGroup group4 = new ButtonGroup();
        group4.add(this.AscendingRadioButton4);
        group4.add(this.DescendingRadioButton4);
        ButtonGroup storeGroup = new ButtonGroup();
        storeGroup.add(this.StoreOrgRadioButton);
        storeGroup.add(this.StoreSpecRadioButton);
        this.AscendingRadioButton1.setSelected(false);
        this.DescendingRadioButton1.setSelected(false);
        this.AscendingRadioButton2.setSelected(false);
        this.DescendingRadioButton2.setSelected(false);
        this.AscendingRadioButton3.setSelected(false);
        this.DescendingRadioButton3.setSelected(false);
        this.AscendingRadioButton4.setSelected(false);
        this.DescendingRadioButton4.setSelected(false);
        this.ParentSpreadsheet.populateComboBox(this.SortColumnsComboBox1);
        this.ParentSpreadsheet.populateComboBox(this.SortColumnsComboBox2);
        this.ParentSpreadsheet.populateComboBox(this.SortColumnsComboBox3);
        this.ParentSpreadsheet.populateComboBox(this.SortColumnsComboBox4);
        this.getRootPane().setDefaultButton(this.SortOKButton);
        this.setHelpFile("data-sort");
        this.name = "Sort";
        this.description = "For sorting a number of data columns by data up to four columns.";
        this.helpStrings.add("If a column contains only numbers, the data will be sorted by their numerical values. Otherwise, the data will be sorted as text in alphabetically order.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.SortColumnsComboBox1);
        this.updateComboBox(this.SortColumnsComboBox2);
        this.updateComboBox(this.SortColumnsComboBox3);
        this.updateComboBox(this.SortColumnsComboBox4);
    }

    private void initComponents() {
        this.SortOKButton = new JButton();
        this.SortCancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.SortColumnsComboBox1 = new JComboBox();
        this.SortColumnsComboBox4 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.AscendingRadioButton3 = new JRadioButton();
        this.AscendingRadioButton2 = new JRadioButton();
        this.DescendingRadioButton3 = new JRadioButton();
        this.DescendingRadioButton2 = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.SortColumnsComboBox2 = new JComboBox();
        this.DescendingRadioButton1 = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.DescendingRadioButton4 = new JRadioButton();
        this.SortColumnsComboBox3 = new JComboBox();
        this.AscendingRadioButton4 = new JRadioButton();
        this.AscendingRadioButton1 = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.InputTextField = new JTextField();
        this.StoreOrgRadioButton = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.OutputTextField = new JTextField();
        this.StoreSpecRadioButton = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sort");
        this.SortOKButton.setText("OK");
        this.SortOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SortDialog.this.SortOKButtonActionPerformed(evt);
            }
        });
        this.SortCancelButton.setText("Cancel");
        this.SortCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SortDialog.this.SortCancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Sort Order"));
        this.SortColumnsComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SortDialog.this.SortColumnsComboBox1ItemStateChanged(evt);
            }
        });
        this.SortColumnsComboBox4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SortDialog.this.SortColumnsComboBox4ItemStateChanged(evt);
            }
        });
        this.jLabel2.setText("Sort By Column: ");
        this.jLabel5.setText("Then By Column: ");
        this.AscendingRadioButton3.setText("Ascending");
        this.AscendingRadioButton2.setText("Ascending");
        this.DescendingRadioButton3.setText("Descending");
        this.DescendingRadioButton2.setText("Descending");
        this.jLabel3.setText("Then By Column: ");
        this.SortColumnsComboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SortDialog.this.SortColumnsComboBox2ItemStateChanged(evt);
            }
        });
        this.DescendingRadioButton1.setText("Descending");
        this.jLabel4.setText("Then By Column: ");
        this.DescendingRadioButton4.setText("Descending");
        this.SortColumnsComboBox3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SortDialog.this.SortColumnsComboBox3ItemStateChanged(evt);
            }
        });
        this.AscendingRadioButton4.setText("Ascending");
        this.AscendingRadioButton1.setText("Ascending");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SortColumnsComboBox1, -2, 113, -2).addComponent(this.SortColumnsComboBox2, -2, 113, -2).addComponent(this.SortColumnsComboBox3, -2, 113, -2).addComponent(this.SortColumnsComboBox4, -2, 113, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.AscendingRadioButton1).addComponent(this.AscendingRadioButton2).addComponent(this.AscendingRadioButton3).addComponent(this.AscendingRadioButton4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DescendingRadioButton2).addComponent(this.DescendingRadioButton1).addComponent(this.DescendingRadioButton3).addComponent(this.DescendingRadioButton4)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.SortColumnsComboBox1, -2, -1, -2).addComponent(this.AscendingRadioButton1).addComponent(this.DescendingRadioButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel3).addComponent(this.SortColumnsComboBox2, -2, -1, -2).addComponent(this.AscendingRadioButton2).addComponent(this.DescendingRadioButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.SortColumnsComboBox3, -2, -1, -2).addComponent(this.AscendingRadioButton3).addComponent(this.DescendingRadioButton3, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel5).addComponent(this.SortColumnsComboBox4, -2, -1, -2).addComponent(this.AscendingRadioButton4).addComponent(this.DescendingRadioButton4)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Columns"));
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("Input Columns:");
        this.StoreOrgRadioButton.setSelected(true);
        this.StoreOrgRadioButton.setText("Store in original column(s)");
        this.StoreOrgRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SortDialog.this.StoreOrgRadioButtonStateChanged(evt);
            }
        });
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("Output Columns:");
        this.OutputTextField.setEnabled(false);
        this.StoreSpecRadioButton.setText("Store in these column(s):");
        this.StoreSpecRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SortDialog.this.StoreSpecRadioButtonStateChanged(evt);
            }
        });
        this.jLabel8.setText("<html>\n- Enter valid column names separated by space.<br>\nFor a continuous range of columns, separate using dash (e.g. C1-C30).<br>\n</html>\n");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.InputTextField, -2, 229, -2)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.StoreSpecRadioButton).addComponent(this.StoreOrgRadioButton).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.OutputTextField, -2, 212, -2)))).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8))).addContainerGap(22, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.InputTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel7).addGap(18, 18, 18).addComponent(this.StoreOrgRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.StoreSpecRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.OutputTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(128, 128, 128).addComponent(this.SortOKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SortCancelButton).addContainerGap(139, Short.MAX_VALUE)));
        layout.linkSize(0, this.SortCancelButton, this.SortOKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 158, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SortCancelButton).addComponent(this.SortOKButton)).addContainerGap()));
        this.pack();
    }

    private void SortColumnsComboBox1ItemStateChanged(ItemEvent evt) {
        if (this.SortColumnsComboBox1.getSelectedIndex() != 0) {
            this.AscendingRadioButton1.setSelected(true);
        }
    }

    private void SortColumnsComboBox2ItemStateChanged(ItemEvent evt) {
        if (this.SortColumnsComboBox2.getSelectedIndex() > 0) {
            if (this.SortColumnsComboBox1.getSelectedIndex() == 0) {
                this.AscendingRadioButton2.setSelected(false);
                this.SortColumnsComboBox2.setSelectedIndex(0);
                this.app.showErrorDialog("A Sort By Column must be selected first.");
            } else {
                this.AscendingRadioButton2.setSelected(true);
            }
        }
    }

    private void SortColumnsComboBox3ItemStateChanged(ItemEvent evt) {
        if (this.SortColumnsComboBox3.getSelectedIndex() > 0) {
            if (this.SortColumnsComboBox1.getSelectedIndex() == 0 || this.SortColumnsComboBox2.getSelectedIndex() == 0) {
                this.AscendingRadioButton3.setSelected(false);
                this.SortColumnsComboBox3.setSelectedIndex(0);
                this.app.showErrorDialog("A Sort By Column and a Then By Column must be selected.");
            } else {
                this.AscendingRadioButton3.setSelected(true);
            }
        }
    }

    private void SortColumnsComboBox4ItemStateChanged(ItemEvent evt) {
        if (this.SortColumnsComboBox4.getSelectedIndex() > 0) {
            if (this.SortColumnsComboBox1.getSelectedIndex() == 0 || this.SortColumnsComboBox2.getSelectedIndex() == 0 || this.SortColumnsComboBox3.getSelectedIndex() == 0) {
                this.AscendingRadioButton4.setSelected(false);
                this.SortColumnsComboBox4.setSelectedIndex(0);
                this.app.showErrorDialog("A Sort By Column and two Then By Columns must be selected.");
            } else {
                this.AscendingRadioButton4.setSelected(true);
            }
        }
    }

    private void SortOKButtonActionPerformed(ActionEvent evt) {
        int i;
        String sortKey4;
        int sortKeyColumn4;
        String sortKey3;
        int sortKeyColumn3;
        String sortKey2;
        int sortKeyColumn2;
        this.app.compoundEdit = new DialogEdit("sort");
        int[] inputColumnNumbers = this.ParentSpreadsheet.getColumnNumbersArrayFromString(this.InputTextField.getText());
        int[] storeColumnNumbers = this.ParentSpreadsheet.getColumnNumbersArrayFromString(this.OutputTextField.getText());
        if (this.StoreSpecRadioButton.isSelected() && inputColumnNumbers.length != storeColumnNumbers.length) {
            this.app.showErrorDialog("The number of input columns must be the same as the number of columns for storing results.");
            return;
        }
        boolean ascending1 = false;
        boolean ascending2 = false;
        boolean ascending3 = false;
        boolean ascending4 = false;
        Vector<Cell> byVec1 = null;
        Vector<Cell> byVec2 = null;
        Vector<Cell> byVec3 = null;
        Vector<Cell> byVec4 = null;
        Vector<Vector<Cell>> vectors = new Vector<Vector<Cell>>();
        vectors.addElement(new Vector());
        Vector<Boolean> orders = new Vector<Boolean>();
        orders.addElement(new Boolean(true));
        String sortKey1 = this.SortColumnsComboBox1.getSelectedItem().toString();
        int sortKeyColumn1 = this.ParentSpreadsheet.parseColumnNumber(sortKey1);
        if (sortKeyColumn1 != -1) {
            ascending1 = this.AscendingRadioButton1.isSelected();
            orders.addElement(new Boolean(ascending1));
            byVec1 = this.ParentSpreadsheet.getColumn(sortKeyColumn1);
            vectors.addElement(byVec1);
        }
        if ((sortKeyColumn2 = this.ParentSpreadsheet.parseColumnNumber(sortKey2 = this.SortColumnsComboBox2.getSelectedItem().toString())) != -1) {
            ascending2 = this.AscendingRadioButton2.isSelected();
            orders.addElement(new Boolean(ascending2));
            byVec2 = this.ParentSpreadsheet.getColumn(sortKeyColumn2);
            vectors.addElement(byVec2);
        }
        if ((sortKeyColumn3 = this.ParentSpreadsheet.parseColumnNumber(sortKey3 = this.SortColumnsComboBox3.getSelectedItem().toString())) != -1) {
            ascending3 = this.AscendingRadioButton3.isSelected();
            orders.addElement(new Boolean(ascending3));
            byVec3 = this.ParentSpreadsheet.getColumn(sortKeyColumn3);
            vectors.addElement(byVec3);
        }
        if ((sortKeyColumn4 = this.ParentSpreadsheet.parseColumnNumber(sortKey4 = this.SortColumnsComboBox4.getSelectedItem().toString())) != -1) {
            ascending4 = this.AscendingRadioButton4.isSelected();
            orders.addElement(new Boolean(ascending4));
            byVec4 = this.ParentSpreadsheet.getColumn(sortKeyColumn4);
            vectors.addElement(byVec4);
        }
        Vector<Vector<Cell>> sortedColumns = new Vector<Vector<Cell>>();
        for (i = 0; i < inputColumnNumbers.length; ++i) {
            Vector<Cell> vec = this.ParentSpreadsheet.getColumn(inputColumnNumbers[i]);
            vectors.setElementAt(vec, 0);
            Vector<Vector<Cell>> results = OrderingFunctions.sortVectors(vectors, orders);
            sortedColumns.addElement(results.elementAt(0));
        }
        if (this.StoreSpecRadioButton.isSelected()) {
            for (i = 0; i < inputColumnNumbers.length; ++i) {
                this.ParentSpreadsheet.setCellColumn(storeColumnNumbers[i], (Vector)sortedColumns.elementAt(i));
            }
        } else {
            for (i = 0; i < inputColumnNumbers.length; ++i) {
                this.ParentSpreadsheet.setCellColumn(inputColumnNumbers[i], (Vector)sortedColumns.elementAt(i));
            }
        }
        this.app.addLogParagraph("Sort", "");
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void SortCancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void StoreOrgRadioButtonStateChanged(ChangeEvent evt) {
        if (this.StoreOrgRadioButton.isSelected()) {
            this.OutputTextField.setEnabled(false);
        }
    }

    private void StoreSpecRadioButtonStateChanged(ChangeEvent evt) {
        if (this.StoreSpecRadioButton.isSelected()) {
            this.OutputTextField.setEnabled(true);
        }
    }
}

