/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.random.SampleFromVector;
import org.statcato.spreadsheet.Cell;
import org.statcato.utils.HelperFunctions;

public class SampleFromColumnDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JButton OKButton;
    private JCheckBox ReplaceCheckBox;
    private JTextField SeedTextField;
    private JTextField StoreTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField nTextField;

    public SampleFromColumnDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("data-random-random-user");
        this.name = "Random Samples from Column";
        this.description = "For drawing random samples from a set of data values with or without replacement.";
        this.helpStrings.add("Specify a column containing data values to draw samples from, column name(s) in which samples will be stored, whether the samples are replaced after being chosen, and the sample size.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
    }

    public void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ColumnComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.StoreTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.SeedTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.nTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.ReplaceCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Random Samples from Column");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleFromColumnDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleFromColumnDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Sample from Column:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(68, 68, 68).addComponent(this.ColumnComboBox, -2, 117, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ColumnComboBox, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Store Samples in:");
        this.jLabel5.setText("<html>\n- Enter valid column names separated by space.<br>\nFor a continuous range of columns, separate using dash (e.g. C1-C30).<br>\n- The random sampling process is repeated for each column.\n</html>\n");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(90, 90, 90).addComponent(this.StoreTextField, -2, 89, -2)).addComponent(this.jLabel5, -2, -1, -2)).addContainerGap(36, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.StoreTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, -1, -2).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Options"));
        this.jLabel4.setText("Random Generator Seed (optional):");
        this.jLabel1.setText("Number of Samples to Generate:");
        this.ReplaceCheckBox.setText("Sample With Replacement");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.ReplaceCheckBox).addGap(107, 107, 107)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel4)).addGap(17, 17, 17).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SeedTextField).addComponent(this.nTextField, -2, 68, -2)))).addContainerGap()));
        jPanel3Layout.linkSize(0, this.SeedTextField, this.nTextField);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.ReplaceCheckBox).addGap(15, 15, 15).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.nTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SeedTextField, -2, -1, -2).addComponent(this.jLabel4)))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(118, 118, 118).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(14, 14, 14).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap(44, Short.MAX_VALUE)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("sample from column");
        String yColumnLabel = this.ColumnComboBox.getSelectedItem().toString();
        if (yColumnLabel.equals("")) {
            this.app.showErrorDialog("Select the column containing samples.");
            return;
        }
        int column = this.ParentSpreadsheet.parseColumnNumber(yColumnLabel);
        Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
        StrColumnVector = HelperFunctions.removeNullCells(StrColumnVector);
        int n = 0;
        try {
            int max;
            n = Integer.parseInt(this.nTextField.getText());
            if (n <= 0) {
                throw new NumberFormatException();
            }
            if (!this.ReplaceCheckBox.isSelected() && n > (max = StrColumnVector.size())) {
                this.app.showErrorDialog("The sample size can be no larger than the number of possible data values in " + yColumnLabel + ".");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid sample size.");
            return;
        }
        String StoreColumn = this.StoreTextField.getText();
        Vector<Integer> nums = this.ParentSpreadsheet.getColumnNumbersFromString(StoreColumn);
        if (nums == null) {
            this.app.showErrorDialog("Invalid column(s) for storing results.");
            return;
        }
        for (int i = 0; i < nums.size(); ++i) {
            int storeColumnNum = nums.elementAt(i);
            SampleFromVector sampler = new SampleFromVector(StrColumnVector, this.ReplaceCheckBox.isSelected());
            try {
                long seed = Long.parseLong(this.SeedTextField.getText());
                sampler.setSeed(seed);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Vector<String> results = new Vector<String>();
            for (int j = 0; j < n; ++j) {
                Cell sample = sampler.nextSample();
                results.addElement(sample.getContents());
            }
            this.ParentSpreadsheet.setColumn(storeColumnNum, results);
        }
        this.app.addLogParagraph("Random Samples from Column " + yColumnLabel, n + " samples stored in each of " + StoreColumn);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

