/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.spreadsheet.CellComparator;
import org.statcato.utils.HelperFunctions;

public class RankDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox InputComboBox;
    private JButton OKButton;
    private JTextField StoreTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public RankDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.ParentSpreadsheet.populateComboBox(this.InputComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("data-rank");
        this.name = "Rank Data";
        this.description = "For assigning ranks to numerical values in a column.";
        this.helpStrings.add("Select the column containing data to be ranked and enter the column or variable name for storing ranks.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.InputComboBox);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.InputComboBox = new JComboBox();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.StoreTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Rank Data");
        this.jLabel1.setText("Rank data in:");
        this.jLabel1.setToolTipText("");
        this.jLabel2.setText("Store Ranks in:");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.StoreTextField).addComponent(this.InputComboBox, 0, 115, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(62, 62, 62).addComponent(this.OKButton).addGap(18, 18, 18).addComponent(this.CancelButton))).addContainerGap(53, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.InputComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.StoreTextField, -2, -1, -2)).addGap(34, 34, 34).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap(24, Short.MAX_VALUE)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        int i;
        this.app.compoundEdit = new DialogEdit("rank");
        String input = this.InputComboBox.getSelectedItem().toString();
        int inputColumn = this.ParentSpreadsheet.parseColumnNumber(input);
        Vector<Cell> CellColumnVector = this.ParentSpreadsheet.getColumn(inputColumn);
        Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(CellColumnVector);
        if (ColumnVector == null) {
            this.app.showErrorDialog("Invalid input column " + input + ": all data must be numbers.");
            return;
        }
        String StoreColumn = this.StoreTextField.getText();
        int storeColumnNum = this.ParentSpreadsheet.getColumnNumber(StoreColumn);
        if (storeColumnNum == -1) {
            this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the results.");
            return;
        }
        Vector Cells = (Vector)CellColumnVector.clone();
        Collections.sort(Cells, new CellComparator());
        double[] rankArray = new double[Cells.size()];
        Vector<String> rankVector = new Vector<String>(Cells.size());
        double sum = 0.0;
        int start = 0;
        int end = 0;
        for (i = 0; i < Cells.size(); ++i) {
            rankVector.addElement("");
        }
        i = 0;
        while (i < Cells.size()) {
            int j;
            start = i;
            for (end = i; end < Cells.size() - 1 && ((Cell)Cells.elementAt(end)).getNumValue() != null && ((Cell)Cells.elementAt(end + 1)).getNumValue() != null && ((Cell)Cells.elementAt(end)).getNumValue().doubleValue() == ((Cell)Cells.elementAt(end + 1)).getNumValue().doubleValue(); ++end) {
            }
            sum = 0.0;
            for (j = start; j <= end; ++j) {
                sum += (double)(j + 1);
            }
            double rank = sum / (double)(end - start + 1);
            for (j = start; j <= end; ++j) {
                rankArray[j] = rank;
            }
            i = end + 1;
        }
        for (i = 0; i < Cells.size(); ++i) {
            Cell cell = (Cell)Cells.elementAt(i);
            if (cell.getNumValue() == null) continue;
            rankVector.setElementAt(rankArray[i] + "", cell.getRow() - 1);
        }
        this.ParentSpreadsheet.setColumn(storeColumnNum, rankVector);
        this.app.addLogParagraph("Rank " + input + "-> store in " + StoreColumn, "");
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

