/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;

public class DisplayDataDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JList InputList;
    private JButton OKButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;

    public DisplayDataDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.initComponents();
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.ParentSpreadsheet.populateColumnsList(this.InputList);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("data-display-data");
        this.name = "Display Data";
        this.description = "For displaying the contents of column variables, along with the row numbers, in a tabular format in the log window.";
        this.helpStrings.add("Select the column(s) to be displayed in the log window (control-click to select multiple columns).");
    }

    @Override
    public void updateElements() {
        this.updateColumnsList(this.InputList);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.InputList = new JList();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Display Data");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Select Columns to be displayed in Session Window");
        this.jLabel2.setText("Ctrl-click to select multiple columns");
        this.jScrollPane1.setViewportView(this.InputList);
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayDataDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayDataDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addGap(6, 6, 6)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -2, 193, -2))).addContainerGap(35, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 194, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("display data");
        Object[] SelectedColumns = this.InputList.getSelectedValues();
        int[] columnNumbers = this.ParentSpreadsheet.convertColumnLabelsToNumbers(SelectedColumns);
        if (columnNumbers.length == 0) {
            this.app.showErrorDialog("Select at least one input variable.");
            return;
        }
        String table = "<table border='0'>";
        int numRows = this.ParentSpreadsheet.getLastRowNumber();
        table = table + "<tr><td>Row</td>";
        for (int i = 0; i < columnNumbers.length; ++i) {
            String columnLabel = (String)SelectedColumns[i];
            table = table + "<td>" + columnLabel + "</td>";
        }
        table = table + "</tr>";
        for (int row = 1; row <= numRows; ++row) {
            table = table + "<tr><td>" + row + "</td>";
            for (int i = 0; i < columnNumbers.length; ++i) {
                String data = this.ParentSpreadsheet.getValueAt(row, columnNumbers[i]).getContents();
                if (data.equals("")) {
                    data = "&nbsp;";
                }
                table = table + "<td>" + data + "</td>";
            }
            table = table + "</tr>";
        }
        table = table + "</table>";
        this.app.addLogParagraph("Data Display", table);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

