/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.calc.probdist;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.DiscreteCustomProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class DiscreteDistributionDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JRadioButton ColumnRadioButton;
    private JRadioButton ConstRadioButton;
    private JTextField ConstTextField;
    private JRadioButton CumProbRadioButton;
    private JRadioButton InvCumProbRadioButton;
    private JButton OKButton;
    private JRadioButton ProbDensityRadioButton;
    private JComboBox ProbabilitiesComboBox;
    private JTextField StoreTextField;
    private JComboBox ValuesComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public DiscreteDistributionDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.ProbDensityRadioButton);
        group1.add(this.CumProbRadioButton);
        group1.add(this.InvCumProbRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.ConstRadioButton);
        group2.add(this.ColumnRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ValuesComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ProbabilitiesComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("calc-discrete");
        this.name = "Discrete Probability Distribution";
        this.description = "For calculations on discrete probability distribution.";
        this.helpStrings.add("Select the columns containing discrete values and their corresponding probabilities.");
        this.helpStrings.add("Choose probability density for P(x), cumulative probability for (P(<= x), and inverse cumulative probability for finding x given a such that P(<= x) = a.");
        this.helpStrings.add("Inputs can be numbers within a column or a single constant.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
        this.updateComboBox(this.ValuesComboBox);
        this.updateComboBox(this.ProbabilitiesComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ProbDensityRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.CumProbRadioButton = new JRadioButton();
        this.ProbabilitiesComboBox = new JComboBox();
        this.ValuesComboBox = new JComboBox();
        this.InvCumProbRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.ColumnComboBox = new JComboBox();
        this.ConstRadioButton = new JRadioButton();
        this.StoreTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.ConstTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.ColumnRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Discrete Probability Distribution");
        this.OKButton.setText("Compute");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiscreteDistributionDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Close");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiscreteDistributionDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Distribution"));
        this.ProbDensityRadioButton.setSelected(true);
        this.ProbDensityRadioButton.setText("Probability density");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Compute:");
        this.jLabel3.setText("Probabilities in column:");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Distribution Parameters:");
        this.CumProbRadioButton.setText("Cumulative probability");
        this.InvCumProbRadioButton.setText("Inverse cumulative probability");
        this.jLabel2.setText("Values in column:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel4).addGroup(jPanel1Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.InvCumProbRadioButton)).addGroup(jPanel1Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.ProbDensityRadioButton)).addGroup(jPanel1Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.CumProbRadioButton)).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ProbabilitiesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.ValuesComboBox, 0, 111, Short.MAX_VALUE)))).addContainerGap(108, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ValuesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.ProbabilitiesComboBox, -2, -1, -2)).addGap(19, 19, 19).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ProbDensityRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CumProbRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InvCumProbRadioButton).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Inputs and Outputs"));
        this.ConstRadioButton.setText("Constant:");
        this.ConstRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DiscreteDistributionDialog.this.ConstRadioButtonStateChanged(evt);
            }
        });
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Input(s):");
        this.ConstTextField.setEnabled(false);
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("Store Results in: (optional)");
        this.jLabel7.setText("(e.g. C1 for column label, or variable name)");
        this.ColumnRadioButton.setSelected(true);
        this.ColumnRadioButton.setText("Column:");
        this.ColumnRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DiscreteDistributionDialog.this.ColumnRadioButtonStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(jPanel2Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConstRadioButton).addComponent(this.ColumnRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ConstTextField).addComponent(this.ColumnComboBox, 0, 111, Short.MAX_VALUE))).addComponent(this.jLabel6).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.StoreTextField, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ColumnRadioButton).addComponent(this.ColumnComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ConstRadioButton).addComponent(this.ConstTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.StoreTextField, -2, -1, -2).addComponent(this.jLabel7)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(103, 103, 103).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton, -2, 71, -2))).addContainerGap(15, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addGap(19, 19, 19).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void ConstRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ConstRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(false);
            this.ConstTextField.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(true);
            this.ConstTextField.setEnabled(false);
        }
    }

    private void ColumnRadioButtonStateChanged(ChangeEvent evt) {
        if (this.ColumnRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
            this.ConstTextField.setEnabled(false);
        } else {
            this.ColumnComboBox.setEnabled(false);
            this.ConstTextField.setEnabled(true);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        Double elm;
        this.app.compoundEdit = new DialogEdit("discrete pdf");
        boolean min = false;
        boolean max = false;
        String heading = "Discrete Distribution: ";
        String text = "";
        String valuesLabel = this.ValuesComboBox.getSelectedItem().toString();
        if (valuesLabel.equals("")) {
            this.app.showErrorDialog("Select the column containing values.");
            return;
        }
        int valueCol = this.ParentSpreadsheet.parseColumnNumber(valuesLabel);
        Vector<Cell> CellVector = this.ParentSpreadsheet.getColumn(valueCol);
        Vector<Double> ValuesVector = HelperFunctions.ConvertInputVectorToDoubles(CellVector);
        if (ValuesVector == null) {
            this.app.showErrorDialog("Invalid values column " + valuesLabel + ": all data must be numbers.");
            return;
        }
        ValuesVector = HelperFunctions.removeNullValues(ValuesVector);
        text = text + "Values in : " + valuesLabel + "<br>";
        String probsLabel = this.ProbabilitiesComboBox.getSelectedItem().toString();
        if (probsLabel.equals("")) {
            this.app.showErrorDialog("Select the column containing probabilities.");
            return;
        }
        int probCol = this.ParentSpreadsheet.parseColumnNumber(probsLabel);
        CellVector = this.ParentSpreadsheet.getColumn(probCol);
        Vector<Double> ProbsVector = HelperFunctions.ConvertInputVectorToDoubles(CellVector);
        if (ProbsVector == null) {
            this.app.showErrorDialog("Invalid probabilities column " + probsLabel + ": all data must be numbers.");
            return;
        }
        if (BasicStatistics.sum(ProbsVector) != 1.0) {
            this.app.showErrorDialog("Invalid probabilities column " + probsLabel + ": probabilities must add up to 1.");
            return;
        }
        ProbsVector = HelperFunctions.removeNullValues(ProbsVector);
        text = text + "Probabilities in : " + probsLabel + "<br>";
        if (ValuesVector.size() != ProbsVector.size()) {
            this.app.showErrorDialog("The number of values must be the same as the number of probabilities provided.");
            return;
        }
        Vector<Object> ColumnVector = new Vector<Double>();
        if (this.ColumnRadioButton.isSelected()) {
            String columnLabel = this.ColumnComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            text = text + "Input: " + columnLabel + "<br>";
        } else {
            try {
                double num = Double.parseDouble(this.ConstTextField.getText());
                ColumnVector.addElement(num);
                text = text + "Input: " + num + "<br>";
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid constant input.  Enter a valid number.");
                return;
            }
        }
        DiscreteCustomProbabilityDistribution npd = new DiscreteCustomProbabilityDistribution(ValuesVector, ProbsVector);
        Vector<String> ResultVector = new Vector<String>();
        if (this.ProbDensityRadioButton.isSelected()) {
            text = text + "Type: Probability density<br>";
            text = text + "<table>";
            text = text + "<tr><td>X</td><td>P(X)</td></tr>";
            for (int i = 0; i < ColumnVector.size(); ++i) {
                elm = (Double)ColumnVector.elementAt(i);
                if (elm == null) continue;
                double x = elm;
                double density = npd.density(x);
                text = text + "<tr><td>" + x + "</td><td>" + HelperFunctions.formatFloat(density, 6) + "</td></tr>";
                ResultVector.addElement(density + "");
            }
            text = text + "</table>";
        } else if (this.CumProbRadioButton.isSelected()) {
            text = text + "Type: Cumulative probability<br>";
            text = text + "<table>";
            text = text + "<tr><td>X</td><td>P(<&lt;=X)</td></tr>";
            for (int i = 0; i < ColumnVector.size(); ++i) {
                elm = (Double)ColumnVector.elementAt(i);
                if (elm == null) continue;
                double x = elm;
                double density = npd.cumulativeProbability(x);
                text = text + "<tr><td>" + x + "</td><td>" + HelperFunctions.formatFloat(density, 6) + "</td></tr>";
                ResultVector.addElement(density + "");
            }
            text = text + "</table>";
        } else if (this.InvCumProbRadioButton.isSelected()) {
            text = text + "Type: Inverse cumulative probability<br>";
            text = text + "<table>";
            text = text + "<tr><td>P(<&lt;=X)</td><td>X</td></tr>";
            for (int i = 0; i < ColumnVector.size(); ++i) {
                elm = (Double)ColumnVector.elementAt(i);
                if (elm == null) continue;
                double area = elm;
                Double x = npd.inverseCumulativeProbability(area);
                if (x == null) {
                    text = text + "<tr><td>" + area + "</td><td>" + "*" + "</td></tr>";
                    ResultVector.addElement("*");
                    continue;
                }
                text = text + "<tr><td>" + area + "</td><td>" + x.toString() + "</td></tr>";
                ResultVector.addElement(x + "");
            }
            text = text + "</table>";
        }
        String storeColumn = this.StoreTextField.getText();
        if (!storeColumn.equals("")) {
            int storeColumnNum = this.ParentSpreadsheet.getColumnNumber(storeColumn);
            if (storeColumnNum == -1) {
                this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the results.");
                return;
            }
            this.ParentSpreadsheet.setColumn(storeColumnNum, ResultVector);
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

