/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.calc;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.calculator.CompUnit;
import org.statcato.calculator.MathExpParserComplete;
import org.statcato.calculator.MathFunctions;
import org.statcato.utils.HelperFunctions;

public class CalculatorDialog
extends StatcatoDialog {
    private JButton BackButton;
    private JButton ClearButton;
    private JRadioButton DegRadioButton;
    private JButton DivideButton;
    private JButton DotButton;
    private JButton ExpButton;
    private JTextField ExpTextField;
    private JButton FunButton;
    private JList FunList;
    private JButton MinusButton;
    private JButton MultiplyButton;
    private JButton Num0Button;
    private JButton Num1Button;
    private JButton Num2Button;
    private JButton Num3Button;
    private JButton Num4Button;
    private JButton Num5Button;
    private JButton Num6Button;
    private JButton Num7Button;
    private JButton Num8Button;
    private JButton Num9Button;
    private JButton OKButton;
    private JButton ParanButton;
    private JButton PiButton;
    private JButton PlusButton;
    private JButton PowerButton;
    private JRadioButton RadRadioButton;
    private JLabel ResultLabel;
    private JPanel ResultPanel;
    private JButton SqrtButton;
    private JCheckBox StoreCheckBox;
    private JLabel StoreLabel;
    private JTextField StoreTextField;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;

    public CalculatorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.OKButton);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.RadRadioButton);
        group1.add(this.DegRadioButton);
        this.FunList.setSelectionMode(0);
        this.FunList.setListData(MathFunctions.getSortedFunNames());
        this.ResultPanel.setVisible(false);
        this.pack();
        this.setHelpFile("calc-calculator");
        this.name = "Calculator";
        this.description = "For basic calculations involving data in columns or constants.";
        this.helpStrings.add("Enter a valid expression to evaluate.  Press F1 for help.");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.ExpTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.BackButton = new JButton();
        this.ClearButton = new JButton();
        this.OKButton = new JButton();
        this.jPanel2 = new JPanel();
        this.PiButton = new JButton();
        this.Num4Button = new JButton();
        this.Num0Button = new JButton();
        this.Num8Button = new JButton();
        this.Num5Button = new JButton();
        this.Num2Button = new JButton();
        this.Num7Button = new JButton();
        this.DotButton = new JButton();
        this.Num1Button = new JButton();
        this.Num3Button = new JButton();
        this.Num9Button = new JButton();
        this.Num6Button = new JButton();
        this.jPanel3 = new JPanel();
        this.MinusButton = new JButton();
        this.PlusButton = new JButton();
        this.MultiplyButton = new JButton();
        this.PowerButton = new JButton();
        this.DivideButton = new JButton();
        this.ParanButton = new JButton();
        this.SqrtButton = new JButton();
        this.ExpButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.FunList = new JList();
        this.FunButton = new JButton();
        this.ResultPanel = new JPanel();
        this.ResultLabel = new JLabel();
        this.jPanel5 = new JPanel();
        this.DegRadioButton = new JRadioButton();
        this.RadRadioButton = new JRadioButton();
        this.jPanel6 = new JPanel();
        this.StoreLabel = new JLabel();
        this.StoreCheckBox = new JCheckBox();
        this.StoreTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Calculator");
        this.jLabel1.setText("Enter expression:");
        this.BackButton.setText("<html>&larr; Back</html>");
        this.BackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.BackButtonActionPerformed(evt);
            }
        });
        this.ClearButton.setText("Clear");
        this.ClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.ClearButtonActionPerformed(evt);
            }
        });
        this.OKButton.setText("<html>&crarr; OK</html>");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.OKButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.ExpTextField, -2, 308, -2).addGap(34, 34, 34).addComponent(this.OKButton, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BackButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ClearButton))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.BackButton, this.ClearButton, this.OKButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ExpTextField, -2, -1, -2).addComponent(this.BackButton, -2, -1, -2).addComponent(this.OKButton, -2, -1, -2).addComponent(this.ClearButton)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Numbers"));
        this.PiButton.setText("<html><font face=\"serif\">&pi;</font></html>\n");
        this.PiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.PiButtonActionPerformed(evt);
            }
        });
        this.Num4Button.setText("4");
        this.Num4Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num4ButtonActionPerformed(evt);
            }
        });
        this.Num0Button.setText("0");
        this.Num0Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num0ButtonActionPerformed(evt);
            }
        });
        this.Num8Button.setText("8");
        this.Num8Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num8ButtonActionPerformed(evt);
            }
        });
        this.Num5Button.setText("5");
        this.Num5Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num5ButtonActionPerformed(evt);
            }
        });
        this.Num2Button.setText("2");
        this.Num2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num2ButtonActionPerformed(evt);
            }
        });
        this.Num7Button.setText("7");
        this.Num7Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num7ButtonActionPerformed(evt);
            }
        });
        this.DotButton.setText(".");
        this.DotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.DotButtonActionPerformed(evt);
            }
        });
        this.Num1Button.setText("1");
        this.Num1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num1ButtonActionPerformed(evt);
            }
        });
        this.Num3Button.setText("3");
        this.Num3Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num3ButtonActionPerformed(evt);
            }
        });
        this.Num9Button.setText("9");
        this.Num9Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num9ButtonActionPerformed(evt);
            }
        });
        this.Num6Button.setText("6");
        this.Num6Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.Num6ButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.Num7Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Num8Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Num9Button)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.Num4Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Num5Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Num6Button)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.Num1Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Num2Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Num3Button)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.Num0Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DotButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PiButton, -2, -1, -2))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.DotButton, this.Num0Button, this.Num1Button, this.Num2Button, this.Num3Button, this.Num4Button, this.Num5Button, this.Num6Button, this.Num7Button, this.Num8Button, this.Num9Button, this.PiButton);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Num7Button).addComponent(this.Num8Button).addComponent(this.Num9Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Num4Button).addComponent(this.Num5Button).addComponent(this.Num6Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Num1Button).addComponent(this.Num2Button).addComponent(this.Num3Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Num0Button).addComponent(this.DotButton).addComponent(this.PiButton, -2, -1, -2)).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Operators"));
        this.MinusButton.setText("-");
        this.MinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.MinusButtonActionPerformed(evt);
            }
        });
        this.PlusButton.setText("+");
        this.PlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.PlusButtonActionPerformed(evt);
            }
        });
        this.MultiplyButton.setText("*");
        this.MultiplyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.MultiplyButtonActionPerformed(evt);
            }
        });
        this.PowerButton.setText("^");
        this.PowerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.PowerButtonActionPerformed(evt);
            }
        });
        this.DivideButton.setText("/");
        this.DivideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.DivideButtonActionPerformed(evt);
            }
        });
        this.ParanButton.setText("()");
        this.ParanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.ParanButtonActionPerformed(evt);
            }
        });
        this.SqrtButton.setText("<HTML>&radic;</html>\n");
        this.SqrtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.SqrtButtonActionPerformed(evt);
            }
        });
        this.ExpButton.setText("<html>e^</html>");
        this.ExpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.ExpButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.PowerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ParanButton)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.PlusButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MinusButton)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.MultiplyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DivideButton)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.SqrtButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ExpButton, 0, 1, Short.MAX_VALUE))).addContainerGap(16, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(0, this.DivideButton, this.ExpButton, this.MinusButton, this.MultiplyButton, this.ParanButton, this.PlusButton, this.PowerButton, this.SqrtButton);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PlusButton).addComponent(this.MinusButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MultiplyButton).addComponent(this.DivideButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PowerButton).addComponent(this.ParanButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SqrtButton, -2, -1, -2).addComponent(this.ExpButton, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Functions"));
        this.jScrollPane1.setViewportView(this.FunList);
        this.FunButton.setText("Select");
        this.FunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.FunButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 98, -2).addComponent(this.FunButton)).addContainerGap(38, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.FunButton).addContainerGap(12, Short.MAX_VALUE)));
        this.ResultPanel.setBorder(BorderFactory.createTitledBorder("Result"));
        GroupLayout ResultPanelLayout = new GroupLayout(this.ResultPanel);
        this.ResultPanel.setLayout(ResultPanelLayout);
        ResultPanelLayout.setHorizontalGroup(ResultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResultPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ResultLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        ResultPanelLayout.setVerticalGroup(ResultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResultPanelLayout.createSequentialGroup().addComponent(this.ResultLabel, -1, 41, Short.MAX_VALUE).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("For Trigonometric Functions"));
        this.DegRadioButton.setText("Degrees");
        this.RadRadioButton.setSelected(true);
        this.RadRadioButton.setText("Radians");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.RadRadioButton).addComponent(this.DegRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.RadRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DegRadioButton).addContainerGap(16, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Store Results"));
        this.StoreLabel.setText("Column:");
        this.StoreLabel.setEnabled(false);
        this.StoreCheckBox.setText("Store in Worksheet");
        this.StoreCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculatorDialog.this.StoreCheckBoxActionPerformed(evt);
            }
        });
        this.StoreTextField.setEnabled(false);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.StoreLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StoreTextField, -2, 85, -2)).addComponent(this.StoreCheckBox)).addContainerGap(19, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.StoreCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.StoreLabel).addComponent(this.StoreTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.ResultPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 86, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ResultPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        String exp = this.ExpTextField.getText();
        if (!exp.equals("")) {
            String storeColumn;
            String output = "";
            MathExpParserComplete parser = new MathExpParserComplete(this.ParentSpreadsheet);
            CompUnit result = parser.parse(exp, this.RadRadioButton.isSelected());
            output = result == null ? "<html>" + parser.getError() + "</html>" : "<html><b>" + result + "</b><br><br></html>";
            if (this.StoreCheckBox.isSelected() && !(storeColumn = this.StoreTextField.getText()).equals("")) {
                int storeColumnNum = this.ParentSpreadsheet.getColumnNumber(storeColumn);
                if (storeColumnNum == -1) {
                    this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the results.");
                    return;
                }
                if (result != null) {
                    Vector<Double> v;
                    if (result.getType() == 8) {
                        v = new Vector();
                        v.addElement(new Double(result.getNumber()));
                    } else {
                        v = result.getColumn();
                    }
                    this.ParentSpreadsheet.setColumn(storeColumnNum, HelperFunctions.ConvertDoubleVectorToString(v));
                    output = "<html><b>" + result + "</b><br><br>" + "Stored in " + storeColumn + "</html>";
                }
            }
            this.ResultLabel.setText(output);
            this.ResultPanel.setVisible(true);
            this.pack();
        } else {
            this.ResultPanel.setVisible(false);
        }
    }

    private void Num7ButtonActionPerformed(ActionEvent evt) {
        this.addText("7");
    }

    private void Num8ButtonActionPerformed(ActionEvent evt) {
        this.addText("8");
    }

    private void Num9ButtonActionPerformed(ActionEvent evt) {
        this.addText("9");
    }

    private void Num4ButtonActionPerformed(ActionEvent evt) {
        this.addText("4");
    }

    private void Num5ButtonActionPerformed(ActionEvent evt) {
        this.addText("5");
    }

    private void Num6ButtonActionPerformed(ActionEvent evt) {
        this.addText("6");
    }

    private void Num1ButtonActionPerformed(ActionEvent evt) {
        this.addText("1");
    }

    private void Num2ButtonActionPerformed(ActionEvent evt) {
        this.addText("2");
    }

    private void Num3ButtonActionPerformed(ActionEvent evt) {
        this.addText("3");
    }

    private void Num0ButtonActionPerformed(ActionEvent evt) {
        this.addText("0");
    }

    private void DotButtonActionPerformed(ActionEvent evt) {
        this.addText(".");
    }

    private void PiButtonActionPerformed(ActionEvent evt) {
        this.addText("pi");
    }

    private void PlusButtonActionPerformed(ActionEvent evt) {
        this.addText("+");
    }

    private void MinusButtonActionPerformed(ActionEvent evt) {
        this.addText("-");
    }

    private void MultiplyButtonActionPerformed(ActionEvent evt) {
        this.addText("*");
    }

    private void DivideButtonActionPerformed(ActionEvent evt) {
        this.addText("/");
    }

    private void PowerButtonActionPerformed(ActionEvent evt) {
        this.addText("^");
    }

    private void ParanButtonActionPerformed(ActionEvent evt) {
        int pos = this.ExpTextField.getCaretPosition();
        this.addText("()");
        this.ExpTextField.setCaretPosition(pos + 1);
    }

    private void BackButtonActionPerformed(ActionEvent evt) {
        int pos = this.ExpTextField.getCaretPosition();
        String text = this.ExpTextField.getText().trim();
        String newText = "";
        if (!text.equals("")) {
            newText = text.substring(0, pos - 1);
            if (pos < text.length()) {
                newText = newText + text.substring(pos);
            }
            this.ExpTextField.setText(newText);
            this.ExpTextField.setCaretPosition(pos - 1);
        }
        this.ExpTextField.requestFocusInWindow();
    }

    private void SqrtButtonActionPerformed(ActionEvent evt) {
        int pos = this.ExpTextField.getCaretPosition();
        this.addText("sqrt()");
        this.ExpTextField.setCaretPosition(pos + 5);
    }

    private void ExpButtonActionPerformed(ActionEvent evt) {
        int pos = this.ExpTextField.getCaretPosition();
        this.addText("exp()");
        this.ExpTextField.setCaretPosition(pos + 4);
    }

    private void FunButtonActionPerformed(ActionEvent evt) {
        String fun = (String)this.FunList.getSelectedValue();
        int pos = this.ExpTextField.getCaretPosition();
        this.addText(fun + "()");
        this.ExpTextField.setCaretPosition(pos + fun.length() + 1);
    }

    private void ClearButtonActionPerformed(ActionEvent evt) {
        this.ExpTextField.setText("");
        this.ResultPanel.setVisible(false);
        this.pack();
        this.ExpTextField.requestFocusInWindow();
    }

    private void StoreCheckBoxActionPerformed(ActionEvent evt) {
        if (this.StoreCheckBox.isSelected()) {
            this.StoreLabel.setEnabled(true);
            this.StoreTextField.setEnabled(true);
        } else {
            this.StoreLabel.setEnabled(false);
            this.StoreTextField.setEnabled(false);
        }
    }

    private void addText(String str) {
        int pos = this.ExpTextField.getCaretPosition();
        String text = this.ExpTextField.getText();
        String newText = "";
        if (text.equals("")) {
            newText = str;
        } else {
            newText = text.substring(0, pos) + str;
            if (pos < text.length()) {
                newText = newText + text.substring(pos);
            }
        }
        this.ExpTextField.setText(newText);
        this.ExpTextField.setCaretPosition(pos + str.length());
        this.ExpTextField.requestFocusInWindow();
    }
}

