/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.calculator;

import org.statcato.spreadsheet.Spreadsheet;

public class TokenScanner {
    private String expr;
    public String error = "";
    private int index;
    private int nextIndex;
    private double number;
    private int column;
    private int function;
    private double constant;
    private Spreadsheet spreadsheet;

    public TokenScanner(String expr, Spreadsheet spreadsheet) {
        this.expr = expr.trim();
        this.index = 0;
        this.nextIndex = 0;
        this.spreadsheet = spreadsheet;
    }

    public void printRemaining() {
        System.out.println("* remaining: " + this.expr.substring(this.index) + "*");
    }

    public double consumeNumber() {
        this.consumeToken();
        return this.number;
    }

    public int consumeColumn() {
        this.consumeToken();
        return this.column;
    }

    public int consumeFunction() {
        this.consumeToken();
        return this.function;
    }

    public double consumeConstant() {
        this.consumeToken();
        return this.constant;
    }

    private Character getNextCharacter() {
        if (this.index >= this.expr.length()) {
            return null;
        }
        Character ch = Character.valueOf(this.expr.charAt(this.index));
        return ch;
    }

    private void consumeNextCharacter() {
        ++this.index;
    }

    public int getToken() {
        int token = -1;
        if (this.getNextCharacter() == null) {
            return 14;
        }
        while (this.getNextCharacter() != null && Character.isWhitespace(this.getNextCharacter().charValue())) {
            this.consumeNextCharacter();
        }
        int oldIndex = this.index;
        Character ch = this.getNextCharacter();
        if (Character.isLetter(ch.charValue())) {
            this.column = this.getColumn();
            if (this.column != -1) {
                token = 10;
            } else {
                this.index = oldIndex;
                this.function = this.getFunction();
                if (this.function != -1) {
                    token = 9;
                } else {
                    this.index = oldIndex;
                    this.constant = this.getConstant();
                    if (this.constant != Double.NEGATIVE_INFINITY) {
                        token = 12;
                    } else {
                        this.error("Invalid letter sequence");
                    }
                }
            }
        } else if (Character.isDigit(ch.charValue())) {
            this.number = this.getNumber();
            token = 8;
        } else {
            switch (ch.charValue()) {
                case '.': {
                    this.number = this.getDecimal();
                    if (Double.isNaN(this.number)) {
                        this.error("Invalid decimal value");
                        break;
                    }
                    token = 8;
                    break;
                }
                case '+': {
                    token = 0;
                    this.consumeNextCharacter();
                    break;
                }
                case '-': {
                    token = 1;
                    this.consumeNextCharacter();
                    break;
                }
                case '*': {
                    token = 2;
                    this.consumeNextCharacter();
                    break;
                }
                case '/': {
                    token = 3;
                    this.consumeNextCharacter();
                    break;
                }
                case '^': {
                    token = 4;
                    this.consumeNextCharacter();
                    break;
                }
                case '(': {
                    token = 6;
                    this.consumeNextCharacter();
                    break;
                }
                case ')': {
                    token = 7;
                    this.consumeNextCharacter();
                    break;
                }
                case '\"': {
                    String str = this.getString();
                    if (str.equals("")) {
                        this.error("unexpected column name");
                        break;
                    }
                    this.column = this.spreadsheet.getColumnNumber(str);
                    if (this.column == -1) {
                        this.error("invaild column name");
                        break;
                    }
                    token = 10;
                    break;
                }
                default: {
                    this.error("Illegal character:" + ch);
                }
            }
        }
        this.nextIndex = this.index;
        this.index = oldIndex;
        return token;
    }

    public void consumeToken() {
        this.index = this.nextIndex;
    }

    public int getColumn() {
        Character ch = this.getNextCharacter();
        if (ch.charValue() == 'c' || ch.charValue() == 'C') {
            this.consumeNextCharacter();
            if (Character.isDigit(this.getNextCharacter().charValue())) {
                int col = this.getInteger();
                return this.spreadsheet.getColumnNumber("c" + col);
            }
        }
        return -1;
    }

    public int getFunction() {
        Character ch = this.getNextCharacter();
        switch (ch.charValue()) {
            case 'a': {
                if (this.expect("abs")) {
                    return 3;
                }
                if (this.expect("arccos")) {
                    return 5;
                }
                if (this.expect("arcsin")) {
                    return 6;
                }
                if (this.expect("arctan")) {
                    return 7;
                }
            }
            case 'c': {
                if (this.expect("cos")) {
                    return 1;
                }
                if (this.expect("ceil")) {
                    return 8;
                }
            }
            case 'e': {
                if (this.expect("exp")) {
                    return 2;
                }
            }
            case 'f': {
                if (this.expect("floor")) {
                    return 9;
                }
                if (this.expect("factorial")) {
                    return 14;
                }
            }
            case 'l': {
                if (this.expect("log")) {
                    return 10;
                }
                if (this.expect("ln")) {
                    return 13;
                }
            }
            case 'r': {
                if (this.expect("round")) {
                    return 11;
                }
            }
            case 's': {
                if (this.expect("sin")) {
                    return 0;
                }
                if (this.expect("sqrt")) {
                    return 12;
                }
            }
            case 't': {
                if (!this.expect("tan")) break;
                return 4;
            }
        }
        return -1;
    }

    public double getConstant() {
        Character ch = this.getNextCharacter();
        switch (ch.charValue()) {
            case 'p': {
                if (!this.expect("pi")) break;
                return Math.PI;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean expect(String name) {
        if (name == null || name.equals("")) {
            return false;
        }
        Character ch = this.getNextCharacter();
        int oldIndex = this.index;
        for (int i = 0; i < name.length() && ch != null; ++i) {
            if (ch.charValue() != name.charAt(i)) {
                this.index = oldIndex;
                return false;
            }
            this.consumeNextCharacter();
            ch = this.getNextCharacter();
        }
        return true;
    }

    public String getString() {
        this.consumeNextCharacter();
        String str = "";
        Character ch = this.getNextCharacter();
        while (ch != null && ch.charValue() != '\"') {
            str = str + ch;
            this.consumeNextCharacter();
            ch = this.getNextCharacter();
        }
        if (ch == null) {
            return "";
        }
        if (ch.charValue() == '\"') {
            this.consumeNextCharacter();
            return str;
        }
        return "";
    }

    public double getNumber() {
        Character ch = this.getNextCharacter();
        String num = "";
        while (ch != null && Character.isDigit(ch.charValue())) {
            num = num + ch;
            this.consumeNextCharacter();
            ch = this.getNextCharacter();
        }
        ch = this.getNextCharacter();
        if (ch != null && ch.equals(Character.valueOf('.'))) {
            num = num + ".";
            this.consumeNextCharacter();
            ch = this.getNextCharacter();
            while (ch != null && Character.isDigit(ch.charValue())) {
                num = num + ch;
                this.consumeNextCharacter();
                ch = this.getNextCharacter();
            }
        }
        return Double.parseDouble(num);
    }

    public int getInteger() {
        Character ch = this.getNextCharacter();
        String num = "";
        while (ch != null && Character.isDigit(ch.charValue())) {
            num = num + ch;
            this.consumeNextCharacter();
            ch = this.getNextCharacter();
        }
        return Integer.parseInt(num);
    }

    public double getDecimal() {
        this.consumeNextCharacter();
        Character ch = this.getNextCharacter();
        if (!Character.isDigit(ch.charValue())) {
            return Double.NaN;
        }
        String num = "0.";
        while (ch != null && Character.isDigit(ch.charValue())) {
            num = num + ch;
            this.consumeNextCharacter();
            ch = this.getNextCharacter();
        }
        return Double.parseDouble(num);
    }

    public void error(String msg) {
        this.error = this.error + msg + "<br>";
    }
}

