/*
 * Decompiled with CFR 0.152.
 */
package org.statcato;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.file.ExtensionFileFilter;
import org.statcato.file.FileChooserUtils;
import org.statcato.utils.HelperFunctions;

public class LogWindow
extends JTextPane
implements Serializable {
    File savedFile = null;
    boolean changed = false;
    transient Statcato app = null;

    public LogWindow(Statcato mTab) {
        this.app = mTab;
        this.initialize();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    HTMLDocument doc = (HTMLDocument)LogWindow.this.getDocument();
                    HTMLEditorKit editorKit = (HTMLEditorKit)LogWindow.this.getEditorKit();
                    try {
                        editorKit.insertHTML(doc, LogWindow.this.getCaretPosition(), "<br>", 0, 0, null);
                        int pos = LogWindow.this.getCaretPosition();
                        LogWindow.this.setChangedStatus();
                        String txt = LogWindow.this.getText();
                        LogWindow.this.setText("");
                        LogWindow.this.setText(txt);
                        LogWindow.this.setCaretPosition(pos - 2);
                    }
                    catch (BadLocationException ex) {
                        System.out.println(ex);
                    }
                    catch (IOException ex) {
                        System.out.println(ex);
                    }
                }
                if (!e.isControlDown()) {
                    LogWindow.this.setChangedStatus();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 86) {
                    LogWindow.this.setChangedStatus();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void initialize() {
        this.setContentType("text/html");
        this.setText("");
        String WelcomeText = "Welcome to Statcato!<br> ";
        WelcomeText = WelcomeText + HelperFunctions.getDateTime() + "<hr size='1'>";
        this.setText(WelcomeText);
        int pos = this.getCaretPosition();
        this.addUnformattedText("");
        this.setCaretPosition(pos);
        this.setUnchangedStatus();
        this.setEditable(true);
        StyleSheet sheet = new HTMLEditorKit().getStyleSheet();
        sheet.addRule("body { font-family: san-serif;}");
    }

    public void addParagraph(String heading, String message) {
        message = "<br><b>" + heading + "</b><br>" + message.replace("\n", "") + "<br>";
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        HTMLEditorKit editorKit = (HTMLEditorKit)this.getEditorKit();
        try {
            editorKit.insertHTML(doc, doc.getLength(), message, 0, 0, null);
            this.setChangedStatus();
        }
        catch (BadLocationException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void addText(String message) {
        message = message.replace("\n", "") + "<br>";
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        HTMLEditorKit editorKit = (HTMLEditorKit)this.getEditorKit();
        try {
            editorKit.insertHTML(doc, doc.getLength(), message, 0, 0, null);
            this.setChangedStatus();
        }
        catch (BadLocationException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void addUnformattedText(String message) {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        HTMLEditorKit editorKit = (HTMLEditorKit)this.getEditorKit();
        try {
            editorKit.insertHTML(doc, doc.getLength(), message.replace("\n", ""), 0, 0, null);
            this.setChangedStatus();
        }
        catch (BadLocationException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void addHeading(String message) {
        message = "<br><b>" + message + "</b><br>";
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        HTMLEditorKit editorKit = (HTMLEditorKit)this.getEditorKit();
        try {
            editorKit.insertHTML(doc, doc.getLength(), message, 0, 0, null);
            this.setChangedStatus();
        }
        catch (BadLocationException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void setChangedStatus() {
        if (!this.changed) {
            this.changed = true;
            this.app.setLogTitle(this.app.getLogTitle() + "*");
        }
    }

    public void setUnchangedStatus() {
        this.changed = false;
        String title = this.app.getLogTitle();
        if (title.endsWith("*")) {
            this.app.setLogTitle(this.app.getLogTitle().substring(0, title.length() - 1));
        }
    }

    public boolean getChangedStatus() {
        return this.changed;
    }

    public File writeToFile(JFrame frame, boolean saveAs) {
        String path = "";
        String extension = "";
        if (this.savedFile != null && !saveAs) {
            path = this.savedFile.getPath();
            extension = FileChooserUtils.getExtension(this.savedFile);
            this.writeFileHelper(frame, path);
            return this.savedFile;
        }
        JFileChooser fc = new JFileChooser();
        ExtensionFileFilter HTMLFilter = new ExtensionFileFilter("HTML (*.html)", "html");
        fc.addChoosableFileFilter(HTMLFilter);
        fc.setAcceptAllFileFilterUsed(false);
        int returnValue = fc.showSaveDialog(frame);
        if (returnValue == 0) {
            File file = fc.getSelectedFile();
            path = file.getPath();
            extension = "";
            FileFilter filter = fc.getFileFilter();
            if (filter.equals(HTMLFilter)) {
                extension = "html";
            }
            if (!path.toLowerCase().endsWith("." + extension)) {
                path = path + "." + extension;
                file = new File(path);
            }
            if (file.exists()) {
                System.out.println("file exists already");
                Object[] options = new Object[]{"Overwrite file", "Cancel"};
                int choice = JOptionPane.showOptionDialog(frame, "The specified file already exists.  Overwrite existing file?", "Overwrite file?", 0, 2, null, options, options[1]);
                if (choice != 0) {
                    return null;
                }
            }
            this.writeFileHelper(frame, path);
            this.savedFile = file;
            return file;
        }
        return null;
    }

    private void writeFileHelper(JFrame frame, String path) {
        try {
            String htmlSource = this.getText();
            BufferedWriter Writer2 = new BufferedWriter(new FileWriter(path));
            String[] lines = htmlSource.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                Writer2.write(lines[i]);
                Writer2.newLine();
            }
            Writer2.close();
            this.setUnchangedStatus();
        }
        catch (IOException e) {
            HelperFunctions.showErrorDialog(frame, "Write file failed!");
        }
    }

    public void clear() {
        this.app.compoundEdit = new DialogEdit("clear log");
        this.initialize();
        this.setChangedStatus();
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
    }

    public void overwrite(String txt) {
        this.app.compoundEdit = new DialogEdit("load log");
        this.setText("");
        this.addText(txt);
        this.setChangedStatus();
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
    }

    public void appendLog(String log) {
        this.app.compoundEdit = new DialogEdit("Append log");
        this.addUnformattedText(log);
        this.setUnchangedStatus();
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
    }
}

