/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.test.BeanComparisonError;

public final class BeanAssert {
    private BeanAssert() {
    }

    public static void assertBeanEquals(Bean expected, Bean actual) {
        BeanAssert.assertBeanEquals(null, expected, actual, 0.0);
    }

    public static void assertBeanEquals(Bean expected, Bean actual, double tolerance) {
        BeanAssert.assertBeanEquals(null, expected, actual, tolerance);
    }

    public static void assertBeanEquals(String baseMsg, Bean expected, Bean actual) {
        BeanAssert.assertBeanEquals(baseMsg, expected, actual, 0.0);
    }

    public static void assertBeanEquals(String baseMsg, Bean expected, Bean actual, double tolerance) {
        if (expected == null) {
            throw new AssertionError((Object)(baseMsg + ": Expected bean must not be null"));
        }
        if (actual == null) {
            throw new AssertionError((Object)(baseMsg + ": Actual bean must not be null"));
        }
        if (!expected.equals(actual)) {
            String comparisonMsg = BeanAssert.buildMessage(baseMsg, 10, expected, actual, tolerance);
            if (comparisonMsg.isEmpty()) {
                return;
            }
            throw new BeanComparisonError(comparisonMsg, expected, actual);
        }
    }

    public static void assertBeanEqualsFullDetail(Bean expected, Bean actual) {
        BeanAssert.assertBeanEqualsFullDetail(null, expected, actual, 0.0);
    }

    public static void assertBeanEqualsFullDetail(Bean expected, Bean actual, double tolerance) {
        BeanAssert.assertBeanEqualsFullDetail(null, expected, actual, tolerance);
    }

    public static void assertBeanEqualsFullDetail(String baseMsg, Bean expected, Bean actual) {
        BeanAssert.assertBeanEqualsFullDetail(baseMsg, expected, actual, 0.0);
    }

    public static void assertBeanEqualsFullDetail(String baseMsg, Bean expected, Bean actual, double tolerance) {
        if (expected == null) {
            throw new AssertionError((Object)(baseMsg + ": Expected bean must not be null"));
        }
        if (actual == null) {
            throw new AssertionError((Object)(baseMsg + ": Actual bean must not be null"));
        }
        if (!expected.equals(actual)) {
            String comparisonMsg = BeanAssert.buildMessage(baseMsg, Integer.MAX_VALUE, expected, actual, tolerance);
            if (comparisonMsg.isEmpty()) {
                return;
            }
            throw new BeanComparisonError(comparisonMsg, expected, actual);
        }
    }

    private static String buildMessage(String baseMsg, int maxErrors, Bean expected, Bean actual, double tolerance) {
        List<String> diffs = new ArrayList<String>();
        BeanAssert.buildMessage(diffs, "", (Object)expected, (Object)actual, tolerance);
        if (diffs.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(baseMsg != null ? baseMsg + ": " : "");
        buf.append("Bean did not equal expected. Differences:");
        int size = diffs.size();
        if (size > maxErrors) {
            diffs = diffs.subList(0, maxErrors);
        }
        for (String diff : diffs) {
            buf.append('\n').append(diff);
        }
        if (size > maxErrors) {
            buf.append("\n...and " + (size - 10) + " more differences");
        }
        return buf.toString();
    }

    private static void buildMessage(List<String> diffs, String prefix, Object expected, Object actual, double tolerance) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            diffs.add(prefix + ": Expected null, but was " + BeanAssert.buildSummary(actual, true));
            return;
        }
        if (expected != null && actual == null) {
            diffs.add(prefix + ": Was null, but expected " + BeanAssert.buildSummary(expected, true));
            return;
        }
        if (expected instanceof List && actual instanceof List) {
            List expectedList = (List)expected;
            List actualList = (List)actual;
            if (expectedList.size() != actualList.size()) {
                diffs.add(prefix + ": List size differs, expected " + expectedList.size() + " but was " + actualList.size());
                return;
            }
            for (int i = 0; i < expectedList.size(); ++i) {
                BeanAssert.buildMessage(diffs, prefix + '[' + i + "]", expectedList.get(i), actualList.get(i), tolerance);
            }
            return;
        }
        if (expected instanceof Map && actual instanceof Map) {
            Map expectedMap = (Map)expected;
            Map actualMap = (Map)actual;
            if (expectedMap.size() != actualMap.size()) {
                diffs.add(prefix + ": Map size differs, expected " + expectedMap.size() + " but was " + actualMap.size());
                return;
            }
            if (!((Object)expectedMap.keySet()).equals(actualMap.keySet())) {
                diffs.add(prefix + ": Map keyset differs, expected " + BeanAssert.buildSummary(expectedMap.keySet(), false) + " but was " + BeanAssert.buildSummary(actualMap.keySet(), false));
                return;
            }
            for (Object key : expectedMap.keySet()) {
                BeanAssert.buildMessage(diffs, prefix + '[' + key + "]", expectedMap.get(key), actualMap.get(key), tolerance);
            }
            return;
        }
        if (expected.getClass() != actual.getClass()) {
            diffs.add(prefix + ": Class differs, expected " + BeanAssert.buildSummary(expected, true) + " but was " + BeanAssert.buildSummary(actual, true));
            return;
        }
        if (expected instanceof Bean) {
            for (MetaProperty<?> prop : ((Bean)expected).metaBean().metaPropertyIterable()) {
                BeanAssert.buildMessage(diffs, prefix + '.' + prop.name(), prop.get((Bean)expected), prop.get((Bean)actual), tolerance);
            }
            return;
        }
        if (expected instanceof Double && actual instanceof Double && tolerance != 0.0) {
            double a;
            double e = (Double)expected;
            if (!JodaBeanUtils.equalWithTolerance(e, a = ((Double)actual).doubleValue(), tolerance)) {
                diffs.add(prefix + ": Double values differ by more than allowed tolerance, expected " + BeanAssert.buildSummary(expected, true) + " but was " + BeanAssert.buildSummary(actual, false));
            }
            return;
        }
        if (expected instanceof double[] && actual instanceof double[] && tolerance != 0.0) {
            double[] e = (double[])expected;
            double[] a = (double[])actual;
            if (e.length != a.length) {
                diffs.add(prefix + ": Double arrays differ in length, expected " + BeanAssert.buildSummary(expected, true) + " but was " + BeanAssert.buildSummary(actual, false));
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (JodaBeanUtils.equalWithTolerance(e[i], a[i], tolerance)) continue;
                    diffs.add(prefix + ": Double arrays differ by more than allowed tolerance, expected " + BeanAssert.buildSummary(expected, true) + " but was " + BeanAssert.buildSummary(actual, false));
                    break;
                }
            }
            return;
        }
        if (expected instanceof Float && actual instanceof Float && tolerance != 0.0) {
            float a;
            float e = ((Float)expected).floatValue();
            if (!JodaBeanUtils.equalWithTolerance(e, a = ((Float)actual).floatValue(), tolerance)) {
                diffs.add(prefix + ": Float values differ by more than allowed tolerance, expected " + BeanAssert.buildSummary(expected, true) + " but was " + BeanAssert.buildSummary(actual, false));
            }
            return;
        }
        if (expected instanceof float[] && actual instanceof float[] && tolerance != 0.0) {
            float[] e = (float[])expected;
            float[] a = (float[])actual;
            if (e.length != a.length) {
                diffs.add(prefix + ": Double arrays differ in length, expected " + BeanAssert.buildSummary(expected, true) + " but was " + BeanAssert.buildSummary(actual, false));
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (JodaBeanUtils.equalWithTolerance(e[i], a[i], tolerance)) continue;
                    diffs.add(prefix + ": Float arrays differ by more than allowed tolerance, expected " + BeanAssert.buildSummary(expected, true) + " but was " + BeanAssert.buildSummary(actual, false));
                    break;
                }
            }
            return;
        }
        if (!JodaBeanUtils.equal(expected, actual)) {
            diffs.add(prefix + ": Content differs, expected " + BeanAssert.buildSummary(expected, true) + " but was " + BeanAssert.buildSummary(actual, false));
            return;
        }
    }

    private static String buildSummary(Object obj, boolean includeType) {
        String type = obj.getClass().getSimpleName();
        String toStr = obj instanceof double[] ? Arrays.toString((double[])obj) : (obj instanceof float[] ? Arrays.toString((float[])obj) : obj.toString());
        if (toStr.length() > 60) {
            toStr = toStr.substring(0, 57) + "...";
        }
        return (includeType ? type + " " : "") + "<" + toStr + ">";
    }
}

