/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Regression;

import Catalano.Statistics.Regression.ExponentialRegression;
import Catalano.Statistics.Regression.ISimpleRegression;
import Catalano.Statistics.Regression.LinearRegression;
import Catalano.Statistics.Regression.LogarithmicRegression;
import Catalano.Statistics.Regression.PolynomialRegression;
import Catalano.Statistics.Regression.PowerRegression;
import java.util.ArrayList;
import java.util.List;

public class RegressionAnalysis {
    private int maxDegree = 2;
    private int usedDegree = 0;
    private boolean usePolynomial = true;

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public void setMaxDegree(int maxDegree) {
        this.maxDegree = Math.max(maxDegree, 2);
    }

    public int getUsedDegree() {
        return this.usedDegree;
    }

    public boolean isUsePolynomial() {
        return this.usePolynomial;
    }

    public void setUsePolynomial(boolean usePolynomial) {
        this.usePolynomial = usePolynomial;
    }

    public RegressionAnalysis() {
        this(2);
    }

    public RegressionAnalysis(int maxDegree) {
        this.usePolynomial = true;
        this.setMaxDegree(maxDegree);
    }

    public RegressionAnalysis(boolean usePolynomial) {
        this.usePolynomial = usePolynomial;
        this.setMaxDegree(2);
    }

    public ISimpleRegression BestFit(double[] x, double[] y) {
        ArrayList<ISimpleRegression> lst = new ArrayList<ISimpleRegression>();
        lst.add(new LinearRegression(x, y));
        lst.add(new LogarithmicRegression(x, y));
        lst.add(new ExponentialRegression(x, y));
        lst.add(new PowerRegression(x, y));
        ISimpleRegression bestRegression = null;
        double bestFit = 0.0;
        for (ISimpleRegression r : lst) {
            double f = r.CoefficientOfDetermination();
            if (f == 1.0) {
                return r;
            }
            if (!(f > bestFit)) continue;
            bestFit = f;
            bestRegression = r;
        }
        if (this.usePolynomial) {
            PolynomialRegression r = new PolynomialRegression(x, y, 2);
            double f = r.CoefficientOfDetermination();
            if (f == 1.0) {
                return r;
            }
            if (f > bestFit) {
                bestFit = f;
                bestRegression = r;
                this.usedDegree = 2;
            }
            for (int i = 3; i <= this.maxDegree; ++i) {
                r = new PolynomialRegression(x, y, i);
                f = r.CoefficientOfDetermination();
                if (f == 1.0) {
                    return r;
                }
                if (!(f > bestFit)) continue;
                bestFit = f;
                bestRegression = r;
                this.usedDegree = i;
            }
        }
        return bestRegression;
    }

    public ISimpleRegression BestFit(List<ISimpleRegression> regressions) {
        ISimpleRegression reg = null;
        double best = 0.0;
        for (ISimpleRegression r : regressions) {
            double c = r.CoefficientOfDetermination();
            if (!(c > best)) continue;
            best = c;
            reg = r;
        }
        return reg;
    }
}

