/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Regression;

import Catalano.Math.Decompositions.QRDecomposition;
import Catalano.Statistics.Correlations;
import Catalano.Statistics.Regression.ISimpleRegression;

public class PolynomialRegression
implements ISimpleRegression {
    private double[] x;
    private double[] y;
    private double[][] beta;
    private int degree = 2;

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = Math.max(degree, 2);
    }

    public PolynomialRegression(double[] x, double[] y) {
        this(x, y, 2);
    }

    public PolynomialRegression(double[] x, double[] y, int degree) {
        this.x = x;
        this.y = y;
        this.degree = degree;
        double[][] m = new double[x.length][degree + 1];
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j <= degree; ++j) {
                m[i][j] = Math.pow(x[i], j);
            }
        }
        double[][] Y = this.CreateMatrix(y, y.length);
        QRDecomposition qr = new QRDecomposition(m);
        this.beta = qr.solve(Y);
    }

    private double[][] CreateMatrix(double[] v, int n) {
        int m = v.length;
        int n2 = n = m != 0 ? v.length / m : 0;
        if (m * n != v.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        double[][] A = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                A[i][j] = v[i + j * m];
            }
        }
        return A;
    }

    @Override
    public double Regression(double x) {
        double r = this.beta[0][0];
        double xx = x;
        for (int i = 1; i < this.beta.length; ++i) {
            r += this.beta[i][0] * xx;
            xx *= x;
        }
        return r;
    }

    @Override
    public double[] Regression(double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.beta[0][0];
            double xx = x[i];
            for (int j = 1; j < this.beta.length; ++j) {
                int n = i;
                result[n] = result[n] + this.beta[j][0] * xx;
                xx *= x[i];
            }
        }
        return result;
    }

    @Override
    public double CoefficientOfDetermination() {
        double[] r = this.Regression(this.x);
        return Math.pow(Correlations.PearsonCorrelation(r, this.y), 2.0);
    }

    @Override
    public String toString() {
        String equation = "y = ";
        int p = this.beta.length - 1;
        for (int i = 0; i < this.beta.length; ++i) {
            equation = p != 0 ? equation + String.format("%.4f", this.beta[p][0]) + "x^" + p + " " : equation + String.format("%.4f", this.beta[p][0]);
            --p;
        }
        return equation;
    }
}

