/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Regression;

import Catalano.Statistics.Correlations;
import Catalano.Statistics.Regression.ILinear;
import Catalano.Statistics.Regression.ISimpleRegression;
import Catalano.Statistics.Tools;

public class LinearRegression
implements ISimpleRegression,
ILinear {
    private double[] x;
    private double[] y;
    private double inclination;
    private double interception;

    public LinearRegression(double[] x, double[] y) {
        this.x = x;
        this.y = y;
        this.inclination = Tools.Inclination(x, y);
        this.interception = Tools.Interception(x, y);
    }

    @Override
    public double getInclination() {
        return this.inclination;
    }

    @Override
    public void setInclination(double inclination) {
        this.inclination = inclination;
    }

    @Override
    public double getInterception() {
        return this.interception;
    }

    @Override
    public void setInterception(double interception) {
        this.interception = interception;
    }

    @Override
    public double Regression(double x) {
        return this.inclination * x + this.interception;
    }

    @Override
    public double[] Regression(double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = this.inclination * x[i] + this.interception;
        }
        return result;
    }

    @Override
    public double CoefficientOfDetermination() {
        return Math.pow(Correlations.PearsonCorrelation(this.x, this.y), 2.0);
    }

    @Override
    public String toString() {
        if (this.interception >= 0.0) {
            return "y = " + String.format("%.4f", this.inclination) + "x + " + String.format("%.4f", this.interception);
        }
        return "y = " + String.format("%.4f", this.inclination) + "x " + String.format("%.4f", this.interception);
    }
}

