/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Spherical
implements IMercerKernel<double[]> {
    private double sigma;

    public double getSigma() {
        return this.sigma;
    }

    public void setDegree(double value) {
        this.sigma = value;
    }

    public Spherical() {
    }

    public Spherical(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public double Function(double[] x, double[] y) {
        double norm = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double d = x[i] - y[i];
            norm += d * d;
        }
        if ((norm = Math.sqrt(norm)) >= this.sigma) {
            return 0.0;
        }
        return 1.0 - 1.5 * (norm /= this.sigma) + 0.5 * norm * norm * norm;
    }
}

