/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Math.Matrix;
import Catalano.Statistics.Kernels.IMercerKernel;

public class Additive
implements IMercerKernel<double[]> {
    private IMercerKernel[] kernels;
    private double[] weights;

    public Additive(IMercerKernel[] kernels) {
        this(kernels, Matrix.CreateMatrix1D(kernels.length, 1.0));
    }

    public Additive(IMercerKernel[] kernels, double[] weights) {
        this.kernels = kernels;
        this.weights = weights;
    }

    @Override
    public double Function(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < this.kernels.length; ++i) {
            sum += this.weights[i] * this.kernels[i].Function(x, y);
        }
        return sum;
    }
}

