/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics;

import Catalano.Core.IntRange;

public final class HistogramStatistics {
    private HistogramStatistics() {
    }

    public static double Entropy(int[] values) {
        int i;
        int n = values.length;
        int total = 0;
        double entropy = 0.0;
        for (i = 0; i < n; ++i) {
            total += values[i];
        }
        if (total != 0) {
            for (i = 0; i < n; ++i) {
                double p = (double)values[i] / (double)total;
                if (p == 0.0) continue;
                entropy += -p * (Math.log10(p) / Math.log10(2.0));
            }
        }
        return entropy;
    }

    public static IntRange GetRange(int[] values, double percent) {
        int max;
        int min;
        int total = 0;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            total += values[i];
        }
        int h = (int)((double)total * (percent + (1.0 - percent) / 2.0));
        int hits = total;
        for (min = 0; min < n && (hits -= values[min]) >= h; ++min) {
        }
        hits = total;
        for (max = n - 1; max >= 0 && (hits -= values[max]) >= h; --max) {
        }
        return new IntRange(min, max);
    }

    public static double Kurtosis(int[] values) {
        double mean = HistogramStatistics.Mean(values);
        double std = HistogramStatistics.StdDev(values, mean);
        return HistogramStatistics.Kurtosis(values, mean, std);
    }

    public static double Kurtosis(int[] values, double mean, double stdDeviation) {
        double n = 0.0;
        for (int i = 0; i < values.length; ++i) {
            n += (double)values[i];
        }
        double part1 = n * (n + 1.0);
        part1 /= (n - 1.0) * (n - 2.0) * (n - 3.0);
        double part2 = 0.0;
        for (int i = 0; i < values.length; ++i) {
            part2 += Math.pow(((double)i - mean) / stdDeviation, 4.0) * (double)values[i];
        }
        double part3 = 3.0 * Math.pow(n - 1.0, 2.0);
        return part1 * part2 - (part3 /= (n - 2.0) * (n - 3.0));
    }

    public static double Mean(int[] values) {
        long total = 0L;
        double mean = 0.0;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            int hits = values[i];
            mean += (double)(i * hits);
            total += (long)hits;
        }
        return total == 0L ? 0.0 : mean / (double)total;
    }

    public static int Median(int[] values) {
        int median;
        int total = 0;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            total += values[i];
        }
        int halfTotal = total / 2;
        int v = 0;
        for (median = 0; median < n && (v += values[median]) < halfTotal; ++median) {
        }
        return median;
    }

    public static int Mode(int[] values) {
        int mode = 0;
        int curMax = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            if (values[i] <= curMax) continue;
            curMax = values[i];
            mode = i;
        }
        return mode;
    }

    public static double Skewness(int[] values) {
        double mean = HistogramStatistics.Mean(values);
        double std = HistogramStatistics.StdDev(values, mean);
        return HistogramStatistics.Skewness(values, mean, std);
    }

    public static double Skewness(int[] values, double mean, double stdDeviation) {
        double n = 0.0;
        for (int i = 0; i < values.length; ++i) {
            n += (double)values[i];
        }
        double part1 = n / (n - 1.0) * (n - 2.0);
        double part2 = 0.0;
        for (int i = 0; i < values.length; ++i) {
            part2 += Math.pow(((double)i - mean) / stdDeviation, 3.0) * (double)values[i];
        }
        return part1 * part2;
    }

    public static double StdDev(int[] values) {
        return HistogramStatistics.StdDev(values, HistogramStatistics.Mean(values));
    }

    public static double StdDev(int[] values, double mean) {
        double stddev = 0.0;
        int total = 0;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            int hits = values[i];
            double diff = (double)i - mean;
            stddev += diff * diff * (double)hits;
            total += hits;
        }
        return total == 0 ? 0.0 : Math.sqrt(stddev / (double)(total - 1));
    }
}

