/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics;

import Catalano.Statistics.HistogramStatistics;

public class Histogram {
    private int[] values;
    private double mean = 0.0;
    private double stdDev = 0.0;
    private double entropy = 0.0;
    private int median = 0;
    private int mode;
    private int min;
    private int max;
    private long total;
    private int bins = 10;

    public static int[] MatchHistograms(int[] histA, int[] histB) {
        int length = histA.length;
        double[] PA = Histogram.CDF(histA);
        double[] PB = Histogram.CDF(histB);
        int[] F = new int[length];
        for (int a = 0; a < length; ++a) {
            int j = length - 1;
            do {
                F[a] = j--;
            } while (j >= 0 && PA[a] <= PB[j]);
        }
        return F;
    }

    public static int[] MatchHistograms(Histogram histA, Histogram histB) {
        return Histogram.MatchHistograms(histA.values, histB.values);
    }

    public static double[] CDF(int[] values) {
        int length = values.length;
        int n = 0;
        for (int i = 0; i < length; ++i) {
            n += values[i];
        }
        double[] P = new double[length];
        int c = values[0];
        P[0] = (double)c / (double)n;
        for (int i = 1; i < length; ++i) {
            P[i] = (double)(c += values[i]) / (double)n;
        }
        return P;
    }

    public static double[] CDF(Histogram hist) {
        return Histogram.CDF(hist.values);
    }

    public static double[] Normalize(int[] values) {
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        double[] norm = new double[values.length];
        for (int i = 0; i < norm.length; ++i) {
            norm[i] = (double)values[i] / (double)sum;
        }
        return norm;
    }

    public Histogram(int[] values) {
        this.values = values;
        this.update();
    }

    public Histogram(int[] values, int bins) {
        this.values = values;
        this.bins = bins;
        this.update();
    }

    public int[] getValues() {
        return this.values;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getEntropy() {
        return this.entropy;
    }

    public int getMedian() {
        return this.median;
    }

    public int getMode() {
        return this.mode;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public long getTotal() {
        return this.total;
    }

    public int getBins() {
        return this.bins;
    }

    private void update() {
        int n = this.values.length;
        this.max = 0;
        this.min = n;
        this.total = 0L;
        int maxVal = -2147483647;
        int minVal = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            if (this.values[i] == 0) continue;
            if (i > this.max) {
                this.max = i;
            }
            if (i < this.min) {
                this.min = i;
            }
            maxVal = Math.max(maxVal, this.values[i]);
            minVal = Math.min(minVal, this.values[i]);
            this.total += (long)this.values[i];
        }
        double k = (double)(maxVal - minVal) / (double)this.bins;
        int[] h = new int[this.bins];
        for (int j = 0; j < this.values.length; ++j) {
            double _min = minVal;
            double _max = _min + k;
            if ((double)this.values[j] >= _min && (double)this.values[j] <= _max) {
                h[0] = h[0] + 1;
            }
            _min += k;
            _max += k;
            for (int l = 1; l < this.bins; ++l) {
                if ((double)this.values[j] > _min && (double)this.values[j] <= _max) {
                    int n2 = l;
                    h[n2] = h[n2] + 1;
                }
                _min += k;
                _max += k;
            }
        }
        this.values = h;
        this.mean = HistogramStatistics.Mean(this.values);
        this.stdDev = HistogramStatistics.StdDev(this.values, this.mean);
        this.median = HistogramStatistics.Median(this.values);
        this.mode = HistogramStatistics.Mode(this.values);
        this.entropy = HistogramStatistics.Entropy(this.values);
    }

    public double[] Normalize() {
        double[] h = new double[this.values.length];
        for (int i = 0; i < h.length; ++i) {
            h[i] = (double)this.values[i] / (double)this.total;
        }
        return h;
    }
}

