/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDistribution;

public class RayleighDistribution
implements IDistribution {
    private double sigma;

    public RayleighDistribution(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public double Mean() {
        return this.sigma * Math.sqrt(1.5707963267948966);
    }

    @Override
    public double Variance() {
        return 0.42920367320510344 * this.sigma * this.sigma;
    }

    @Override
    public double Entropy() {
        return 1.0 + Math.log(this.sigma / 1.4142135623730951) + 0.28860783245076643;
    }

    @Override
    public double DistributionFunction(double x) {
        return 1.0 - Math.exp(-x * x / (2.0 * this.sigma * this.sigma));
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        return x / (this.sigma * this.sigma) * Math.exp(-x * x / (2.0 * this.sigma * this.sigma));
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        return Math.log(x / (this.sigma * this.sigma)) + -x * x / (2.0 * this.sigma * this.sigma);
    }
}

