/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Functions.Gamma;
import Catalano.Statistics.Distributions.IDistribution;

public class NakagamiDistribution
implements IDistribution {
    private double mu;
    private double omega;
    private Double mean;
    private Double variance;
    private double constant;
    private double nratio;
    private double twoMu1;

    public NakagamiDistribution(double shape, double spread) {
        if (shape < 0.5) {
            try {
                throw new IllegalArgumentException("Shape parameter (mu) should be greater than or equal to 0.5.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (spread <= 0.0) {
            try {
                throw new IllegalArgumentException("Spread parameter (omega) should be greater than 0.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mu = shape;
        this.omega = spread;
        this.init(shape, spread);
    }

    private void init(double shape, double spread) {
        double twoMuMu = 2.0 * Math.pow(shape, shape);
        double gammaMu = Gamma.Function(shape);
        double spreadMu = Math.pow(spread, shape);
        this.nratio = -shape / spread;
        this.twoMu1 = 2.0 * shape - 1.0;
        this.constant = twoMuMu / (gammaMu * spreadMu);
        this.mean = null;
        this.variance = null;
    }

    public double getShape() {
        return this.mu;
    }

    public double getSpread() {
        return this.omega;
    }

    @Override
    public double Mean() {
        if (this.mean == null) {
            this.mean = Gamma.Function(this.mu + 0.5) / Gamma.Function(this.mu) * Math.sqrt(this.omega / this.mu);
        }
        return this.mean;
    }

    @Override
    public double Variance() {
        if (this.variance == null) {
            double a = Gamma.Function(this.mu + 0.5) / Gamma.Function(this.mu);
            this.variance = this.omega * (1.0 - 1.0 / this.mu * (a * a));
        }
        return this.variance;
    }

    @Override
    public double Entropy() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double DistributionFunction(double x) {
        return Gamma.LowerIncomplete(this.mu, this.mu / this.omega * (x * x));
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        return this.constant * Math.pow(x, this.twoMu1) * Math.exp(this.nratio * x * x);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        return Math.log(this.constant) + this.twoMu1 * Math.log(x) + this.nratio * x * x;
    }
}

