/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Special;
import Catalano.Statistics.Distributions.IDistribution;

public class LognormalDistribution
implements IDistribution {
    private double location = 0.0;
    private double shape = 1.0;
    private Double mean;
    private Double variance;
    private Double entropy;
    private double shape2;
    private double constant;

    public LognormalDistribution() {
        this.init(this.location, this.shape, this.shape * this.shape);
    }

    public LognormalDistribution(double location) {
        this.init(location, this.shape, this.shape * this.shape);
    }

    public LognormalDistribution(double location, double shape) {
        this.init(location, shape, shape * shape);
    }

    private void init(double mu, double dev, double var) {
        this.location = mu;
        this.shape = dev;
        this.shape2 = var;
        this.constant = 1.0 / (2.5066282746310007 * dev);
    }

    public double getShape() {
        return this.shape;
    }

    public double getLocation() {
        return this.location;
    }

    @Override
    public double Mean() {
        if (this.mean == null) {
            this.mean = Math.exp(this.location + this.shape2 / 2.0);
        }
        return this.mean;
    }

    @Override
    public double Variance() {
        if (this.variance == null) {
            this.variance = (Math.exp(this.shape2) - 1.0) * Math.exp(2.0 * this.location + this.shape2);
        }
        return this.variance;
    }

    @Override
    public double Entropy() {
        if (this.entropy == null) {
            this.entropy = 0.5 + 0.5 * Math.log(Math.PI * 2 * this.shape2) + this.location;
        }
        return this.entropy;
    }

    @Override
    public double DistributionFunction(double x) {
        double z = (Math.log(x) - this.location) / this.shape;
        return 0.5 * Special.Erfc(-z / 1.4142135623730951);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        double z = (Math.log(x) - this.location) / this.shape;
        return this.constant * Math.exp(-z * z * 0.5) / x;
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        double z = (Math.log(x) - this.location) / this.shape;
        return Math.log(this.constant) + -z * z * 0.5 - Math.log(x);
    }
}

