/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Functions.Beta;
import Catalano.Statistics.Distributions.IDistribution;

public class FisherDistribution
implements IDistribution {
    private int d1;
    private int d2;
    private double b;
    private Double mean;
    private Double variance;

    public FisherDistribution(int degrees1, int degrees2) {
        if (degrees1 <= 0) {
            try {
                throw new IllegalArgumentException("Degrees of freedom must be positive.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (degrees2 <= 0) {
            try {
                throw new IllegalArgumentException("Degrees of freedom must be positive.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.d1 = degrees1;
        this.d2 = degrees2;
        this.b = Beta.Function((double)degrees1 * 0.5, (double)degrees2 * 0.5);
    }

    public int getDegreesOfFreedom1() {
        return this.d1;
    }

    public int getDegreesOfFreedom2() {
        return this.d2;
    }

    @Override
    public double Mean() {
        if (this.mean == null) {
            this.mean = this.d2 <= 2 ? Double.valueOf(Double.NaN) : Double.valueOf((double)this.d2 / ((double)this.d2 - 2.0));
        }
        return this.mean;
    }

    @Override
    public double Variance() {
        if (this.variance == null) {
            this.variance = this.d2 <= 4 ? Double.valueOf(Double.NaN) : Double.valueOf(2.0 * (double)this.d2 * (double)this.d2 * (double)(this.d1 + this.d2 - 2) / (double)(this.d1 * (this.d2 - 2) * (this.d2 - 2) * (this.d2 - 4)));
        }
        return this.variance;
    }

    @Override
    public double Entropy() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double DistributionFunction(double x) {
        double u = (double)this.d1 * x / ((double)this.d1 * x + (double)this.d2);
        return Beta.Incomplete((double)this.d1 * 0.5, (double)this.d2 * 0.5, u);
    }

    public double ComplementaryDistributionFunction(double x) {
        double u = (double)this.d1 / ((double)this.d1 * x + (double)this.d2);
        return Beta.Incomplete((double)this.d2 * 0.5, (double)this.d1 * 0.5, u);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        double u = Math.pow((double)this.d1 * x, this.d1) * Math.pow(this.d2, this.d2) / Math.pow((double)this.d1 * x + (double)this.d2, this.d1 + this.d2);
        return Math.sqrt(u) / (x * this.b);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        double lnu = (double)this.d1 * Math.log((double)this.d1 * x) + (double)this.d2 * Math.log(this.d2) - (double)(this.d1 + this.d2) * Math.log((double)this.d1 * x + (double)this.d2);
        return 0.5 * lnu - Math.log(x * this.b);
    }
}

