/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDistribution;
import Catalano.Statistics.Tools;

public class EmpiricalDistribution
implements IDistribution {
    private double[] samples;
    private Double smoothing;
    private Double mean;
    private Double variance;
    private Double entropy;

    public EmpiricalDistribution(double[] samples) {
        this.initialize(samples, null);
    }

    public EmpiricalDistribution(double[] samples, double smoothing) {
        this.initialize(samples, smoothing);
    }

    private void initialize(double[] observations, Double smoothing) {
        if (smoothing == null) {
            double sigma = Tools.StandartDeviation(observations);
            smoothing = sigma * Math.pow(4.0 / (3.0 * (double)observations.length), -0.2);
        }
        this.samples = observations;
        this.smoothing = (double)smoothing;
        this.mean = null;
        this.variance = null;
    }

    public double[] getSamples() {
        return this.samples;
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    @Override
    public double Mean() {
        if (this.mean == null) {
            this.mean = Tools.Mean(this.samples);
        }
        return this.mean;
    }

    @Override
    public double Variance() {
        if (this.variance == null) {
            this.variance = Tools.Variance(this.samples);
        }
        return this.variance;
    }

    @Override
    public double Entropy() {
        if (this.entropy == null) {
            this.entropy = 0.0;
            for (int i = 0; i < this.samples.length; ++i) {
                double p = this.ProbabilityDensityFunction(this.samples[i]);
                this.entropy = this.entropy + p * Math.log(p);
            }
        }
        return this.entropy;
    }

    @Override
    public double DistributionFunction(double x) {
        int sum = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            if (!(this.samples[i] <= x)) continue;
            ++sum;
        }
        return (double)sum / (double)this.samples.length;
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        double p = 0.0;
        for (int i = 0; i < this.samples.length; ++i) {
            double z = (x - this.samples[i]) / this.smoothing;
            p += Math.exp(-z * z * 0.5);
        }
        return (p *= 1.0 / (2.5066282746310007 * this.smoothing)) / (double)this.samples.length;
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        double p = 0.0;
        for (int i = 0; i < this.samples.length; ++i) {
            double z = (x - this.samples[i]) / this.smoothing;
            p += Math.exp(-z * z * 0.5);
        }
        double logp = Math.log(p) - Math.log(2.5066282746310007 * this.smoothing);
        return logp - Math.log(this.samples.length);
    }
}

