/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDiscreteDistribution;

public class DiscreteUniformDistribution
implements IDiscreteDistribution {
    private int a;
    private int b;
    private int n;

    public double getMinimum() {
        return this.a;
    }

    public double getMaximum() {
        return this.a;
    }

    public double getLength() {
        return this.n;
    }

    public DiscreteUniformDistribution(int a, int b) {
        if (a > b) {
            throw new IllegalArgumentException("The starting number a must be lower than b.");
        }
        this.a = a;
        this.b = b;
        this.n = b - a + 1;
    }

    @Override
    public double Mean() {
        return (double)(this.a + this.b) / 2.0;
    }

    @Override
    public double Variance() {
        return (double)((this.b - this.a) * (this.b - this.a)) / 12.0;
    }

    @Override
    public double Entropy() {
        return Math.log(this.b - this.a);
    }

    @Override
    public double DistributionFunction(int k) {
        if (k < this.a) {
            return 0.0;
        }
        if (k >= this.b) {
            return 1.0;
        }
        return ((double)(k - this.a) + 1.0) / (double)this.n;
    }

    @Override
    public double ProbabilityMassFunction(int k) {
        if (k >= this.a && k <= this.b) {
            return 1.0 / (double)this.n;
        }
        return 0.0;
    }

    @Override
    public double LogProbabilityMassFunction(int k) {
        if (k >= this.a && k <= this.b) {
            return -Math.log(this.n);
        }
        return Double.NEGATIVE_INFINITY;
    }
}

